/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.schema.Facet;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.UserSimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;

public abstract class ScaleFacet
extends Facet {
    private int requiredValue;

    public void setValue(String value) throws SchemaException {
        this.requiredValue = Integer.parseInt(value);
    }

    public String getValue() {
        return this.requiredValue + "";
    }

    public int getNumericValue() {
        return this.requiredValue;
    }

    public void setNumericValue(int value) {
        this.requiredValue = value;
    }

    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException, ValidationException {
        if (!base.isAtomicType()) {
            throw new SchemaException("The " + this.getName() + " facet is not available on the non-atomic type " + type.getDescription());
        }
        int primitive = ((AtomicType)base).getPrimitiveType();
        if (primitive != 532) {
            throw new SchemaException("The " + this.getName() + " facet is not allowed on a type derived from the type " + base.getDescription());
        }
    }
}

