/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.schema.Assertion;
import com.saxonica.schema.Facet;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.schema.UserSimpleType;
import net.sf.saxon.Configuration;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class PreprocessFacet
extends Facet {
    Configuration config;
    Assertion action;
    Assertion reverseAction;

    public PreprocessFacet() {
    }

    public PreprocessFacet(Assertion action, Assertion reverseAction) {
        this.action = action;
        this.reverseAction = reverseAction;
    }

    public boolean isConstraining() {
        return false;
    }

    public String getName() {
        return "preprocess";
    }

    public String getValue() {
        return null;
    }

    public Assertion getAction() {
        return this.action;
    }

    public Assertion getReverseAction() {
        return this.reverseAction;
    }

    public void setAction(Assertion action) {
        this.action = action;
    }

    public void setReverseAction(Assertion action) {
        this.reverseAction = action;
    }

    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException, ValidationException {
    }

    public CharSequence preprocess(CharSequence input) throws ValidationException {
        XPathExpression exp = this.action.getCondition();
        try {
            XPathDynamicContext context = exp.createDynamicContext();
            if (this.action.getValueVariable() != null) {
                context.setVariable(this.action.getValueVariable(), new StringValue(input));
            }
            return exp.evaluateSingle(context).getStringValueCS();
        }
        catch (XPathException err) {
            throw new ValidationException(err);
        }
    }

    public CharSequence postprocess(CharSequence input) throws ValidationException {
        if (this.reverseAction == null) {
            return input;
        }
        XPathExpression exp = this.reverseAction.getCondition();
        try {
            XPathDynamicContext context = exp.createDynamicContext();
            if (this.action.getValueVariable() != null) {
                context.setVariable(this.reverseAction.getValueVariable(), new StringValue(input));
            }
            return exp.evaluateSingle(context).getStringValueCS();
        }
        catch (XPathException err) {
            throw new ValidationException(err);
        }
    }

    public boolean testAtomicValue(AtomicValue value) {
        return true;
    }

    public void serializeFacet(SchemaModelSerializer serializer) throws XPathException {
        serializer.startElement(this.getName());
        if (this.isFixed()) {
            serializer.emitAttribute("fixed", "true");
        }
        this.action.serialize(serializer);
        if (this.reverseAction != null) {
            this.reverseAction.serialize(serializer);
        }
        serializer.endElement();
    }
}

