/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.schema.Facet;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.UserSimpleType;
import net.sf.saxon.Configuration;
import net.sf.saxon.functions.regex.JRegularExpression;
import net.sf.saxon.functions.regex.RegularExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class PatternFacet
extends Facet {
    Configuration config;
    StringValue requiredValue;
    RegularExpression regex;
    boolean noMerge;

    public PatternFacet(Configuration config) {
        this.config = config;
    }

    public String getName() {
        return "pattern";
    }

    public String getValue() {
        return this.requiredValue.getStringValue();
    }

    public void setValue(String value) throws SchemaException {
        this.requiredValue = StringValue.makeStringValue(value);
        try {
            int flagBits = JRegularExpression.setFlags("");
            int options = this.config.getXMLVersion() == 10 ? 0 : 1;
            this.regex = new JRegularExpression(value, options, flagBits);
        }
        catch (XPathException e) {
            throw new SchemaException(e.getMessage());
        }
    }

    public void setDoNotMerge(boolean dont) {
        this.noMerge = dont;
    }

    public boolean isDoNotMerge() {
        return this.noMerge;
    }

    public void addBranch(String pat) {
        try {
            this.setValue('(' + this.getValue() + ")|(" + pat + ')');
        }
        catch (SchemaException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException {
    }

    public boolean testAtomicValue(AtomicValue value) {
        return this.regex.matches(value.getCanonicalLexicalRepresentation());
    }
}

