/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.schema.SchemaStructure;
import com.saxonica.schema.SerializableSchemaComponent;
import com.saxonica.schema.UserSchemaComponent;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;

public class Notation
extends SchemaStructure
implements UserSchemaComponent,
SerializableSchemaComponent {
    private String notationSystemId;
    private int nameCode;
    private String notationPublicId;

    public Notation(EnterpriseConfiguration config, SourceLocator locator) {
        this.setConfiguration(config);
        this.setLocator(locator);
    }

    public void setNameCode(int nameCode) {
        this.nameCode = nameCode;
    }

    public int getFingerprint() {
        return this.nameCode & 0xFFFFF;
    }

    public void setNotationSystemId(String systemId) {
        this.notationSystemId = systemId;
    }

    public void setNotationPublicId(String publicId) {
        this.notationPublicId = publicId;
    }

    public String getNotationSystemId() {
        return this.notationSystemId;
    }

    public String getNotationPublicId() {
        return this.notationPublicId;
    }

    public String getName() {
        return this.getConfiguration().getNamePool().getLocalName(this.nameCode);
    }

    public String getTargetNamespace() {
        return this.getConfiguration().getNamePool().getURI(this.nameCode);
    }

    public boolean validate(SchemaCompiler compiler) {
        return true;
    }

    public boolean fixup(SchemaCompiler compiler) throws SchemaException {
        this.setFixupStatus(3);
        return true;
    }

    public void elaborate(SchemaCompiler compiler) throws SchemaException {
    }

    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        String id = serializer.getId(this, true);
        serializer.startElement("notation");
        serializer.emitAttribute("id", id);
        serializer.emitAttribute("name", this.getName());
        if (this.getTargetNamespace() != null && this.getTargetNamespace().length() > 0) {
            serializer.emitAttribute("targetNamespace", this.getTargetNamespace());
        }
        if (this.notationPublicId != null) {
            serializer.emitAttribute("publicId", this.notationPublicId);
        }
        if (this.notationSystemId != null) {
            serializer.emitAttribute("systemId", this.notationSystemId);
        }
        serializer.endElement();
    }
}

