/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.AllModelGroup;
import com.saxonica.schema.ComponentReference;
import com.saxonica.schema.ModelGroup;
import com.saxonica.schema.ModelGroupDefinition;
import com.saxonica.schema.Particle;
import com.saxonica.schema.PreparedSchema;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.schema.Term;
import com.saxonica.schema.UnresolvedReferenceExceptionImpl;
import java.util.List;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.sort.IntHashSet;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UnresolvedReferenceException;
import net.sf.saxon.value.Cardinality;

public class ModelGroupParticle
extends Particle
implements ComponentReference {
    public ModelGroupParticle(EnterpriseConfiguration config, SourceLocator locator) {
        this.setLocator(locator);
        this.setConfiguration(config);
    }

    public boolean isResolved() {
        return this.target != null;
    }

    public ModelGroup getGroup() throws UnresolvedReferenceException {
        return (ModelGroup)this.getTarget();
    }

    public int getSymbolSpace() {
        return 804;
    }

    public boolean isEmptiable() throws UnresolvedReferenceException {
        if (this.getMinOccurs() == 0) {
            return true;
        }
        return this.getGroup().isEmptiable();
    }

    public boolean fixup(SchemaCompiler compiler) throws SchemaException {
        SchemaComponent decl = PreparedSchema.validateReference(this, compiler);
        if (decl == null) {
            this.setFixupStatus(4);
            return false;
        }
        this.lookForCycles(new Stack(), compiler);
        this.setFixupStatus(3);
        return true;
    }

    public void lookForCycles(Stack references, SchemaCompiler compiler) throws SchemaException, UnresolvedReferenceException {
        if (references.contains(this)) {
            String err = "The definition of group " + Err.wrap(this.getConfiguration().getNamePool().getDisplayName(this.getFingerprint())) + " is circular";
            throw new SchemaException(err);
        }
        this.tryToResolve(compiler);
        if (this.isResolved()) {
            this.getGroup().lookForCycles(references, compiler);
        }
    }

    public SchemaComponent getTarget() throws UnresolvedReferenceException {
        if (this.target == null) {
            throw new UnresolvedReferenceExceptionImpl(this);
        }
        return this.target;
    }

    public void tryToResolve(SchemaCompiler compiler) {
        if (this.target == null) {
            this.target = compiler.getPreparedSchema().getGroup(this.getFingerprint());
        }
        if (this.target == null) {
            this.target = compiler.getConfiguration().getSuperSchema().getGroup(this.getFingerprint());
        }
    }

    public boolean isPointless(ModelGroup container) {
        return this.getMinOccurs() == 1 && this.getMaxOccurs() == 1 && ((ModelGroup)this.getTarget()).isPointless(container);
    }

    public SchemaType getElementParticleType(int fingerprint) {
        return this.getGroup().getElementParticleType(fingerprint);
    }

    public int getElementParticleCardinality(int fingerprint) {
        int card = this.getGroup().getElementParticleCardinality(fingerprint);
        return Cardinality.multiply(card, ModelGroupParticle.computeParticleCardinality(this.getMinOccurs(), this.getMaxOccurs()));
    }

    public boolean containsElementWildcard() {
        return this.getGroup().containsElementWildcard();
    }

    public void gatherAllPermittedElements(IntHashSet result, boolean ignoreWildcards) throws SchemaException {
        this.getGroup().gatherAllPermittedElements(result, ignoreWildcards);
    }

    public void markVulnerableSubParticles() {
        this.getGroup().markVulnerableSubParticles(this.getMaxOccurs() > 1 || this.getMaxOccurs() == -1);
    }

    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        switch (this.getValidationStatus()) {
            case 3: {
                return true;
            }
            case 4: {
                return false;
            }
            case 2: {
                return false;
            }
        }
        ModelGroup decl = (ModelGroup)PreparedSchema.validateReference(this, compiler);
        if (this.isResolved()) {
            Particle first;
            List<Particle> particles;
            boolean result = decl.validate(compiler);
            if (result && (this.getMaxOccurs() == -1 || this.getMaxOccurs() > 1) && !(particles = decl.getListOfParticles(false)).isEmpty() && (first = particles.get(0)) instanceof ModelGroupParticle && first.getTerm() instanceof AllModelGroup) {
                compiler.error("A group defined using <xs:all> cannot occur more than once", this);
                result = false;
            }
            if (this.getMaxOccurs() > 1 || this.getMaxOccurs() == -1) {
                decl.markVulnerableSubParticles(true);
            }
            return result;
        }
        this.setValidationStatus(4);
        return false;
    }

    public void compile(SchemaCompiler compiler) throws SchemaException {
        ((ModelGroup)this.getTarget()).compile(compiler);
    }

    public Term getTerm() {
        return this.getGroup();
    }

    public void elaborate(SchemaCompiler compiler) throws SchemaException {
        this.getGroup().elaborate(compiler);
    }

    public void serializeParticle(SchemaModelSerializer serializer) throws XPathException {
        serializer.startElement("modelGroupParticle");
        serializer.emitAttribute("minOccurs", "" + this.getMinOccurs());
        serializer.emitAttribute("maxOccurs", this.getMaxOccurs() < 0 ? "unbounded" : "" + this.getMaxOccurs());
        if (this.getGroup() instanceof ModelGroupDefinition) {
            serializer.emitAttribute("ref", serializer.getId(this.getGroup(), false));
        } else {
            this.getGroup().serialize(serializer);
        }
        serializer.endElement();
    }
}

