/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.schema.AllModelGroup;
import com.saxonica.schema.ElementDecl;
import com.saxonica.schema.ElementParticle;
import com.saxonica.schema.ElementWildcard;
import com.saxonica.schema.ModelGroupParticle;
import com.saxonica.schema.Particle;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.schema.SchemaStructure;
import com.saxonica.schema.SequenceModelGroup;
import com.saxonica.schema.Term;
import com.saxonica.schema.UserSchemaComponent;
import com.saxonica.schema.Wildcard;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.expr.sort.IntHashMap;
import net.sf.saxon.expr.sort.IntHashSet;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UnresolvedReferenceException;
import net.sf.saxon.value.Cardinality;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelGroup
extends SchemaStructure
implements UserSchemaComponent,
Term {
    protected List<Particle> contentModel = new ArrayList<Particle>(20);
    protected List<Particle> simplifiedContentModel;

    public abstract String getCompositorName();

    public void addParticle(Particle particle) {
        if (particle != null && (particle.getMinOccurs() != 0 || particle.getMaxOccurs() != 0)) {
            this.contentModel.add(particle);
        }
    }

    public void setContentModel(List particles) {
        this.contentModel = particles;
    }

    public abstract boolean isEmptiable() throws UnresolvedReferenceException;

    public boolean isPointless(ModelGroup container) {
        return this.getSimplifiedContentModel().isEmpty();
    }

    public Iterator<Particle> iterateParticles() {
        return this.contentModel.iterator();
    }

    public List<Particle> getListOfParticles(boolean simplified) {
        return simplified ? this.getSimplifiedContentModel() : this.contentModel;
    }

    public int getContentModelSize() {
        return this.contentModel.size();
    }

    public boolean isEmpty() {
        return !this.iterateParticles().hasNext();
    }

    public boolean containsAll(boolean simplified) throws UnresolvedReferenceException {
        Iterator<Particle> iter;
        if (simplified) {
            List<Particle> model = this.getSimplifiedContentModel();
            iter = model.iterator();
        } else {
            iter = this.contentModel.iterator();
        }
        while (iter.hasNext()) {
            Particle p = iter.next();
            if (!(p instanceof ModelGroupParticle) || !((ModelGroupParticle)p).getGroup().containsAll(simplified)) continue;
            return true;
        }
        return false;
    }

    public List<Particle> getSimplifiedContentModel() {
        if (this.simplifiedContentModel == null) {
            this.simplifiedContentModel = new ArrayList<Particle>(this.contentModel.size());
            for (int i = 0; i < this.contentModel.size(); ++i) {
                Particle p = this.contentModel.get(i);
                if (p instanceof ModelGroupParticle) {
                    ModelGroup mgd = ((ModelGroupParticle)p).getGroup();
                    if (p.isPointless(this)) {
                        this.simplifiedContentModel.addAll(mgd.getSimplifiedContentModel());
                        continue;
                    }
                    if (this instanceof AllModelGroup && mgd instanceof AllModelGroup) {
                        this.simplifiedContentModel.addAll(mgd.getSimplifiedContentModel());
                        continue;
                    }
                    this.simplifiedContentModel.add(p);
                    continue;
                }
                this.simplifiedContentModel.add(p);
            }
        }
        return this.simplifiedContentModel;
    }

    public void markVulnerableSubParticles(boolean isRepeatable) {
        if (isRepeatable) {
            Particle p;
            int i;
            int numberOfOptionalSubParticles = 0;
            for (i = 0; i < this.contentModel.size(); ++i) {
                p = this.contentModel.get(i);
                if (p.getMinOccurs() != 0 && !p.isEmptiable()) continue;
                ++numberOfOptionalSubParticles;
            }
            if (numberOfOptionalSubParticles == this.contentModel.size()) {
                for (i = 0; i < this.contentModel.size(); ++i) {
                    p = this.contentModel.get(i);
                    p.setVulnerable(true);
                }
            } else if (numberOfOptionalSubParticles == this.contentModel.size() - 1) {
                for (i = 0; i < this.contentModel.size(); ++i) {
                    p = this.contentModel.get(i);
                    if (p.getMinOccurs() == 0 || p.isEmptiable()) continue;
                    p.setVulnerable(true);
                    break;
                }
            }
        }
        for (int i = 0; i < this.contentModel.size(); ++i) {
            Particle p = this.contentModel.get(i);
            if (!(p instanceof ModelGroupParticle)) continue;
            p.markVulnerableSubParticles();
        }
    }

    @Override
    public void lookForCycles(Stack references, SchemaCompiler compiler) throws SchemaException, UnresolvedReferenceException {
        references.push(this);
        Iterator<Particle> particles = this.iterateParticles();
        while (particles.hasNext()) {
            Particle particle = particles.next();
            particle.lookForCycles(references, compiler);
        }
        references.pop();
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        boolean result = true;
        Iterator<Particle> parts = this.iterateParticles();
        while (parts.hasNext()) {
            Particle structure = parts.next();
            if (structure instanceof ModelGroupParticle) {
                ModelGroupParticle ref = (ModelGroupParticle)structure;
                ref.tryToResolve(compiler);
                if (ref.isResolved()) {
                    result &= ref.getGroup().validate(compiler);
                    continue;
                }
                String err = "Group " + compiler.getNamePool().getDisplayName(ref.getFingerprint()) + " is referenced, but has not been declared";
                compiler.error(err, this);
                this.setValidationStatus(5);
                return false;
            }
            result &= structure.validate(compiler);
        }
        if (!result) {
            this.setValidationStatus(4);
            return false;
        }
        IntHashMap<ElementDecl> elements = new IntHashMap<ElementDecl>(20);
        if (!(result &= this.checkElements(elements, compiler))) {
            this.setValidationStatus(4);
            return false;
        }
        return true;
    }

    protected boolean checkElements(IntHashMap<ElementDecl> map, SchemaCompiler compiler) throws SchemaException, UnresolvedReferenceException {
        Iterator<Particle> iter = this.iterateParticles();
        HashSet<ElementWildcard> wildcards = new HashSet<ElementWildcard>();
        while (iter.hasNext()) {
            Particle p = iter.next();
            if (p instanceof ModelGroupParticle) {
                boolean b = ((ModelGroupParticle)p).getGroup().checkElements(map, compiler);
                if (b) continue;
                return false;
            }
            if (p instanceof ElementWildcard) {
                wildcards.add((ElementWildcard)p);
                continue;
            }
            if (!(p instanceof ElementParticle)) continue;
            if (!p.isResolved()) {
                String err = "Unresolved reference to element " + Err.wrap(compiler.getNamePool().getDisplayName(p.getNameCode()), 1);
                compiler.error(err, this);
                return false;
            }
            ElementDecl e = ((ElementParticle)p).getDeclaration();
            int key = e.getFingerprint();
            ElementDecl prev = map.get(key);
            if (prev == null) {
                map.put(key, e);
                continue;
            }
            if (!e.getType().equals(prev.getType())) {
                String err = "Two elements in the content model have the same name " + Err.wrap(e.getDisplayName(), 1) + " but different types. " + "This violates the constraint 'Element Declarations Consistent'.";
                compiler.error(err, this);
                return false;
            }
            if (e.hasSameTypeTable(prev)) continue;
            String err = "Two elements in the content model have the same name " + Err.wrap(e.getDisplayName(), 1) + " but different type alternatives. " + "This violates the constraint 'Element Declarations Consistent'.";
            compiler.error(err, this);
            return false;
        }
        Iterator iterM = map.valueIterator();
        while (iterM.hasNext()) {
            ElementDecl e = (ElementDecl)iterM.next();
            if (!e.isGlobal()) continue;
            for (ElementDecl member : e.getSubstitutionGroupMembers()) {
                ElementDecl local = map.get(member.getFingerprint());
                if (local == null || local == member) continue;
                if (!e.getType().isSameType(local.getType())) {
                    String err = "An element " + Err.wrap(member.getDisplayName(), 1) + " appears in the content model both as a local element and also as " + "a member of the substitution group of element " + Err.wrap(e.getDisplayName(), 1) + ", and the two element declarations have different types. " + "This violates the constraint 'Element Declarations Consistent'.";
                    compiler.error(err, this);
                    this.setValidationStatus(4);
                    return false;
                }
                if (e.hasSameTypeTable(local)) continue;
                String err = "An element " + Err.wrap(member.getDisplayName(), 1) + " appears in the content model both as a local element and also as " + "a member of the substitution group of element " + Err.wrap(e.getDisplayName(), 1) + ", and the two element declarations have different type alternatives. " + "This violates the constraint 'Element Declarations Consistent'.";
                compiler.error(err, this);
                return false;
            }
        }
        if (wildcards.isEmpty() || compiler.getConfiguration().getXsdVersion() == 10) {
            return true;
        }
        iterM = map.valueIterator();
        while (iterM.hasNext()) {
            ElementDecl global;
            ElementDecl local = (ElementDecl)iterM.next();
            if (local.isGlobal() || (global = compiler.getPreparedSchema().getElementDecl(local.getFingerprint())) == null) continue;
            for (ElementWildcard wild : wildcards) {
                Wildcard card = wild.getWildcard();
                if (card.getProcessContents().equals("skip") || !card.matches(global.getFingerprint(), true, this.getConfiguration(), null) || local.hasSameTypeTable(global)) continue;
                String err = "A local element " + Err.wrap(local.getDisplayName(), 1) + " appears in the content model that has the same name as a global element " + "declaration that could match a strict or lax wildcard in the content model. " + "The table of type alternatives differs between the local element declaration " + "and the global element declaration, which violates the Element Declarations " + "Consistent constraint.";
                compiler.error(err, this);
                return false;
            }
        }
        return true;
    }

    public SchemaType getElementParticleType(int fingerprint) {
        Iterator<Particle> iter = this.iterateParticles();
        while (iter.hasNext()) {
            Particle p = iter.next();
            SchemaType t = p.getElementParticleType(fingerprint);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public int getElementParticleCardinality(int fingerprint) {
        Iterator<Particle> iter = this.iterateParticles();
        int card = 8192;
        while (iter.hasNext()) {
            Particle p = iter.next();
            int t = p.getElementParticleCardinality(fingerprint);
            if (t == 8192) continue;
            if (this instanceof SequenceModelGroup) {
                card = Cardinality.sum(card, t);
                continue;
            }
            card = Cardinality.union(card, t);
        }
        return card;
    }

    public boolean containsElementWildcard() {
        Iterator<Particle> iter = this.iterateParticles();
        while (iter.hasNext()) {
            Particle p = iter.next();
            if (!p.containsElementWildcard()) continue;
            return true;
        }
        return false;
    }

    public void gatherAllPermittedElements(IntHashSet result, boolean ignoreWildcards) throws SchemaException {
        Iterator<Particle> iter = this.iterateParticles();
        while (iter.hasNext()) {
            Particle p = iter.next();
            p.gatherAllPermittedElements(result, ignoreWildcards);
        }
    }

    public void compile(SchemaCompiler compiler) throws SchemaException {
        Iterator<Particle> iter = this.iterateParticles();
        while (iter.hasNext()) {
            iter.next().compile(compiler);
        }
    }

    @Override
    public boolean fixup(SchemaCompiler compiler) throws SchemaException, UnresolvedReferenceException {
        if (this.getFixupStatus() == 0) {
            this.setFixupStatus(2);
            for (Particle p : this.contentModel) {
                p.fixup(compiler);
            }
            this.lookForCycles(new Stack(), compiler);
        }
        this.setFixupStatus(3);
        return true;
    }

    public Term getTerm() {
        return this;
    }

    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        String compositor = this.getCompositorName();
        serializer.startElement(compositor);
        Iterator<Particle> iter = this.iterateParticles();
        while (iter.hasNext()) {
            Particle p = iter.next();
            p.serializeParticle(serializer);
        }
        serializer.endElement();
    }
}

