/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.schema.Facet;
import com.saxonica.schema.LengthRangeFacet;
import com.saxonica.schema.MaxLengthFacet;
import com.saxonica.schema.MinLengthFacet;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.UserSimpleType;
import net.sf.saxon.type.BuiltInListType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;

public class LengthFacet
extends LengthRangeFacet {
    public String getName() {
        return "length";
    }

    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException, ValidationException {
        Facet maxLength;
        Facet minLength;
        if (base instanceof UserSimpleType) {
            UserSimpleType ubase = (UserSimpleType)base;
            Facet baseFacet = ubase.getFacet(LengthFacet.class);
            if (baseFacet != null && this.requiredLength != ((LengthFacet)baseFacet).requiredLength) {
                throw new SchemaException("In a type derived by restriction, the length facet must not be changed");
            }
            baseFacet = ubase.getFacet(MinLengthFacet.class);
            if (baseFacet != null) {
                if ((long)this.requiredLength < baseFacet.toLong()) {
                    throw new SchemaException("In a type derived by restriction, the length facet is shorter than the minLength of the base type");
                }
                if (baseFacet.isFixed() && (long)this.requiredLength != baseFacet.toLong()) {
                    throw new SchemaException("The minLength facet is fixed in the base type and cannot be varied");
                }
            }
            if ((baseFacet = ubase.getFacet(MaxLengthFacet.class)) != null) {
                if ((long)this.requiredLength > baseFacet.toLong()) {
                    throw new SchemaException("In a type derived by restriction, the length facet is longer than the maxLength of the base type");
                }
                if (baseFacet.isFixed() && (long)this.requiredLength != baseFacet.toLong()) {
                    throw new SchemaException("The maxLength facet is fixed in the base type and cannot be varied");
                }
            }
        }
        if ((minLength = type.getFacet(MinLengthFacet.class)) != null) {
            if (minLength.toLong() > (long)this.requiredLength) {
                throw new SchemaException("The minLength facet is longer than the length facet");
            }
            long thisMin = minLength.toLong();
            SchemaType parent = base;
            boolean ok = false;
            while (parent instanceof UserSimpleType) {
                Facet parentMinLength = ((UserSimpleType)parent).getFacet(MinLengthFacet.class);
                if (parentMinLength != null && parentMinLength.toLong() == thisMin && ((UserSimpleType)parent).getFacet(LengthFacet.class) == null) {
                    ok = true;
                    break;
                }
                parent = parent.getBaseType();
            }
            if (thisMin == 1L && parent instanceof BuiltInListType) {
                ok = true;
            }
            if (!ok) {
                throw new SchemaException("A type cannot have both a length and a minLength facet unless it is derived from a type having the same minLength and no length facet");
            }
        }
        if ((maxLength = type.getFacet(MaxLengthFacet.class)) != null) {
            if (maxLength.toLong() < (long)this.requiredLength) {
                throw new SchemaException("The maxLength facet is shorter than the length facet");
            }
            long thisMax = maxLength.toLong();
            SchemaType parent = base;
            boolean ok = false;
            while (parent instanceof UserSimpleType) {
                Facet parentMaxLength = ((UserSimpleType)parent).getFacet(MaxLengthFacet.class);
                if (parentMaxLength != null && parentMaxLength.toLong() == thisMax && ((UserSimpleType)parent).getFacet(LengthFacet.class) == null) {
                    ok = true;
                    break;
                }
                parent = parent.getBaseType();
            }
            if (!ok) {
                throw new SchemaException("A type cannot have both a length and a maxLength facet unless it is derived from a type having the same maxLength and no length facet");
            }
        }
    }

    public boolean testLength(int actualLength) {
        return actualLength == this.requiredLength;
    }
}

