/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.DigitsFacet;
import com.saxonica.schema.EnumerationFacet;
import com.saxonica.schema.ExplicitTimezoneFacet;
import com.saxonica.schema.FractionDigitsFacet;
import com.saxonica.schema.LengthFacet;
import com.saxonica.schema.MaxExclusiveFacet;
import com.saxonica.schema.MaxInclusiveFacet;
import com.saxonica.schema.MaxLengthFacet;
import com.saxonica.schema.MaxScaleFacet;
import com.saxonica.schema.MinExclusiveFacet;
import com.saxonica.schema.MinInclusiveFacet;
import com.saxonica.schema.MinLengthFacet;
import com.saxonica.schema.MinScaleFacet;
import com.saxonica.schema.PatternFacet;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.schema.TotalDigitsFacet;
import com.saxonica.schema.UserSimpleType;
import com.saxonica.schema.WhitespaceFacet;
import java.io.Serializable;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Value;

public abstract class Facet
implements Serializable {
    private boolean fixed = false;
    private String message = null;

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public boolean isConstraining() {
        return true;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public abstract String getName();

    public abstract String getValue();

    public long toLong() throws NumberFormatException {
        return Long.parseLong(this.getValue());
    }

    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException, ValidationException {
    }

    public boolean isNewlyIntroduced(SimpleType base) {
        Class<?> thisClass = this.getClass();
        if (base instanceof UserSimpleType) {
            Facet f = ((UserSimpleType)base).getFacet(thisClass);
            return f == null || !this.getValue().equals(f.getValue());
        }
        return true;
    }

    public abstract boolean testAtomicValue(AtomicValue var1);

    public boolean testListValue(Value value) {
        throw new UnsupportedOperationException("The " + this.getName() + " facet is not applicable to list values");
    }

    public boolean testLength(int count) {
        return true;
    }

    public int getWhitespaceAction() {
        return 0;
    }

    public void serializeFacet(SchemaModelSerializer serializer) throws XPathException {
        serializer.startElement(this.getName());
        if (this.getValue() == null) {
            throw new NullPointerException("*** Facet " + this.getName() + " has no value");
        }
        serializer.emitAttribute("value", this.getValue());
        if (this.isFixed()) {
            serializer.emitAttribute("fixed", "true");
        }
        if (this.message != null) {
            serializer.emitAttribute("message", this.message);
        }
        serializer.endElement();
    }

    public static boolean isFacetName(String name, int xsdVersion) {
        return "assertion".equals(name) && xsdVersion == 11 || "enumeration".equals(name) || "length".equals(name) || "pattern".equals(name) || "maxExclusive".equals(name) || "minExclusive".equals(name) || "maxInclusive".equals(name) || "minInclusive".equals(name) || "maxLength".equals(name) || "minLength".equals(name) || "maxScale".equals(name) || "minScale".equals(name) || "whiteSpace".equals(name) || "totalDigits".equals(name) || "fractionDigits".equals(name) || "explicitTimezone".equals(name) && xsdVersion == 11;
    }

    public static Facet makeFacet(String name, String value, EnterpriseConfiguration config, NamespaceResolver resolver) throws SchemaException {
        if (name.equals("pattern")) {
            PatternFacet lf = new PatternFacet(config);
            lf.setValue(value);
            return lf;
        }
        if (name.equals("enumeration")) {
            EnumerationFacet ef = new EnumerationFacet();
            ef.setValue(value);
            ef.setNamespaceContext(resolver);
            return ef;
        }
        if (name.equals("length")) {
            LengthFacet lf = new LengthFacet();
            lf.setValue(value);
            return lf;
        }
        if (name.equals("minLength")) {
            MinLengthFacet lf = new MinLengthFacet();
            lf.setValue(value);
            return lf;
        }
        if (name.equals("maxLength")) {
            MaxLengthFacet lf = new MaxLengthFacet();
            lf.setValue(value);
            return lf;
        }
        if (name.equals("minInclusive")) {
            MinInclusiveFacet vrf = new MinInclusiveFacet();
            vrf.setValue(value);
            return vrf;
        }
        if (name.equals("maxInclusive")) {
            MaxInclusiveFacet vrf = new MaxInclusiveFacet();
            vrf.setValue(value);
            return vrf;
        }
        if (name.equals("minExclusive")) {
            MinExclusiveFacet vrf = new MinExclusiveFacet();
            vrf.setValue(value);
            return vrf;
        }
        if (name.equals("maxExclusive")) {
            MaxExclusiveFacet vrf = new MaxExclusiveFacet();
            vrf.setValue(value);
            return vrf;
        }
        if (name.equals("totalDigits")) {
            TotalDigitsFacet df = new TotalDigitsFacet();
            ((DigitsFacet)df).setValue(value);
            return df;
        }
        if (name.equals("fractionDigits")) {
            FractionDigitsFacet df = new FractionDigitsFacet();
            ((DigitsFacet)df).setValue(value);
            return df;
        }
        if (name.equals("explicitTimezone")) {
            ExplicitTimezoneFacet tf = new ExplicitTimezoneFacet();
            tf.setValue(value);
            return tf;
        }
        if (name.equals("minScale")) {
            MinScaleFacet lf = new MinScaleFacet();
            lf.setValue(value);
            return lf;
        }
        if (name.equals("maxScale")) {
            MaxScaleFacet lf = new MaxScaleFacet();
            lf.setValue(value);
            return lf;
        }
        if (name.equals("whiteSpace")) {
            WhitespaceFacet wf = new WhitespaceFacet();
            wf.setValue(value);
            return wf;
        }
        throw new SchemaException("Unknown facet: " + name);
    }
}

