/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.schema.Facet;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.UserAtomicType;
import com.saxonica.schema.UserSimpleType;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.UnresolvedReferenceException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public class EnumerationFacet
extends Facet {
    private String value;
    NamespaceResolver namespaceContext = null;

    public String getName() {
        return "enumeration";
    }

    public String getValue() {
        return this.value;
    }

    public NamespaceResolver getNamespaceContext() {
        return this.namespaceContext;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Value getTypedValue(SimpleType type, Configuration config) throws SchemaException, UnresolvedReferenceException {
        try {
            ConversionRules rules = config.getConversionRules();
            SequenceIterator iter = type.getTypedValue(this.getValue(), this.namespaceContext, rules);
            return Value.asValue(SequenceExtent.makeSequenceExtent(iter));
        }
        catch (XPathException e) {
            throw new SchemaException(e);
        }
    }

    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException, UnresolvedReferenceException {
        if (base instanceof UserAtomicType) {
            this.getTypedValue(base, type.getConfiguration());
        } else {
            if (this.namespaceContext == null && base.isNamespaceSensitive()) {
                throw new SchemaException("No namespace context available for checking enumeration QName");
            }
            ConversionRules rules = type.getConfiguration().getConversionRules();
            rules.setNotationSet(compiler.getPreparedSchema());
            ValidationFailure err = base.validateContent(this.getValue(), this.namespaceContext, rules);
            if (err != null) {
                throw new SchemaException("Enumeration value " + Err.wrap(this.value) + " is not permitted by the base type " + base.getDescription() + ": " + err.getMessage());
            }
        }
    }

    public void setNamespaceContext(NamespaceResolver map) {
        this.namespaceContext = map;
    }

    public boolean testAtomicValue(AtomicValue value) {
        return true;
    }
}

