/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.ElementDecl;
import com.saxonica.schema.ModelGroup;
import com.saxonica.schema.Particle;
import com.saxonica.schema.PreparedSchema;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.schema.Term;
import com.saxonica.schema.UserComplexType;
import java.util.Set;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.sort.IntHashSet;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UnresolvedReferenceException;

public class ElementParticle
extends Particle {
    public ElementParticle(EnterpriseConfiguration config, SourceLocator locator) {
        this.setMinOccurs(1);
        this.setMaxOccurs(1);
        this.setLocator(locator);
        this.setConfiguration(config);
        this.symbolSpace = 801;
    }

    public ElementParticle copy() {
        ElementParticle p = new ElementParticle(this.getConfiguration(), null);
        p.nameCode = this.nameCode;
        p.setReference((ElementDecl)this.getTarget());
        p.setMinOccurs(this.getMinOccurs());
        p.setMaxOccurs(this.getMaxOccurs());
        return p;
    }

    public String getDisplayName() {
        return this.getConfiguration().getNamePool().getDisplayName(this.nameCode);
    }

    public String getNamespaceURI() {
        return this.getDeclaration().getTargetNamespace();
    }

    public String getName() {
        return this.getConfiguration().getNamePool().getLocalName(this.nameCode);
    }

    public ElementDecl getDeclaration() throws UnresolvedReferenceException {
        return (ElementDecl)this.getTarget();
    }

    public void setReference(ElementDecl declaration) {
        this.setNameCode(declaration.getNameCode());
        this.setTarget(declaration);
    }

    public boolean isEmptiable() {
        return this.getMinOccurs() == 0;
    }

    public boolean isPointless(ModelGroup container) {
        return false;
    }

    public void lookForCycles(Stack references, SchemaCompiler compiler) throws SchemaException, UnresolvedReferenceException {
        this.tryToResolve(compiler);
    }

    public boolean fixup(SchemaCompiler compiler) throws SchemaException, UnresolvedReferenceException {
        boolean result = true;
        if (this.getFixupStatus() == 0) {
            this.setFixupStatus(2);
            ElementDecl decl = (ElementDecl)PreparedSchema.validateReference(this, compiler);
            if (decl == null) {
                this.setFixupStatus(4);
                return false;
            }
            result &= decl.fixup(compiler);
        }
        this.setFixupStatus(3);
        return result;
    }

    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        switch (this.getValidationStatus()) {
            case 3: {
                return true;
            }
            case 4: 
            case 5: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        if (!this.isResolved()) {
            this.tryToResolve(compiler);
            if (!this.isResolved()) {
                String err = "Element " + Err.wrap(this.getDisplayName()) + " is referenced, but has not been declared";
                compiler.error(err, this);
                this.setValidationStatus(5);
                return false;
            }
        }
        this.setValidationStatus(2);
        boolean result = this.getDeclaration().validate(compiler);
        this.setValidationStatus(result ? 3 : 4);
        return result;
    }

    public void compile(SchemaCompiler compiler) throws SchemaException {
        if (this.getValidationStatus() != 3) {
            return;
        }
        SchemaType type = this.getDeclaration().getType();
        if (type instanceof UserComplexType) {
            UserComplexType complexType = (UserComplexType)type;
            complexType.compile(compiler);
        }
    }

    public Term getTerm() {
        return this.getDeclaration();
    }

    public SchemaType getElementParticleType(int fingerprint) {
        try {
            ElementDecl decl = (ElementDecl)this.getTarget();
            if (fingerprint == (this.nameCode & 0xFFFFF)) {
                return decl.getType();
            }
            Set<ElementDecl> subsGroup = decl.getSubstitutionGroupMembers();
            for (ElementDecl mem : subsGroup) {
                if (mem.getFingerprint() != fingerprint) continue;
                return mem.getType();
            }
        }
        catch (UnresolvedReferenceException e) {
            throw new IllegalStateException(e.getMessage());
        }
        return null;
    }

    public int getElementParticleCardinality(int fingerprint) {
        if (fingerprint == (this.nameCode & 0xFFFFF)) {
            return Particle.computeParticleCardinality(this.getMinOccurs(), this.getMaxOccurs());
        }
        ElementDecl decl = (ElementDecl)this.getTarget();
        Set<ElementDecl> subsGroup = decl.getSubstitutionGroupMembers();
        for (ElementDecl mem : subsGroup) {
            if (mem.getFingerprint() != fingerprint) continue;
            return Particle.computeParticleCardinality(this.getMinOccurs(), this.getMaxOccurs());
        }
        return 8192;
    }

    public boolean containsElementWildcard() {
        return false;
    }

    public void gatherAllPermittedElements(IntHashSet result, boolean ignoreWildcards) throws SchemaException {
        try {
            ElementDecl decl = (ElementDecl)this.getTarget();
            result.add(this.nameCode & 0xFFFFF);
            Set<ElementDecl> subsGroup = decl.getSubstitutionGroupMembers();
            for (ElementDecl mem : subsGroup) {
                result.add(mem.getNameCode() & 0xFFFFF);
            }
        }
        catch (UnresolvedReferenceException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public String toString() {
        return "ElementParticle " + this.getName();
    }

    public void serializeParticle(SchemaModelSerializer serializer) throws XPathException {
        serializer.startElement("elementParticle");
        serializer.emitAttribute("minOccurs", "" + this.getMinOccurs());
        serializer.emitAttribute("maxOccurs", this.getMaxOccurs() < 0 ? "unbounded" : "" + this.getMaxOccurs());
        serializer.emitAttribute("ref", serializer.getId(this.getTarget(), false));
        serializer.endElement();
    }
}

