/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.schema.Facet;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.TotalDigitsFacet;
import com.saxonica.schema.UserSimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.PrecisionDecimalValue;

public abstract class DigitsFacet
extends Facet {
    private int requiredValue;

    public abstract void setValue(String var1) throws SchemaException;

    public String getValue() {
        return this.requiredValue + "";
    }

    public int getNumericValue() {
        return this.requiredValue;
    }

    public void setNumericValue(int value) {
        this.requiredValue = value;
    }

    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException, ValidationException {
        if (!base.isAtomicType()) {
            throw new SchemaException("The " + this.getName() + " facet is not available on the non-atomic type " + type.getDescription());
        }
        int primitive = ((AtomicType)base).getPrimitiveType();
        if (!(primitive == 533 || primitive == 515 || primitive == 532 && this instanceof TotalDigitsFacet)) {
            throw new SchemaException("The " + this.getName() + " facet is not allowed on a type derived from the type " + base.getDescription());
        }
    }

    public boolean testAtomicValue(AtomicValue value) {
        int after;
        int before;
        int dot;
        if (value instanceof PrecisionDecimalValue) {
            return ((PrecisionDecimalValue)value).checkTotalDigits(this.requiredValue);
        }
        if (!(value instanceof DecimalValue) && !(value instanceof IntegerValue)) {
            return false;
        }
        String s = value.getStringValue();
        if (s.charAt(0) == '-') {
            s = s.substring(1);
        }
        if ((dot = s.indexOf(46)) < 0) {
            before = s.length();
            if (s.charAt(0) == '0') {
                --before;
            }
            after = 0;
        } else {
            before = dot;
            after = s.length() - before - 1;
            if (s.charAt(0) == '0') {
                --before;
            }
        }
        if (this instanceof TotalDigitsFacet) {
            return before + after <= this.requiredValue;
        }
        return after <= this.requiredValue;
    }
}

