/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.PreparedSchema;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.schema.SchemaStructure;
import com.saxonica.schema.SerializableSchemaComponent;
import com.saxonica.schema.TypeReference;
import com.saxonica.schema.UserComplexType;
import com.saxonica.schema.UserSchemaComponent;
import com.saxonica.schema.UserSimpleType;
import com.saxonica.schema.sdoc.SimpleTypeDefinition;
import com.saxonica.validate.SchemaAttributeTest;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.UnresolvedReferenceException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

public final class AttributeDecl
extends SchemaStructure
implements UserSchemaComponent,
SerializableSchemaComponent,
SchemaDeclaration {
    private UserComplexType containingComplexType = null;
    private String defaultValue = null;
    private Value fixedValue = null;
    private boolean global;
    private int nameCode;
    private TypeReference simpleTypeRef = null;
    private NamespaceResolver namespaceResolver;
    private boolean inheritable;

    public AttributeDecl(EnterpriseConfiguration config, boolean global) {
        this.global = global;
        this.setConfiguration(config);
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setContainingComplexType(UserComplexType type) {
        this.containingComplexType = type;
    }

    public UserComplexType getContainingComplexType() {
        return this.containingComplexType;
    }

    public String getName() {
        return this.getConfiguration().getNamePool().getLocalName(this.nameCode);
    }

    public String getNamespace() {
        return this.getTargetNamespace();
    }

    public String getTargetNamespace() {
        return this.getConfiguration().getNamePool().getURI(this.nameCode);
    }

    public String getDisplayName() {
        return this.getConfiguration().getNamePool().getDisplayName(this.nameCode);
    }

    public void setNameCode(int nameCode) {
        this.nameCode = nameCode;
    }

    public void setTypeReference(TypeReference type) {
        this.simpleTypeRef = type;
    }

    public int getFingerprint() {
        return this.nameCode & 0xFFFFF;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public SimpleType getSimpleType() throws UnresolvedReferenceException {
        return (SimpleType)this.simpleTypeRef.getTarget();
    }

    public SimpleType getType() throws UnresolvedReferenceException {
        return this.getSimpleType();
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Value getFixedValue() {
        return this.fixedValue;
    }

    public void setSimpleType(SimpleType simpleType) {
        if (this.simpleTypeRef != null) {
            this.simpleTypeRef.setTarget(simpleType);
        } else {
            this.simpleTypeRef = new TypeReference(simpleType.getFingerprint(), this.getConfiguration(), null);
            this.simpleTypeRef.setTarget(simpleType);
        }
    }

    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    public void setFixedValue(Value value) {
        this.fixedValue = value;
    }

    public void setNamespaceResolver(NamespaceResolver resolver) {
        this.namespaceResolver = resolver;
    }

    public NodeTest makeSchemaNodeTest() {
        return new SchemaAttributeTest(this);
    }

    public void setInheritable(boolean inherit) {
        this.inheritable = inherit;
    }

    public boolean isInheritable() {
        return this.inheritable;
    }

    public boolean fixup(SchemaCompiler compiler) throws SchemaException, UnresolvedReferenceException {
        if (this.getFixupStatus() == 0) {
            boolean b;
            this.setFixupStatus(2);
            SchemaType decl = (SchemaType)PreparedSchema.validateReference(this.simpleTypeRef, compiler);
            if (decl instanceof UserSchemaComponent && !(b = ((UserSchemaComponent)((Object)decl)).fixup(compiler))) {
                decl = null;
            }
            if (decl == null) {
                this.setFixupStatus(4);
                return false;
            }
        }
        this.setFixupStatus(3);
        return true;
    }

    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        SimpleType stype;
        if (this.getFixupStatus() == 4) {
            this.setValidationStatus(4);
            return false;
        }
        boolean result = true;
        SchemaType type = (SchemaType)PreparedSchema.validateReference(this.simpleTypeRef, compiler);
        if (type.isComplexType()) {
            String err = "The complex type " + type.getDescription() + " cannot be used as the type of an attribute";
            compiler.error(err, this);
            return false;
        }
        SimpleType simpleType = (SimpleType)type;
        if (simpleType instanceof SimpleTypeDefinition) {
            simpleType = ((SimpleTypeDefinition)simpleType).getSimpleType();
            this.simpleTypeRef.setTarget(simpleType);
        }
        if ((stype = simpleType) == null) {
            String err = "The type of attribute " + Err.wrap(this.getDisplayName(), 2) + " has not been specified";
            compiler.error(err, this);
            result = false;
            return result;
        }
        if (stype instanceof UserSimpleType) {
            result = ((UserSimpleType)stype).validate(compiler);
        }
        if (this.getFingerprint() == 388 && stype.getFingerprint() != 560) {
            compiler.error("If the xml:id attribute is used, it must be of type xs:ID", this);
            result = false;
            return result;
        }
        if (result && compiler.getLanguageVersion() == 10 && (this.getFixedValue() != null || this.getDefaultValue() != null) && stype.getBuiltInBaseType().getFingerprint() == 560) {
            compiler.error("An attribute of type xs:ID must have no fixed or default value", this);
            result = false;
            return result;
        }
        if (result && this.getFixedValue() != null) {
            result = this.makeFixedValueTyped(compiler, stype);
        }
        if (this.getDefaultValue() != null) {
            ConversionRules rules = compiler.getConfiguration().getConversionRules();
            this.setDefaultValue(((Object)Whitespace.applyWhitespaceNormalization(stype.getWhitespaceAction(), this.getDefaultValue())).toString());
            ValidationFailure err = stype.validateContent(this.getDefaultValue(), this.namespaceResolver, rules);
            if (err != null) {
                compiler.error("Default value " + Err.wrap(this.getDefaultValue(), 4) + " does not not conform to the attribute's type: " + err.getMessage(), this);
                result = false;
            }
        }
        return result;
    }

    private boolean makeFixedValueTyped(SchemaCompiler compiler, SimpleType stype) throws SchemaException {
        ConversionRules rules;
        boolean result = true;
        CharSequence fixedStringValue = this.getFixedValue().getCanonicalLexicalRepresentation();
        ValidationFailure err = stype.validateContent(fixedStringValue, this.namespaceResolver, rules = compiler.getConfiguration().getConversionRules());
        if (err != null) {
            String val = Err.wrap(fixedStringValue, 4);
            compiler.error("Fixed value " + val + " does not not conform to the attribute's type: " + err.getMessage(), this);
            result = false;
        }
        if (result) {
            try {
                if (stype.isNamespaceSensitive()) {
                    this.setFixedValue((Value)SequenceExtent.makeSequenceExtent(stype.getTypedValue(this.getFixedValue().getStringValue(), this.namespaceResolver, rules)));
                } else if (stype.isAtomicType()) {
                    AtomicValue v = (AtomicValue)((AtomicValue)this.getFixedValue()).convert((AtomicType)stype, false, rules);
                    this.setFixedValue(v);
                } else if (stype instanceof AnySimpleType) {
                    this.setFixedValue(new UntypedAtomicValue(this.getFixedValue().getStringValue()));
                } else if (this.getFixedValue() instanceof AtomicValue) {
                    this.setFixedValue((Value)SequenceExtent.makeSequenceExtent(stype.getTypedValue(this.getFixedValue().getStringValue(), null, rules)));
                }
            }
            catch (XPathException e) {
                compiler.error(e.getMessage(), this);
                result = false;
            }
        }
        return result;
    }

    public boolean testFixedValue(CharSequence value, NamespaceResolver resolver) throws ValidationException {
        if (this.fixedValue == null) {
            return true;
        }
        EnterpriseConfiguration config = this.getConfiguration();
        SequenceIterator actual = this.getSimpleType().getTypedValue(value, resolver, config.getConversionRules());
        try {
            return DeepEqual.deepEquals(this.fixedValue.iterate(), actual, new GenericAtomicComparer(CodepointCollator.getInstance(), config.getConversionContext()), (Configuration)config, 0);
        }
        catch (XPathException err) {
            throw new AssertionError((Object)err);
        }
    }

    public boolean isSameDeclaration(AttributeDecl other) {
        return this == other || this.getFingerprint() == other.getFingerprint() && this.getLineNumber() == other.getLineNumber() && this.getColumnNumber() == other.getColumnNumber() && this.getSystemId().equals(other.getSystemId());
    }

    public boolean isNillable() {
        return false;
    }

    public boolean isAbstract() {
        return false;
    }

    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        String id = serializer.getId(this, true);
        serializer.startElement("attribute");
        serializer.emitAttribute("id", id);
        if (this.getName() != null) {
            serializer.emitAttribute("name", this.getName());
            if (this.getTargetNamespace() != null && this.getTargetNamespace().length() > 0) {
                serializer.emitAttribute("targetNamespace", this.getTargetNamespace());
            }
        }
        SimpleType type = this.getType();
        serializer.emitAttribute("type", serializer.getTypeLink(type));
        serializer.emitAttribute("global", this.isGlobal() ? "true" : "false");
        serializer.emitAttribute("inheritable", this.isInheritable() ? "true" : "false");
        if (!this.isGlobal() && this.getContainingComplexType() != null) {
            serializer.emitAttribute("containingComplexType", serializer.getId(this.getContainingComplexType(), false));
        }
        if (this.getDefaultValue() != null) {
            serializer.emitAttribute("default", this.getDefaultValue());
        }
        if (this.getFixedValue() != null) {
            serializer.startElement("fixed");
            serializer.emitTypedValue(this.getFixedValue());
            serializer.endElement();
        }
        serializer.endElement();
    }
}

