/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.schema.SchemaStructure;
import com.saxonica.schema.SerializableSchemaComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.functions.Empty;
import net.sf.saxon.lib.StandardURIResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Assertion
extends SchemaStructure
implements SerializableSchemaComponent {
    private XPathExpression condition;
    private XPathVariable valueVariable;
    private String conditionText;
    private String message;
    private XPathStaticContext staticContext;

    public Assertion(EnterpriseConfiguration config, XPathExpression condition, XPathVariable valueVariable, String text) {
        this.setConfiguration(config);
        this.condition = condition;
        this.valueVariable = valueVariable;
        this.conditionText = text;
    }

    public XPathExpression getCondition() {
        return this.condition;
    }

    public XPathVariable getValueVariable() {
        return this.valueVariable;
    }

    public String getConditionText() {
        return this.conditionText;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setStaticContext(XPathStaticContext staticContext) {
        this.staticContext = staticContext;
    }

    public XPathStaticContext getStaticContext() {
        return this.staticContext;
    }

    public List<Item> test(Item contextItem, ValueRepresentation value, Controller controller) {
        XPathDynamicContext context = null;
        try {
            context = this.condition.createDynamicContext(controller, contextItem);
            if (controller != null) {
                context.setURIResolver(new StandardURIResolver(controller.getConfiguration()){

                    public Source resolve(String href, String base) throws XPathException {
                        throw new XPathException("Use of doc() function within an assertion is not allowed", "FODC0002");
                    }
                });
            }
        }
        catch (XPathException err) {
            throw new IllegalStateException(err.getMessage());
        }
        try {
            Expression exp;
            if (value != null && this.getValueVariable() != null) {
                context.setVariable(this.getValueVariable(), value);
            }
            if ((exp = this.condition.getInternalExpression()) instanceof Empty) {
                Item item;
                Expression sequence = ((Empty)exp).getArguments()[0];
                SequenceIterator nodes = sequence.iterate(context.getXPathContextObject());
                int i = 0;
                ArrayList<Item> offendingItems = null;
                while ((item = nodes.next()) != null && i++ < 100) {
                    if (offendingItems == null) {
                        offendingItems = new ArrayList<Item>(20);
                    }
                    offendingItems.add(item);
                }
                return offendingItems;
            }
            if (ExpressionTool.effectiveBooleanValue(this.condition.iterate(context))) {
                return null;
            }
            return Collections.EMPTY_LIST;
        }
        catch (XPathException err) {
            try {
                context.getErrorListener().warning(err);
            }
            catch (TransformerException err2) {
                // empty catch block
            }
            return Collections.EMPTY_LIST;
        }
    }

    public int hashCode() {
        return this.condition.getInternalExpression().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof Assertion && this.condition.getInternalExpression().equals(((Assertion)other).condition.getInternalExpression());
    }

    @Override
    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        serializer.startElement("assertion");
        serializer.emitNamespaceContext(this.staticContext.getNamespaceResolver());
        serializer.emitAttribute("test", this.getConditionText());
        serializer.emitAttribute("defaultNamespace", this.staticContext.getDefaultElementNamespace());
        serializer.emitAttribute("xml:base", this.staticContext.getBaseURI());
        serializer.endElement();
    }
}

