/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.pull;

import net.sf.saxon.om.NamePool;
import net.sf.saxon.pull.PullFilter;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;

public class PullTracer
extends PullFilter {
    private NamePool pool;

    public PullTracer(PullProvider base) {
        super(base);
    }

    public int next() throws XPathException {
        this.currentEvent = super.next();
        this.traceEvent(this.currentEvent);
        return this.currentEvent;
    }

    private void traceEvent(int event) {
        if (this.pool == null) {
            this.pool = this.getPipelineConfiguration().getConfiguration().getNamePool();
        }
        PullProvider in = this.getUnderlyingProvider();
        switch (event) {
            case 2: {
                System.err.println("START_DOCUMENT");
                break;
            }
            case 4: {
                System.err.println("START_ELEMENT " + this.pool.getDisplayName(in.getNameCode()));
                break;
            }
            case 8: {
                System.err.println("TEXT");
                try {
                    CharSequence cs = this.getStringValue();
                    FastStringBuffer sb = new FastStringBuffer(cs.length() * 5);
                    sb.append('(');
                    for (int i = 0; i < cs.length(); ++i) {
                        sb.append(cs.charAt(i) + " ");
                    }
                    sb.append(')');
                    System.err.println(sb);
                }
                catch (XPathException err) {}
                break;
            }
            case 9: {
                System.err.println("COMMENT");
                break;
            }
            case 10: {
                System.err.println("PROCESSING_INSTRUCTION");
                break;
            }
            case 5: {
                int nc = in.getNameCode();
                System.err.println("END_ELEMENT " + (nc == -1 ? "" : this.pool.getDisplayName(nc)));
                break;
            }
            case 3: {
                System.err.println("END_DOCUMENT");
                break;
            }
            case -1: {
                System.err.println("END_OF_INPUT");
                break;
            }
            case 1: {
                try {
                    System.err.println("ATOMIC VALUE: " + in.getStringValue());
                    break;
                }
                catch (XPathException e) {
                    // empty catch block
                }
            }
        }
    }
}

