/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ptree;

import com.saxonica.config.ProfessionalConfiguration;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.sort.IntToIntHashMap;
import net.sf.saxon.expr.sort.IntToIntMap;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.AppendableCharSequence;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import net.sf.saxon.tree.tiny.TinyTextImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.tiny.WhitespaceTextImpl;
import org.xml.sax.SAXParseException;

public class PTreeWriter {
    NamePool pool;
    List names = new ArrayList(500);
    IntToIntMap map = new IntToIntHashMap(500);

    public PTreeWriter() {
        this.map.setDefaultValue(-1);
    }

    public void writeTree(TinyTree tree, DataOutputStream out) throws IOException {
        int numberOfNodes = tree.getNumberOfNodes();
        int[] nameCodes = tree.getNameCodeArray();
        byte[] nodeKind = tree.getNodeKindArray();
        short[] depth = tree.getNodeDepthArray();
        int[] typeCodes = tree.getTypeCodeArray();
        int[] alpha = tree.getAlphaArray();
        int[] beta = tree.getBetaArray();
        AppendableCharSequence text = tree.getCharacterBuffer();
        CharSequence comments = tree.getCommentBuffer();
        int numberOfAttributes = tree.getNumberOfAttributes();
        int[] attributeNameCodes = tree.getAttributeNameCodeArray();
        int[] attributeParentPointers = tree.getAttributeParentArray();
        int[] attributeTypeCodes = tree.getAttributeTypeCodeArray();
        CharSequence[] attributeValues = tree.getAttributeValueArray();
        int numberOfNamespaces = tree.getNumberOfNamespaces();
        int[] namespaceCodes = tree.getNamespaceCodeArray();
        int[] namespaceParents = tree.getNamespaceParentArray();
        this.pool = tree.getNamePool();
        out.writeInt(-1091982307);
        out.writeInt(0);
        out.writeInt(0);
        out.writeInt(numberOfNodes);
        out.writeInt(numberOfAttributes);
        out.writeInt(numberOfNamespaces);
        out.writeInt(text.length());
        this.handleNames(out, nameCodes, typeCodes, attributeNameCodes, attributeTypeCodes);
        block10: for (int i = 0; i < numberOfNodes; ++i) {
            int depthCode = i == 0 || depth[i] == depth[i - 1] ? 0 : (depth[i] == depth[i - 1] + 1 ? 1 : (depth[i] <= 255 ? 2 : 3));
            out.writeByte(nodeKind[i] | depthCode << 6);
            if (depthCode == 2) {
                out.writeByte(depth[i]);
            } else if (depthCode == 3) {
                out.writeInt(depth[i]);
            }
            switch (nodeKind[i]) {
                case 9: {
                    continue block10;
                }
                case 1: {
                    int a;
                    int nc = this.allocateNameCode(nameCodes[i]);
                    int nameCodeSize = this.integerLength(nc);
                    int options = nameCodeSize - 1 << 6;
                    options |= alpha[i] >= 0 ? 32 : 0;
                    options |= beta[i] >= 0 ? 16 : 0;
                    int typeCodeSize = 0;
                    int tc = 0;
                    if (typeCodes != null && typeCodes[i] >= 0) {
                        tc = this.allocateNameCode(typeCodes[i]);
                        typeCodeSize = this.integerLength(tc);
                        options |= (typeCodeSize & 3) << 2;
                    }
                    out.writeByte(options);
                    this.writeVariableInt(out, nc, nameCodeSize);
                    if (typeCodeSize > 0) {
                        this.writeVariableInt(out, tc, typeCodeSize);
                    }
                    if (beta[i] >= 0) {
                        int ns = beta[i];
                        int nss = 0;
                        while (ns < numberOfNamespaces && namespaceParents[ns++] == i) {
                            ++nss;
                        }
                        out.writeShort(nss);
                        for (a = 0; a < nss; ++a) {
                            int nscode = namespaceCodes[beta[i] + a];
                            out.writeUTF(this.pool.getPrefixFromNamespaceCode(nscode));
                            out.writeUTF(this.pool.getURIFromNamespaceCode(nscode));
                        }
                    }
                    if (alpha[i] < 0) continue block10;
                    int att = alpha[i];
                    int atts = 0;
                    while (att < numberOfAttributes && attributeParentPointers[att++] == i) {
                        ++atts;
                    }
                    out.writeShort(atts);
                    for (a = 0; a < atts; ++a) {
                        int newTypeCode = -1;
                        if (attributeTypeCodes != null && attributeTypeCodes[alpha[i] + a] >= 0) {
                            boolean isDtdType;
                            int fp = attributeTypeCodes[alpha[i] + a];
                            boolean bl = isDtdType = (fp & 0x40000000) != 0;
                            if (!isDtdType) {
                                newTypeCode = this.allocateNameCode(fp);
                            }
                        }
                        this.writeAttribute(out, this.allocateNameCode(attributeNameCodes[alpha[i] + a]), newTypeCode, ((Object)attributeValues[alpha[i] + a]).toString());
                    }
                    continue block10;
                }
                case 3: {
                    String value = ((Object)TinyTextImpl.getStringValue(tree, i)).toString();
                    try {
                        out.writeUTF(value);
                    }
                    catch (UTFDataFormatException err) {
                        out.writeUTF("");
                        this.writeText(value, out);
                    }
                    continue block10;
                }
                case 4: {
                    byte b;
                    int s;
                    long val = WhitespaceTextImpl.getLongValue(tree, i);
                    int count = 0;
                    for (s = 56; s >= 0 && (b = (byte)(val >>> s & 0xFFL)) != 0; s -= 8) {
                        count = (byte)(count + 1);
                    }
                    out.writeByte(count);
                    for (s = 56; s >= 0 && (b = (byte)(val >>> s & 0xFFL)) != 0; s -= 8) {
                        out.writeByte(b);
                    }
                    continue block10;
                }
                case 8: {
                    String comment = ((Object)comments.subSequence(alpha[i], alpha[i] + beta[i])).toString();
                    this.writeText(comment, out);
                    continue block10;
                }
                case 7: {
                    String name = this.pool.getLocalName(nameCodes[i]);
                    out.writeUTF(name);
                    String data = ((Object)comments.subSequence(alpha[i], alpha[i] + beta[i])).toString();
                    this.writeText(data, out);
                    continue block10;
                }
            }
        }
        out.flush();
    }

    private void writeVariableInt(DataOutputStream out, int value, int bytes) throws IOException {
        if (bytes == 4) {
            out.writeInt(value);
        } else if (bytes == 3) {
            out.writeByte(value >>> 16);
            out.writeByte(value >>> 8);
            out.writeByte(value);
        } else if (bytes == 2) {
            out.writeByte(value >>> 8);
            out.writeByte(value);
        } else if (bytes == 1) {
            out.writeByte(value);
        }
    }

    private void handleNames(DataOutputStream out, int[] enames, int[] etypes, int[] anames, int[] atypes) throws IOException {
        int i;
        this.indexNames(enames);
        this.indexNames(etypes);
        this.indexNames(anames);
        this.indexNames(atypes);
        out.writeInt(this.names.size());
        HashMap<String, Short> uris = new HashMap<String, Short>(16);
        ArrayList<String> uriList = new ArrayList<String>(16);
        HashMap<String, Short> prefixes = new HashMap<String, Short>(16);
        ArrayList<String> prefixList = new ArrayList<String>(16);
        for (i = 0; i < this.names.size(); ++i) {
            Short uriCode;
            String[] triple = (String[])this.names.get(i);
            Short prefixCode = (Short)prefixes.get(triple[0]);
            if (prefixCode == null) {
                prefixCode = (short)prefixes.size();
                prefixes.put(triple[0], prefixCode);
                prefixList.add(triple[0]);
            }
            if ((uriCode = (Short)uris.get(triple[1])) == null) {
                uriCode = (short)uris.size();
                uris.put(triple[1], uriCode);
                uriList.add(triple[1]);
            }
            out.writeShort(prefixCode.shortValue());
            out.writeShort(uriCode.shortValue());
            if (triple[2] == null) {
                triple[2] = "";
            }
            out.writeUTF(triple[2]);
        }
        out.writeInt(prefixes.size());
        for (i = 0; i < prefixList.size(); ++i) {
            out.writeUTF((String)prefixList.get(i));
        }
        out.writeInt(uris.size());
        for (i = 0; i < uriList.size(); ++i) {
            out.writeUTF((String)uriList.get(i));
        }
    }

    private void indexNames(int[] codes) {
        if (codes != null) {
            for (int i = 0; i < codes.length; ++i) {
                if (codes[i] < 0) continue;
                this.allocateNameCode(codes[i]);
            }
        }
    }

    private int allocateNameCode(int oldNameCode) {
        int nc = this.map.get(oldNameCode);
        if (nc == -1) {
            String prefix = this.pool.getPrefix(oldNameCode);
            String uri = this.pool.getURI(oldNameCode);
            String localName = this.pool.getLocalName(oldNameCode);
            String[] triple = new String[]{prefix, uri, localName};
            int newNameCode = this.names.size();
            this.names.add(triple);
            this.map.put(oldNameCode, newNameCode);
            return newNameCode;
        }
        return nc;
    }

    private int integerLength(int i) {
        if (i < 0) {
            return 4;
        }
        if (i < 255) {
            return 1;
        }
        if (i < 65535) {
            return 2;
        }
        if (i < 0x1000000) {
            return 3;
        }
        return 4;
    }

    private void writeAttribute(DataOutputStream out, int nc, int typeCode, String value) throws IOException {
        int nameCodeSize = this.integerLength(nc);
        int options = nameCodeSize - 1 << 6;
        int typeCodeSize = this.integerLength(typeCode);
        if (typeCode >= 0) {
            options |= (typeCodeSize & 3) << 4;
        }
        out.writeByte(options |= value.length() > 0 ? 8 : 0);
        this.writeVariableInt(out, nc, nameCodeSize);
        if (typeCode >= 0) {
            this.writeVariableInt(out, typeCode, typeCodeSize);
        }
        if (value.length() > 0) {
            try {
                out.writeUTF(value);
            }
            catch (UTFDataFormatException err) {
                out.writeUTF("");
                this.writeText(value, out);
            }
        }
    }

    private void writeText(CharSequence chars, DataOutputStream out) throws IOException {
        if (chars == null) {
            chars = "";
        }
        int length = chars.length();
        int globs = length / 10000;
        int start = 0;
        out.writeInt(globs);
        for (int i = 0; i < globs; ++i) {
            out.writeUTF(((Object)chars.subSequence(start, Math.min(start + 10000, length))).toString());
            start += 10000;
        }
    }

    private static DocumentInfo build(File in, boolean stripSpace) throws XPathException {
        StreamSource source = new StreamSource(in.toURI().toString());
        ParseOptions options = new ParseOptions();
        if (stripSpace) {
            options.setStripSpace(2);
        }
        Configuration config = new Configuration();
        try {
            return config.buildDocument(source, options);
        }
        catch (XPathException err) {
            Throwable cause = err.getException();
            if (cause != null && cause instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)cause;
                if ((cause = spe.getException()) instanceof RuntimeException) {
                    config.reportFatalError(err);
                }
            } else {
                while (err.getException() instanceof XPathException) {
                    err = (XPathException)err.getException();
                }
                config.reportFatalError(err);
            }
            throw err;
        }
    }

    public static void copyToPTree(Source in, ParseOptions options, OutputStream out) throws XPathException, IOException {
        DataOutputStream outs = new DataOutputStream(out);
        ProfessionalConfiguration config = new ProfessionalConfiguration();
        ParseOptions opt2 = new ParseOptions(options);
        opt2.setModel(TreeModel.TINY_TREE);
        TinyDocumentImpl doc = (TinyDocumentImpl)config.buildDocument(in, opt2);
        new PTreeWriter().writeTree(doc.getTree(), outs);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Format: java com.saxonica.PTreeWriter [-strip] source.xml out.tree");
            System.exit(2);
        }
        int a = 0;
        boolean stripSpace = false;
        if (args[a].equals("-strip")) {
            stripSpace = true;
        }
        int n = ++a;
        File in = new File(args[n]);
        DocumentInfo doc = PTreeWriter.build(in, stripSpace);
        File out = new File(args[++a]);
        DataOutputStream outs = new DataOutputStream(new FileOutputStream(out));
        TinyTree tree = ((TinyDocumentImpl)doc).getTree();
        new PTreeWriter().writeTree(tree, outs);
        outs.close();
    }
}

