/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.xpath3;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.SequenceType;

public abstract class TrigonometricFn
extends ExtensionFunctionDefinition {
    public static String NAMESPACE = "http://www.w3.org/2005/xpath-functions/math";
    private static StructuredQName SIN = new StructuredQName("math", NAMESPACE, "sin");
    private static StructuredQName COS = new StructuredQName("math", NAMESPACE, "cos");
    private static StructuredQName TAN = new StructuredQName("math", NAMESPACE, "tan");
    private static StructuredQName ASIN = new StructuredQName("math", NAMESPACE, "asin");
    private static StructuredQName ACOS = new StructuredQName("math", NAMESPACE, "acos");
    private static StructuredQName ATAN = new StructuredQName("math", NAMESPACE, "atan");
    private static StructuredQName SQRT = new StructuredQName("math", NAMESPACE, "sqrt");

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 1;
    }

    public boolean trustResultType() {
        return true;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.OPTIONAL_DOUBLE};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.OPTIONAL_DOUBLE;
    }

    protected abstract double compute(double var1);

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
                DoubleValue arg = (DoubleValue)arguments[0].next();
                if (arg == null) {
                    return EmptyIterator.getInstance();
                }
                double result = TrigonometricFn.this.compute(arg.getDoubleValue());
                return SingletonIterator.makeIterator(new DoubleValue(result));
            }
        };
    }

    public static class SqrtFn
    extends TrigonometricFn {
        public StructuredQName getFunctionQName() {
            return SQRT;
        }

        protected double compute(double input) {
            return Math.sqrt(input);
        }
    }

    public static class AtanFn
    extends TrigonometricFn {
        public StructuredQName getFunctionQName() {
            return ATAN;
        }

        protected double compute(double input) {
            return Math.atan(input);
        }
    }

    public static class AcosFn
    extends TrigonometricFn {
        public StructuredQName getFunctionQName() {
            return ACOS;
        }

        protected double compute(double input) {
            return Math.acos(input);
        }
    }

    public static class AsinFn
    extends TrigonometricFn {
        public StructuredQName getFunctionQName() {
            return ASIN;
        }

        protected double compute(double input) {
            return Math.asin(input);
        }
    }

    public static class TanFn
    extends TrigonometricFn {
        public StructuredQName getFunctionQName() {
            return TAN;
        }

        protected double compute(double input) {
            return Math.tan(input);
        }
    }

    public static class CosFn
    extends TrigonometricFn {
        public StructuredQName getFunctionQName() {
            return COS;
        }

        protected double compute(double input) {
            return Math.cos(input);
        }
    }

    public static class SinFn
    extends TrigonometricFn {
        public StructuredQName getFunctionQName() {
            return SIN;
        }

        protected double compute(double input) {
            return Math.sin(input);
        }
    }
}

