/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.xpath3;

import java.io.StringWriter;
import java.util.Properties;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class Serialize
extends SystemFunction {
    Properties outputProperties;
    int locationId = 0;

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        NodeInfo node = (NodeInfo)this.argument[0].evaluateItem(context);
        if (node == null) {
            return StringValue.EMPTY_STRING;
        }
        if (node.getNodeKind() == 2 || node.getNodeKind() == 13) {
            throw new XPathException("Attribute and namespace nodes are not allowed as argument.", "SENR0001");
        }
        Properties props = new Properties();
        props.setProperty("method", "xml");
        if (this.argument.length > 1) {
            NodeInfo nodeInfo;
            SequenceIterator itr = this.argument[1].iterate(context);
            NamePool namepool = context.getConfiguration().getNamePool();
            while ((nodeInfo = (NodeInfo)itr.next()) != null) {
                String cname = namepool.getClarkName(nodeInfo.getNameCode());
                String lname = namepool.getLocalName(nodeInfo.getNameCode());
                String uri = namepool.getURI(nodeInfo.getNameCode());
                if (cname.equals("use-character-maps")) {
                    throw new XPathException("The 'use-character-maps' property is not available.", "SEPM0016");
                }
                try {
                    ResultDocument.setSerializationProperty(props, uri, lname, nodeInfo.getStringValue(), new InscopeNamespaceResolver(nodeInfo), false, context.getConfiguration());
                }
                catch (XPathException err) {
                    if ("SXSE0003".equals(err.getErrorCodeLocalPart())) continue;
                    throw err;
                }
            }
        }
        try {
            StringWriter result = new StringWriter();
            XPathContextMinor c2 = context.newMinorContext();
            c2.setOriginatingConstructType(2053);
            SerializerFactory sf = context.getConfiguration().getSerializerFactory();
            PipelineConfiguration pipe = context.getController().makePipelineConfiguration();
            Receiver receiver = sf.getReceiver(new StreamResult(result), pipe, props);
            c2.changeOutputDestination(receiver, false, 3, null);
            SequenceReceiver out = c2.getReceiver();
            out.open();
            node.copy(out, 6, this.locationId);
            out.close();
            return new StringValue(result.toString());
        }
        catch (Exception e) {
            if (e instanceof XPathException) {
                throw (XPathException)e;
            }
            XPathException se = new XPathException("Serialization unsuccessful.", e);
            se.setErrorCode("SEPM0016");
            throw se;
        }
    }
}

