/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.xpath3;

import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import org.xml.sax.InputSource;

public class ParseXml
extends SystemFunction {
    String expressionBaseURI = null;

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(visitor);
            this.expressionBaseURI = visitor.getStaticContext().getBaseURI();
        }
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        NodeInfo node;
        String baseURI = this.expressionBaseURI;
        FastStringBuffer content = new FastStringBuffer(16);
        content.append(this.argument[0].evaluateAsString(context));
        if (this.argument.length > 1) {
            baseURI = this.argument[1].evaluateItem(context).getStringValue();
            try {
                URI theURI = new URI(baseURI);
                if (!theURI.isAbsolute()) {
                    throw new XPathException("Content of $baseURI is not a valid absolute URI.", "FODC0007");
                }
            }
            catch (URISyntaxException err) {
                throw new XPathException("Content of $baseURI is not a valid absolute URI.", "FODC0007");
            }
        }
        try {
            Builder b;
            Controller controller = context.getController();
            Configuration configuration = null;
            if (controller != null) {
                configuration = controller.getConfiguration();
            }
            StringReader sr = new StringReader(content.toString());
            InputSource is = new InputSource(sr);
            is.setSystemId(baseURI);
            SAXSource source = new SAXSource(is);
            source.setSystemId(baseURI.toString());
            Receiver s = b = controller.makeBuilder();
            ParseOptions options = new ParseOptions();
            options.setStripSpace(4);
            options.setErrorListener(context.getConfiguration().getErrorListener());
            if (controller.getExecutable().stripsInputTypeAnnotations()) {
                s = configuration.getAnnotationStripper(s);
            }
            s.setPipelineConfiguration(b.getPipelineConfiguration());
            Sender.send(source, s, options);
            node = b.getCurrentRoot();
            b.reset();
        }
        catch (XPathException err) {
            throw new XPathException("Content of $arg is not a well-formed and namespace-well-formed XML document.", "FODC0006");
        }
        return node;
    }
}

