/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.xpath3;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.AnalyzeString;
import net.sf.saxon.expr.instruct.FixedElement;
import net.sf.saxon.expr.instruct.ProcessRegexMatchInstruction;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.functions.CompileTimeFunction;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class AnalyzeStringFn
extends CompileTimeFunction {
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        Expression[] args = this.getArguments();
        Configuration config = visitor.getConfiguration();
        boolean schemaAware = visitor.getExecutable().isSchemaAware();
        if (schemaAware) {
            config.addSchemaForBuiltInNamespace("http://www.w3.org/2005/xpath-functions");
        }
        NamePool namePool = config.getNamePool();
        int resultNameCode = namePool.allocate("fn", "http://www.w3.org/2005/xpath-functions", "analyze-string-result");
        int matchNameCode = namePool.allocate("fn", "http://www.w3.org/2005/xpath-functions", "match");
        int nonMatchNameCode = namePool.allocate("fn", "http://www.w3.org/2005/xpath-functions", "non-match");
        int[] nscodes = new int[]{};
        FixedElement onMatch = new FixedElement(matchNameCode, nscodes, true, null, 3);
        onMatch.setContentExpression(new ProcessRegexMatchInstruction(namePool));
        FixedElement onNonMatch = new FixedElement(nonMatchNameCode, nscodes, true, null, 3);
        onNonMatch.setContentExpression(new ValueOf(new ContextItemExpression(), false, true));
        AnalyzeString inst = new AnalyzeString(args[0], args[1], args.length > 2 ? args[2] : new StringLiteral(StringValue.EMPTY_STRING), onMatch, onNonMatch, null);
        FixedElement result = new FixedElement(resultNameCode, nscodes, true, null, schemaAware ? 1 : 4);
        result.setContentExpression(inst);
        return result;
    }
}

