/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.map;

import com.saxonica.functions.map.ImmutableMap;
import com.saxonica.functions.map.KeyValuePair;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class MapPut
extends ExtensionFunctionDefinition {
    private static final StructuredQName name = new StructuredQName("", "http://ns.saxonica.com/map", "put");
    private static final SequenceType[] ARG_TYPES = new SequenceType[]{ImmutableMap.TYPE, SequenceType.SINGLE_ATOMIC, SequenceType.ANY_SEQUENCE};

    public StructuredQName getFunctionQName() {
        return name;
    }

    public int getMinimumNumberOfArguments() {
        return 3;
    }

    public SequenceType[] getArgumentTypes() {
        return ARG_TYPES;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return ImmutableMap.TYPE;
    }

    public boolean trustResultType() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
                ImmutableMap map = (ImmutableMap)((ObjectValue)arguments[0].next()).getObject();
                AtomicValue key = (AtomicValue)arguments[1].next();
                Object comp = key.getXPathComparable(false, CodepointCollator.getInstance(), context);
                ValueRepresentation value = SequenceExtent.makeSequenceExtent(arguments[2]);
                KeyValuePair kvp = new KeyValuePair(key, value);
                ImmutableMap<Object, KeyValuePair> newMap = map.put(comp, kvp);
                return Value.asIterator(new ObjectValue(newMap));
            }
        };
    }
}

