/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.map;

import com.saxonica.functions.map.ImmutableMap;
import com.saxonica.functions.map.KeyValuePair;
import java.util.ArrayList;
import java.util.Set;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;

public class MapKeys
extends ExtensionFunctionDefinition {
    private static final StructuredQName name = new StructuredQName("", "http://ns.saxonica.com/map", "keys");
    private static final SequenceType[] ARG_TYPES = new SequenceType[]{ImmutableMap.TYPE};

    public StructuredQName getFunctionQName() {
        return name;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return ARG_TYPES;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.ATOMIC_SEQUENCE;
    }

    public boolean trustResultType() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
                ImmutableMap map = (ImmutableMap)((ObjectValue)arguments[0].next()).getObject();
                Set rawKeys = map.keySet();
                ArrayList<AtomicValue> keys = new ArrayList<AtomicValue>();
                for (Object o : rawKeys) {
                    keys.add(((KeyValuePair)map.get(o)).key);
                }
                return new ListIterator(keys);
            }
        };
    }
}

