/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.hof;

import com.saxonica.functions.hof.FunctionSequenceCoercer;
import net.sf.saxon.Configuration;
import net.sf.saxon.TypeCheckerEnvironment;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaComponentVisitor;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class FunctionType
extends AnyFunctionType {
    SequenceType[] argTypes;
    SequenceType resultType;

    public FunctionType(SequenceType[] argTypes, SequenceType resultType) {
        this.argTypes = argTypes;
        this.resultType = resultType;
    }

    public int getArity() {
        return this.argTypes.length;
    }

    public SequenceType[] getArgumentTypes() {
        return this.argTypes;
    }

    public SequenceType getResultType() {
        return this.resultType;
    }

    public boolean matchesItem(Item item, boolean allowURIPromotion, Configuration config) {
        if (!(item instanceof FunctionItem)) {
            return false;
        }
        TypeHierarchy th = config.getTypeHierarchy();
        int rel = th.relationship(((FunctionItem)item).getFunctionItemType(), this);
        return rel == 0 || rel == 2;
    }

    public ItemType getSuperType(TypeHierarchy th) {
        return AnyFunctionType.getInstance();
    }

    public String toString(NamePool pool) {
        return this.toString();
    }

    public String toString() {
        FastStringBuffer sb = new FastStringBuffer(100);
        sb.append("(function(");
        for (int i = 0; i < this.argTypes.length; ++i) {
            sb.append(this.argTypes[i].toString());
            if (i >= this.argTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append(") as ");
        sb.append(this.resultType.toString());
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof FunctionType) {
            FunctionType f2 = (FunctionType)other;
            if (!this.resultType.equals(f2.resultType)) {
                return false;
            }
            if (this.argTypes.length != f2.argTypes.length) {
                return false;
            }
            for (int i = 0; i < this.argTypes.length; ++i) {
                if (this.argTypes[i].equals(f2.argTypes[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = this.resultType.hashCode() ^ this.argTypes.length;
        for (int i = 0; i < this.argTypes.length; ++i) {
            h ^= this.argTypes[i].hashCode();
        }
        return h;
    }

    public int relationship(FunctionItemType other, TypeHierarchy th) {
        if (other == AnyFunctionType.getInstance()) {
            return 2;
        }
        if (this.equals(other)) {
            return 0;
        }
        FunctionType f2 = (FunctionType)other;
        if (this.argTypes.length != f2.argTypes.length) {
            return 4;
        }
        boolean wider = false;
        boolean narrower = false;
        for (int i = 0; i < this.argTypes.length; ++i) {
            int argRel = th.relationship(this.argTypes[i].getPrimaryType(), f2.argTypes[i].getPrimaryType());
            switch (argRel) {
                case 4: {
                    return 4;
                }
                case 1: {
                    narrower = true;
                    break;
                }
                case 2: {
                    wider = true;
                    break;
                }
                case 3: {
                    wider = true;
                    narrower = true;
                    break;
                }
            }
            int c1 = this.argTypes[i].getCardinality();
            int c2 = f2.argTypes[i].getCardinality();
            if (c1 == c2) continue;
            if (Cardinality.subsumes(c1, c2)) {
                narrower = true;
                continue;
            }
            if (Cardinality.subsumes(c2, c1)) {
                wider = true;
                continue;
            }
            return 4;
        }
        int resRel = th.relationship(this.resultType.getPrimaryType(), f2.resultType.getPrimaryType());
        switch (resRel) {
            case 4: {
                return 4;
            }
            case 1: {
                wider = true;
                break;
            }
            case 2: {
                narrower = true;
                break;
            }
            case 3: {
                wider = true;
                narrower = true;
                break;
            }
        }
        int c1 = this.resultType.getCardinality();
        int c2 = f2.resultType.getCardinality();
        if (c1 != c2) {
            boolean subsumes = Cardinality.subsumes(c1, c2);
            boolean subsumed = Cardinality.subsumes(c2, c1);
            if (subsumes) {
                wider = true;
            } else if (subsumed) {
                narrower = true;
            } else {
                return 3;
            }
        }
        if (wider) {
            if (narrower) {
                return 3;
            }
            return 1;
        }
        if (narrower) {
            return 2;
        }
        return 0;
    }

    public Expression makeFunctionSequenceCoercer(Expression exp, RoleLocator role, TypeCheckerEnvironment visitor) throws XPathException {
        return new FunctionSequenceCoercer(exp, this, role, visitor);
    }

    public void visitNamedSchemaComponents(SchemaComponentVisitor visitor) throws XPathException {
        this.resultType.getPrimaryType().visitNamedSchemaComponents(visitor);
        for (int i = 0; i < this.argTypes.length; ++i) {
            this.argTypes[i].getPrimaryType().visitNamedSchemaComponents(visitor);
        }
    }
}

