/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.hof;

import com.saxonica.functions.hof.AbstractFunctionItem;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Value;

public class FunctionItemExpression
extends Expression {
    private AbstractFunctionItem value;

    public FunctionItemExpression(AbstractFunctionItem value) {
        this.value = value;
    }

    public FunctionItem getValue() {
        return this.value;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.value.simplify(visitor);
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.value.typeCheck(visitor, contextItemType);
        return this;
    }

    public final Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.value.optimize(visitor, contextItemType);
        return this;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return this.value.getFunctionItemType();
    }

    public int computeCardinality() {
        return 16384;
    }

    public int computeSpecialProperties() {
        return 0x400000;
    }

    public boolean isVacuousExpression() {
        return false;
    }

    public Expression copy() {
        return new FunctionItemExpression(this.value);
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return pathMapNodeSet;
    }

    public final int getDependencies() {
        return 0;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return Value.asIterator(this.value);
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        return this.value;
    }

    public void process(XPathContext context) throws XPathException {
        context.getReceiver().append(this.value, 0, 0);
    }

    public CharSequence evaluateAsString(XPathContext context) throws XPathException {
        throw new XPathException("Cannot convert a function item to a string");
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        throw new XPathException("A function item cannot be used in a boolean context");
    }

    public boolean equals(Object obj) {
        return obj instanceof FunctionItemExpression && ((FunctionItemExpression)obj).value == this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("functionItem");
        this.value.explain(out);
        out.endElement();
    }
}

