/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.hof;

import com.saxonica.functions.hof.AbstractFunctionItem;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.NamespaceResolverWithDefault;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.SingletonItem;

public class DynamicFunctionConstructor
extends ExtensionFunctionDefinition {
    private static final StructuredQName qName = new StructuredQName("", "http://saxon.sf.net/", "function");

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 2;
    }

    public int getMaximumNumberOfArguments() {
        return 2;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING, SequenceType.SINGLE_INTEGER};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.makeSequenceType(AnyFunctionType.getInstance(), 16384);
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new DynamicFunctionConstructorCall();
    }

    private static class DynamicFunctionConstructorCall
    extends ExtensionFunctionCall {
        private DynamicFunctionConstructorCall() {
        }

        public void supplyStaticContext(StaticContext context, int locationId, Expression[] arguments) throws XPathException {
        }

        public Expression rewrite(StaticContext context, Expression[] arguments) throws XPathException {
            if (!context.getConfiguration().isLicensed()) {
                throw new XPathException("saxon:function() requires a Saxon-PE or Saxon-EE license");
            }
            if (arguments[0] instanceof StringLiteral && arguments[1] instanceof Literal && ((Literal)arguments[1]).getValue() instanceof Int64Value) {
                String lexicalName = ((StringLiteral)arguments[0]).getStringValue();
                NamespaceResolverWithDefault resolver = new NamespaceResolverWithDefault(context.getNamespaceResolver(), context.getDefaultFunctionNamespace());
                StructuredQName functionName = StructuredQName.fromLexicalQName(lexicalName, true, context.getConfiguration().getNameChecker(), resolver);
                int arity = (int)((Int64Value)((Literal)arguments[1]).getValue()).longValue();
                AbstractFunctionItem fcf = AbstractFunctionItem.bind(functionName, arity, context, this.getContainer());
                return new Literal(new SingletonItem(fcf));
            }
            throw new XPathException("Arguments to saxon:function() must be literals");
        }

        public void copyLocalData(ExtensionFunctionCall destination) {
        }

        public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
            throw new UnsupportedOperationException("saxon:function must be evaluated at compile time");
        }
    }
}

