/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.hof;

import com.saxonica.functions.hof.FunctionType;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.value.SequenceType;

public class DynamicFunctionCallDefinition
extends ExtensionFunctionDefinition {
    private static final StructuredQName qName = new StructuredQName("", "http://saxon.sf.net/", "call");

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 9999;
    }

    public SequenceType[] getArgumentTypes() {
        SequenceType[] types = new SequenceType[]{AnyFunctionType.SINGLE_FUNCTION, SequenceType.ANY_SEQUENCE};
        return types;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        if (suppliedArgumentTypes[0].getPrimaryType() instanceof FunctionType) {
            return ((FunctionType)suppliedArgumentTypes[0].getPrimaryType()).getResultType();
        }
        return SequenceType.ANY_SEQUENCE;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new DynamicFunctionCall();
    }

    public static class DynamicFunctionCall
    extends ExtensionFunctionCall {
        public Expression rewrite(StaticContext context, Expression[] arguments) throws XPathException {
            if (!context.getConfiguration().isLicensed()) {
                throw new XPathException("saxon:call() requires a Saxon-EE license");
            }
            return super.rewrite(context, arguments);
        }

        public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
            Item f = arguments[0].next();
            if (!(f instanceof FunctionItem)) {
                XPathException err = new XPathException("First argument to saxon:call() must be a value obtained from saxon:function()");
                err.setXPathContext(context);
                err.setErrorCode("XPTY0004");
                throw err;
            }
            FunctionItem fcf = (FunctionItem)f;
            int arity = fcf.getArity();
            if (arity != arguments.length - 1) {
                XPathException err = new XPathException("Error in dynamic function call. Number of arguments required = " + arity + "; number supplied = " + (arguments.length - 1));
                err.setXPathContext(context);
                err.setErrorCode("XPTY0004");
                throw err;
            }
            SequenceIterator[] args = new SequenceIterator[arity];
            System.arraycopy(arguments, 1, args, 0, arity);
            return fcf.invoke(args, context);
        }
    }
}

