/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.hof;

import com.saxonica.functions.hof.AbstractFunctionItem;
import com.saxonica.functions.hof.FunctionType;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class CurriedFunction
extends AbstractFunctionItem {
    private FunctionItem targetFunction;
    private int boundArg;
    private ValueRepresentation boundValue;
    private FunctionItemType functionType;

    public CurriedFunction(FunctionItem targetFunction, int boundArg, ValueRepresentation boundValue) throws XPathException {
        this.targetFunction = targetFunction;
        this.boundArg = boundArg - 1;
        this.boundValue = boundValue;
        int arity = targetFunction.getArity();
        if (boundArg > arity) {
            throw new XPathException("In partial-apply(), cannot bind argument " + boundArg + " of a function that has " + arity + " argument" + (arity == 1 ? "" : "s"), "FOFU0001");
        }
        if (boundArg <= 0) {
            throw new XPathException("Argument position for partial-apply() is <= 0", "FOFU0001");
        }
    }

    public FunctionItemType getFunctionItemType() {
        if (this.functionType == null) {
            FunctionItemType base = this.targetFunction.getFunctionItemType();
            if (base instanceof FunctionType) {
                SequenceType[] baseTypes = ((FunctionType)base).getArgumentTypes();
                SequenceType[] argTypes = new SequenceType[baseTypes.length - 1];
                for (int i = 0; i < baseTypes.length; ++i) {
                    if (i < this.boundArg) {
                        argTypes[i] = baseTypes[i];
                        continue;
                    }
                    if (i <= this.boundArg) continue;
                    argTypes[i - 1] = baseTypes[i];
                }
                this.functionType = new FunctionType(argTypes, ((FunctionType)base).getResultType());
            } else {
                this.functionType = AnyFunctionType.getInstance();
            }
        }
        return this.functionType;
    }

    public StructuredQName getFunctionName() {
        return null;
    }

    public int getArity() {
        return this.targetFunction.getArity() - 1;
    }

    public SequenceIterator invoke(SequenceIterator[] args, XPathContext context) throws XPathException {
        SequenceIterator[] newArgs = new SequenceIterator[args.length + 1];
        newArgs[this.boundArg] = Value.asIterator(this.boundValue);
        for (int i = 0; i < args.length; ++i) {
            if (i < this.boundArg) {
                newArgs[i] = args[i];
                continue;
            }
            newArgs[i + 1] = args[i];
        }
        return this.targetFunction.invoke(newArgs, context);
    }
}

