/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import com.saxonica.functions.extfn.CompileQuery;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class QueryFn
extends ExtensionFunctionDefinition {
    private static final StructuredQName qName = new StructuredQName("", "http://saxon.sf.net/", "query");
    private static SequenceType[] argumentTypes = new SequenceType[]{CompileQuery.compiledQueryType, SequenceType.OPTIONAL_ITEM, SequenceType.NODE_SEQUENCE};

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 3;
    }

    public SequenceType[] getArgumentTypes() {
        return argumentTypes;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.ANY_SEQUENCE;
    }

    public boolean dependsOnFocus() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new QueryFnCall();
    }

    private static class QueryFnCall
    extends ExtensionFunctionCall {
        private QueryFnCall() {
        }

        public void supplyStaticContext(StaticContext context, int locationId, Expression[] arguments) throws XPathException {
            if (!context.getConfiguration().isLicensedFeature(64)) {
                throw new XPathException("saxon:query() is not licensed in this Configuration");
            }
        }

        public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
            NamePool pool = context.getController().getNamePool();
            ObjectValue queryExpression = (ObjectValue)arguments[0].next();
            if (queryExpression == null) {
                return null;
            }
            XQueryExpression exp = (XQueryExpression)queryExpression.getObject();
            DynamicQueryContext dqc = new DynamicQueryContext(context.getConfiguration());
            if (arguments.length >= 2) {
                Item source = arguments[1].next();
                if (source != null) {
                    dqc.setContextItem(source);
                }
            } else {
                Item co = context.getContextItem();
                if (co != null) {
                    dqc.setContextItem(context.getContextItem());
                }
            }
            if (arguments.length == 3) {
                Item param;
                while ((param = arguments[2].next()) != null) {
                    if (param instanceof NodeInfo) {
                        switch (((NodeInfo)param).getNodeKind()) {
                            case 1: 
                            case 2: {
                                Value val = ((NodeInfo)param).atomize();
                                dqc.setParameterValue(pool.getClarkName(((NodeInfo)param).getNameCode()), val);
                                break;
                            }
                            case 9: {
                                NodeInfo kid;
                                AxisIterator kids = ((NodeInfo)param).iterateAxis((byte)3, NodeKindTest.ELEMENT);
                                while ((kid = (NodeInfo)kids.next()) != null) {
                                    Value val2 = ((NodeInfo)param).atomize();
                                    dqc.setParameterValue(pool.getClarkName(kid.getNameCode()), val2);
                                }
                                break;
                            }
                            default: {
                                throw new XPathException("Parameters passed to saxon:query() must be element, attribute, or document nodes");
                            }
                        }
                        continue;
                    }
                    throw new XPathException("Parameters passed to saxon:query() must be nodes");
                }
            }
            return exp.iterator(dqc);
        }
    }
}

