/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import java.io.StringReader;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;
import org.xml.sax.InputSource;

public class Parse
extends ExtensionFunctionDefinition {
    private static final StructuredQName qName = new StructuredQName("", "http://saxon.sf.net/", "parse");

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.makeSequenceType(NodeKindTest.DOCUMENT, 16384);
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ParseCall();
    }

    protected static class ParseCall
    extends ExtensionFunctionCall {
        private String baseURI;

        protected ParseCall() {
        }

        public void supplyStaticContext(StaticContext context, int locationId, Expression[] arguments) throws XPathException {
            if (this.baseURI == null) {
                this.baseURI = context.getBaseURI();
            }
            if (!context.getConfiguration().isLicensedFeature(64)) {
                throw new XPathException("saxon:parse is not licensed in this Configuration");
            }
        }

        public void copyLocalData(ExtensionFunctionCall destination) {
            ((ParseCall)destination).baseURI = this.baseURI;
        }

        public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
            Builder b;
            Controller controller = context.getController();
            Configuration configuration = controller.getConfiguration();
            AtomicValue content = (AtomicValue)arguments[0].next();
            StringReader sr = new StringReader(content.getStringValue());
            InputSource is = new InputSource(sr);
            is.setSystemId(this.baseURI);
            SAXSource source = new SAXSource(is);
            source.setSystemId(this.baseURI);
            Receiver s = b = controller.makeBuilder();
            ParseOptions options = new ParseOptions();
            options.setStripSpace(4);
            options.setErrorListener(context.getConfiguration().getErrorListener());
            this.setXMLReader(configuration, options);
            if (controller.getExecutable().stripsInputTypeAnnotations()) {
                s = configuration.getAnnotationStripper(s);
            }
            s.setPipelineConfiguration(b.getPipelineConfiguration());
            Sender.send(source, s, options);
            NodeInfo node = b.getCurrentRoot();
            b.reset();
            return SingletonIterator.makeIterator(node);
        }

        protected void setXMLReader(Configuration config, ParseOptions source) throws XPathException {
        }
    }
}

