/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import com.saxonica.expr.ContextCall;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ContextMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.sort.GroupByIterator;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.value.SequenceType;

public class ForEachGroupFunction
extends ExtensionFunctionDefinition {
    private static final StructuredQName qName = new StructuredQName("", "http://saxon.sf.net/", "for-each-group");

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 3;
    }

    public int getMaximumNumberOfArguments() {
        return 3;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.ANY_SEQUENCE, SequenceType.SINGLE_ITEM, SequenceType.SINGLE_ITEM};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.ANY_SEQUENCE;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ForEachGroupFunctionCall();
    }

    private static class ForEachGroupMappingFunction
    implements ContextMappingFunction {
        public GroupByIterator grouper;
        public FunctionItem action;

        private ForEachGroupMappingFunction() {
        }

        public SequenceIterator map(XPathContext context) throws XPathException {
            ListIterator group = new ListIterator(this.grouper.getCurrentGroup());
            SequenceIterator[] args = new SequenceIterator[]{group};
            return this.action.invoke(args, context);
        }
    }

    private static class ForEachGroupFunctionCall
    extends ExtensionFunctionCall {
        private String defaultCollation;

        private ForEachGroupFunctionCall() {
        }

        public void supplyStaticContext(StaticContext context, int locationId, Expression[] arguments) throws XPathException {
            this.defaultCollation = context.getDefaultCollationName();
        }

        public Expression rewrite(StaticContext context, Expression[] arguments) throws XPathException {
            if (!context.getConfiguration().isLicensed()) {
                throw new XPathException("saxon:for-each-group() requires a Saxon-EE license");
            }
            return super.rewrite(context, arguments);
        }

        public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
            SequenceIterator population = arguments[0];
            FunctionItem key = (FunctionItem)arguments[1].next();
            FunctionItem action = (FunctionItem)arguments[2].next();
            GroupByIterator grouper = new GroupByIterator(population, new Atomizer(new ContextCall(key)), context, context.getCollation(this.defaultCollation));
            ForEachGroupMappingFunction map = new ForEachGroupMappingFunction();
            map.grouper = grouper;
            map.action = action;
            XPathContextMinor c2 = context.newMinorContext();
            c2.setCurrentIterator(grouper);
            return new ContextMappingIterator(map, c2);
        }
    }
}

