/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import com.saxonica.expr.TryCatch;
import com.saxonica.functions.extfn.AnalyzeStringFunction;
import com.saxonica.functions.extfn.CompileQuery;
import com.saxonica.functions.extfn.CompileStylesheet;
import com.saxonica.functions.extfn.DeepEqual;
import com.saxonica.functions.extfn.DynamicErrorInfo;
import com.saxonica.functions.extfn.Eval;
import com.saxonica.functions.extfn.Evaluate;
import com.saxonica.functions.extfn.EvaluateNode;
import com.saxonica.functions.extfn.ExpressionFn;
import com.saxonica.functions.extfn.Find;
import com.saxonica.functions.extfn.ForEachGroupFunction;
import com.saxonica.functions.extfn.Highest;
import com.saxonica.functions.extfn.Index;
import com.saxonica.functions.extfn.LastModified;
import com.saxonica.functions.extfn.Leading;
import com.saxonica.functions.extfn.Lowest;
import com.saxonica.functions.extfn.Parse;
import com.saxonica.functions.extfn.ParseHtml;
import com.saxonica.functions.extfn.QueryFn;
import com.saxonica.functions.extfn.Serialize;
import com.saxonica.functions.extfn.Sort;
import com.saxonica.functions.extfn.TransformFn;
import com.saxonica.functions.hof.DynamicFunctionCallDefinition;
import com.saxonica.functions.hof.DynamicFunctionConstructor;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.instruct.CopyOf;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.expr.sort.IntHashMap;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.VendorFunctionLibrary;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.trans.XPathException;

public class ExtraFunctionLibrary
extends VendorFunctionLibrary {
    Configuration config;
    private static final StructuredQName formatDate = new StructuredQName("saxon", "http://saxon.sf.net/", "format-date");
    private static final StructuredQName formatTime = new StructuredQName("saxon", "http://saxon.sf.net/", "format-time");
    private static final StructuredQName formatDateTime = new StructuredQName("saxon", "http://saxon.sf.net/", "format-dateTime");
    private static final StructuredQName formatNumber = new StructuredQName("saxon", "http://saxon.sf.net/", "format-number");
    private static final StructuredQName resultDocument = new StructuredQName("saxon", "http://saxon.sf.net/", "result-document");
    private static final StructuredQName tryFn = new StructuredQName("saxon", "http://saxon.sf.net/", "try");
    private static final StructuredQName streamFn = new StructuredQName("saxon", "http://saxon.sf.net/", "stream");

    public ExtraFunctionLibrary(Configuration config) {
        this.config = config;
        this.init(config);
    }

    protected void init(Configuration config) {
        try {
            this.registerFunction(new AnalyzeStringFunction());
            this.registerFunction(new CompileQuery());
            this.registerFunction(new CompileStylesheet());
            this.registerFunction(new DeepEqual());
            this.registerFunction(new DynamicErrorInfo());
            this.registerFunction(new DynamicFunctionConstructor());
            this.registerFunction(new DynamicFunctionCallDefinition());
            this.registerFunction(new Eval(config));
            this.registerFunction(new Evaluate());
            this.registerFunction(new EvaluateNode());
            this.registerFunction(new ExpressionFn(config));
            this.registerFunction(new Find());
            this.registerFunction(new ForEachGroupFunction());
            this.registerFunction(new Highest());
            this.registerFunction(new Index());
            this.registerFunction(new LastModified());
            this.registerFunction(new Leading());
            this.registerFunction(new Lowest());
            this.registerFunction(new Parse());
            this.registerFunction(new ParseHtml());
            this.registerFunction(new QueryFn());
            this.registerFunction(new Serialize());
            this.registerFunction(new Sort());
            this.registerFunction(new TransformFn());
        }
        catch (XPathException e) {
            throw new IllegalStateException("Failed to instantiate Saxon extension function", e);
        }
    }

    public Expression bind(StructuredQName functionName, Expression[] staticArgs, StaticContext env, Container container) throws XPathException {
        Expression exp = super.bind(functionName, staticArgs, env, container);
        if (exp != null) {
            return exp;
        }
        if (functionName.equals(formatDate)) {
            return SystemFunction.makeSystemFunction("format-date", staticArgs);
        }
        if (functionName.equals(formatTime)) {
            return SystemFunction.makeSystemFunction("format-time", staticArgs);
        }
        if (functionName.equals(formatDateTime)) {
            return SystemFunction.makeSystemFunction("format-dateTime", staticArgs);
        }
        if (functionName.equals(formatNumber)) {
            return SystemFunction.makeSystemFunction("format-number", staticArgs);
        }
        if (functionName.equals(resultDocument)) {
            this.checkArgumentCount(functionName, staticArgs, 3, 3);
            Expression href = staticArgs[0];
            Expression content = staticArgs[1];
            Expression format = staticArgs[2];
            ResultDocument instruction = new ResultDocument(new Properties(), new Properties(), href, null, env.getBaseURI(), 4, null, new IntHashMap<Expression>(), env.getNamespaceResolver());
            instruction.setContentExpression(content);
            instruction.setDynamicOutputElement(format);
            return instruction;
        }
        if (functionName.equals(streamFn)) {
            this.checkArgumentCount(functionName, staticArgs, 1, 1);
            CopyOf copy = new CopyOf(staticArgs[0], true, 3, null, true);
            copy.setReadOnce(true);
            return copy;
        }
        if (functionName.equals(tryFn)) {
            this.checkArgumentCount(functionName, staticArgs, 2, 2);
            TryCatch tryCatch = new TryCatch(staticArgs[0]);
            tryCatch.addCatchExpression(AnyNodeTest.getInstance(), staticArgs[1]);
            return tryCatch;
        }
        return null;
    }

    private void checkArgumentCount(StructuredQName functionName, Expression[] staticArgs, int min, int max) throws XPathException {
        if (staticArgs.length < min) {
            throw new XPathException("Call to " + functionName.getDisplayName() + " must have at least " + min + " " + this.plural("argument", min));
        }
        if (staticArgs.length > max) {
            throw new XPathException("Call to " + functionName.getDisplayName() + " must have at most " + min + " " + this.plural("argument", max));
        }
    }

    private String plural(String word, int count) {
        return count == 1 ? word : word + "s";
    }
}

