/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.number.NamedTimeZone;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.serialize.charcode.UTF8CharacterSet;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.tree.util.ProcInstParser;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;

public class Extensions {
    private Extensions() {
    }

    public static void pauseTracing(XPathContext c) {
        c.getController().pauseTracing(true);
    }

    public static void resumeTracing(XPathContext c) {
        c.getController().pauseTracing(false);
    }

    public static String systemId(XPathContext c) throws XPathException {
        Item item = c.getContextItem();
        if (item == null) {
            XPathException e = new XPathException("The context item for saxon:systemId() is not set");
            e.setXPathContext(c);
            throw e;
        }
        if (item instanceof NodeInfo) {
            return ((NodeInfo)item).getSystemId();
        }
        return "";
    }

    public static StringValue generateId(NodeInfo node) {
        FastStringBuffer buffer = new FastStringBuffer(64);
        node.generateId(buffer);
        buffer.condense();
        return new StringValue(buffer);
    }

    public static int lineNumber(XPathContext c) {
        Item item = c.getContextItem();
        if (item instanceof NodeInfo) {
            return ((NodeInfo)item).getLineNumber();
        }
        return -1;
    }

    public static int lineNumber(NodeInfo node) {
        if (node == null) {
            return -1;
        }
        return node.getLineNumber();
    }

    public static int columnNumber(XPathContext c) {
        Item item = c.getCurrentIterator().current();
        if (item instanceof NodeInfo) {
            return ((NodeInfo)item).getColumnNumber();
        }
        return -1;
    }

    public static int columnNumber(NodeInfo node) {
        if (node == null) {
            return -1;
        }
        return node.getColumnNumber();
    }

    public static DocumentInfo discardDocument(XPathContext context, DocumentInfo doc) {
        if (doc == null) {
            return null;
        }
        Controller c = context.getController();
        String uri = c.getDocumentPool().getDocumentURI(doc);
        if (uri != null) {
            c.removeUnavailableOutputDestination(new DocumentURI(uri));
        }
        return c.getDocumentPool().discard(doc);
    }

    public static boolean hasSameNodes(SequenceIterator p1, SequenceIterator p2) throws XPathException {
        NodeInfo n2;
        NodeInfo n1;
        SequenceIterator e1 = p1;
        SequenceIterator e2 = p2;
        if (e1 == null) {
            e1 = EmptyIterator.getInstance();
        }
        if (e2 == null) {
            e2 = EmptyIterator.getInstance();
        }
        do {
            n1 = (NodeInfo)e1.next();
            n2 = (NodeInfo)e2.next();
            if (n1 != null && n2 != null) continue;
            return n1 == n2;
        } while (n1.isSameNodeInfo(n2));
        return false;
    }

    public static String path(XPathContext context, NodeInfo node) throws XPathException {
        return Navigator.getPath(node, context);
    }

    public static String path(XPathContext c) throws XPathException {
        Item item = c.getContextItem();
        if (item == null) {
            XPathException e = new XPathException("The context item for saxon:path() is not set");
            e.setXPathContext(c);
            throw e;
        }
        if (item instanceof NodeInfo) {
            return Navigator.getPath((NodeInfo)item, c);
        }
        return "";
    }

    public static QNameValue typeAnnotation(XPathContext context, Item item) {
        String p2;
        int nc;
        if (item == null) {
            return null;
        }
        if (item instanceof NodeInfo) {
            NodeInfo node = (NodeInfo)item;
            nc = node.getTypeAnnotation();
            if (nc == -1) {
                int nodeKind = node.getNodeKind();
                nc = nodeKind == 1 || nodeKind == 9 ? 630 : (nodeKind == 3 ? 631 : 513);
            } else if ((nc & 0x40000000) != 0) {
                nc = 631;
            }
        } else {
            AtomicType label = ((AtomicValue)item).getTypeLabel();
            nc = label.getNameCode();
        }
        String local = context.getNamePool().getLocalName(nc);
        String uri = context.getNamePool().getURI(nc);
        String prefix = context.getNamePool().getPrefix(nc);
        if (prefix.length() == 0 && (p2 = context.getNamePool().suggestPrefixForURI(uri)) != null) {
            prefix = p2;
        }
        return new QNameValue(prefix, uri, local);
    }

    public static XPathContext getContext(XPathContext c) {
        return c;
    }

    public static Controller getController(XPathContext c) {
        return c.getController();
    }

    public static Configuration getConfiguration(XPathContext c) {
        return c.getConfiguration();
    }

    public static String printStack(XPathContext c) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
        StandardErrorListener.printStackTrace(new PrintStream(baos), c);
        return baos.toString().replace("\r", "");
    }

    public static String getPseudoAttribute(XPathContext c, String name) throws XPathException {
        if (name == null) {
            return null;
        }
        Item pi = c.getContextItem();
        if (pi == null) {
            XPathException e = new XPathException("The context item for saxon:getPseudoAttribute() is not set");
            e.setXPathContext(c);
            throw e;
        }
        String val = ProcInstParser.getPseudoAttribute(pi.getStringValue(), name);
        if (val == null) {
            return "";
        }
        return val;
    }

    public static BigDecimal decimalDivide(BigDecimal arg1, BigDecimal arg2, int scale) {
        if (arg1 == null || arg2 == null) {
            return null;
        }
        return arg1.divide(arg2, scale, 1);
    }

    public static List stringToUtf8(String in) {
        if (in == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(in.length() * 2);
        byte[] octets = new byte[4];
        for (int i = 0; i < in.length(); ++i) {
            int used = UTF8CharacterSet.getUTF8Encoding(in.charAt(i), i + 1 < in.length() ? in.charAt(i + 1) : (char)'\u0000', octets);
            for (int j = 0; j < used; ++j) {
                list.add(0xFF & octets[j]);
            }
        }
        return list;
    }

    public static Base64BinaryValue octetsToBase64Binary(byte[] in) {
        if (in == null) {
            return null;
        }
        return new Base64BinaryValue(in);
    }

    public static HexBinaryValue octetsToHexBinary(byte[] in) {
        if (in == null) {
            return null;
        }
        return new HexBinaryValue(in);
    }

    public static byte[] base64BinaryToOctets(Base64BinaryValue in) {
        if (in == null) {
            return null;
        }
        return in.getBinaryValue();
    }

    public static byte[] hexBinaryToOctets(HexBinaryValue in) {
        if (in == null) {
            return null;
        }
        return in.getBinaryValue();
    }

    public static String base64BinaryToString(XPathContext context, Base64BinaryValue in, String encoding) throws Exception {
        if (in == null) {
            return null;
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        byte[] bytes = in.getBinaryValue();
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        InputStreamReader reader = new InputStreamReader((InputStream)stream, encoding);
        char[] array = new char[bytes.length];
        int used = reader.read(array, 0, array.length);
        Extensions.checkBytes(array, 0, used, context.getConfiguration().getNameChecker());
        return new String(array, 0, used);
    }

    public static Base64BinaryValue stringToBase64Binary(String in, String encoding) throws IOException {
        if (in == null) {
            return null;
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream(in.length());
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, encoding);
        writer.write(in);
        writer.close();
        byte[] bytes = stream.toByteArray();
        return Extensions.octetsToBase64Binary(bytes);
    }

    public static String hexBinaryToString(XPathContext context, HexBinaryValue in, String encoding) throws Exception {
        if (in == null) {
            return null;
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        byte[] bytes = in.getBinaryValue();
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        InputStreamReader reader = new InputStreamReader((InputStream)stream, encoding);
        char[] array = new char[bytes.length];
        int used = reader.read(array, 0, array.length);
        Extensions.checkBytes(array, 0, used, context.getConfiguration().getNameChecker());
        return new String(array, 0, used);
    }

    private static void checkBytes(char[] array, int start, int end, NameChecker checker) throws XPathException {
        int ch32 = checker.firstInvalidChar(new CharSlice(array, start, end - start));
        if (ch32 != -1) {
            XPathException err = new XPathException("The byte sequence contains a character not allowed by XML (hex " + Integer.toHexString(ch32) + ')');
            err.setErrorCode("XTDE1180");
            throw err;
        }
    }

    public static HexBinaryValue stringToHexBinary(String in, String encoding) throws Exception {
        if (in == null) {
            return null;
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream(in.length());
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, encoding);
        writer.write(in);
        writer.close();
        byte[] bytes = stream.toByteArray();
        return Extensions.octetsToHexBinary(bytes);
    }

    public static boolean validCharacter(XPathContext c, int in) {
        return c.getConfiguration().getNameChecker().isValidChar(in);
    }

    public static NodeInfo namespaceNode(XPathContext context, String prefix, String uri) throws XPathException {
        if (prefix == null) {
            prefix = "";
        } else if (prefix.length() != 0 && !context.getConfiguration().getNameChecker().isValidNCName(prefix)) {
            throw new XPathException("Namespace prefix " + Err.wrap(prefix) + " is not a valid NCName");
        }
        if (uri == null || uri.length() == 0) {
            throw new XPathException("URI of namespace node must not be empty");
        }
        NamePool namePool = context.getNamePool();
        Orphan node = new Orphan(context.getConfiguration());
        node.setNodeKind((short)13);
        node.setNameCode(namePool.allocate("", "", prefix));
        node.setStringValue(uri);
        return node;
    }

    public static String[] unparsedEntities(DocumentInfo doc) throws XPathException {
        Iterator<String> names = doc.getUnparsedEntityNames();
        int count = 0;
        while (names.hasNext()) {
            names.next();
            ++count;
        }
        String[] ss = new String[count];
        names = doc.getUnparsedEntityNames();
        count = 0;
        while (names.hasNext()) {
            ss[count++] = names.next();
        }
        return ss;
    }

    public static BooleanValue inSummerTime(XPathContext context, DateTimeValue date, String region) {
        Boolean b;
        if (date == null) {
            return null;
        }
        if (!date.hasTimezone()) {
            try {
                date = (DateTimeValue)date.adjustTimezone(context.getImplicitTimezone());
            }
            catch (NoDynamicContextException err) {
                date = (DateTimeValue)date.adjustTimezone(0);
            }
        }
        return (b = NamedTimeZone.inSummerTime(date, region)) == null ? null : BooleanValue.get(b);
    }

    public static DateTimeValue adjustToCivilTime(XPathContext context, DateTimeValue date, String region) {
        if (date == null) {
            return null;
        }
        if (!date.hasTimezone()) {
            try {
                date = (DateTimeValue)date.adjustTimezone(context.getImplicitTimezone());
            }
            catch (NoDynamicContextException err) {
                date = (DateTimeValue)date.adjustTimezone(0);
            }
        }
        int ms = NamedTimeZone.civilTimeOffset(date, region);
        return (DateTimeValue)date.adjustTimezone(ms / 60000);
    }

    public static QNameValue currentModeName(XPathContext context) {
        Mode mode = context.getCurrentMode();
        if (mode == null) {
            return null;
        }
        StructuredQName name = mode.getModeName();
        if (name == null) {
            return null;
        }
        return new QNameValue(name, BuiltInAtomicType.QNAME);
    }
}

