/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import com.saxonica.functions.extfn.Evaluate;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;

public class ExpressionFn
extends Evaluate {
    Configuration config;
    private static final StructuredQName qName = new StructuredQName("", "http://saxon.sf.net/", "expression");
    private static final SequenceType[] argumentTypes = new SequenceType[]{SequenceType.SINGLE_STRING, SequenceType.SINGLE_ELEMENT_NODE};

    public ExpressionFn(Configuration config) {
        this.config = config;
    }

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 2;
    }

    public SequenceType[] getArgumentTypes() {
        return argumentTypes;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        ExternalObjectType preparedExpressionType = new ExternalObjectType(Evaluate.PreparedExpression.class, this.config);
        return SequenceType.makeSequenceType(preparedExpressionType, 16384);
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExpressionFnCall();
    }

    private static class ExpressionFnCall
    extends Evaluate.EvaluateCall {
        private ExpressionFnCall() {
        }

        public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
            XPathContextMajor c2 = context.newCleanContext();
            String exprText = arguments[0].next().getStringValue();
            NodeInfo namespaceOrigin = null;
            if (arguments.length > 1) {
                namespaceOrigin = (NodeInfo)arguments[1].next();
            }
            Evaluate.PreparedExpression pexpr = this.prepareExpression(exprText, namespaceOrigin, "saxon:expression", c2);
            return SingletonIterator.makeIterator(new ObjectValue(pexpr));
        }
    }
}

