/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import com.saxonica.functions.extfn.Evaluate;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.InstructionDetails;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.sxpath.DedicatedStaticContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.SequenceType;

public class EvaluateNode
extends Evaluate {
    private static final StructuredQName qName = new StructuredQName("", "http://saxon.sf.net/", "evaluate-node");

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_NODE};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.ANY_SEQUENCE;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new EvaluateNodeCall();
    }

    private static class EvaluateNodeCall
    extends Evaluate.EvaluateCall {
        private EvaluateNodeCall() {
        }

        public void supplyStaticContext(StaticContext env, int locationId, Expression[] arguments) throws XPathException {
            Executable exec = env instanceof Container ? ((Container)((Object)env)).getExecutable() : (env instanceof ExpressionContext ? ((ExpressionContext)env).getExecutable() : new Executable(env.getConfiguration()));
            if (exec instanceof PreparedStylesheet) {
                ((PreparedStylesheet)exec).setReasonUnableToCompile("Cannot compile a stylesheet containing calls to saxon:evaluate-node");
            }
            if (!env.getConfiguration().isLicensedFeature(64)) {
                throw new XPathException("saxon:evaluate-node is not licensed in this Configuration");
            }
            if (this.staticContext == null) {
                this.staticContext = new DedicatedStaticContext(env.getConfiguration());
                this.staticContext.setExecutable(exec);
                this.staticContext.setFunctionLibrary(exec.getFunctionLibrary());
                this.details = new InstructionDetails();
                this.details.setConstructType(2051);
                this.details.setSystemId(env.getLocationMap().getSystemId(locationId));
                this.details.setLineNumber(env.getLocationMap().getLineNumber(locationId));
            }
        }

        protected Evaluate.PreparedExpression prepareExpression(NodeInfo node, String functionName, XPathContext context) throws XPathException {
            Expression expr;
            DedicatedStaticContext env = new DedicatedStaticContext(this.staticContext);
            Evaluate.PreparedExpression pexpr = new Evaluate.PreparedExpression();
            pexpr.expStaticContext = env;
            env.setBaseURI(node.getBaseURI());
            env.setFunctionLibrary((FunctionLibraryList)this.staticContext.getFunctionLibrary());
            env.setNamespaces(node);
            String exprText = node.getStringValue();
            try {
                expr = ExpressionTool.make(exprText, env, env, 0, 0, 1, false);
                expr.setContainer(env);
            }
            catch (XPathException e) {
                XPathException err = new XPathException("Static error in XPath expression supplied to " + functionName + ": " + e.getMessage().trim());
                err.setXPathContext(context);
                throw err;
            }
            ItemType contextItemType = Type.ITEM_TYPE;
            ExpressionVisitor visitor = ExpressionVisitor.make(env, expr.getExecutable());
            visitor.setExecutable(env.getExecutable());
            expr = visitor.typeCheck(expr, contextItemType);
            pexpr.stackFrameMap = env.getStackFrameMap();
            ExpressionTool.allocateSlots(expr, pexpr.stackFrameMap.getNumberOfVariables(), pexpr.stackFrameMap);
            pexpr.expression = expr;
            expr.setContainer(env);
            return pexpr;
        }

        public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
            XPathContextMajor c2 = context.newCleanContext();
            NodeInfo node = (NodeInfo)arguments[0].next();
            Evaluate.PreparedExpression pexpr = this.prepareExpression(node, "saxon:evaluate-node", c2);
            c2.setOrigin(this.details);
            c2.openStackFrame(pexpr.stackFrameMap);
            UnfailingIterator single = SingletonIterator.makeIterator(node);
            single.next();
            c2.setCurrentIterator(single);
            return pexpr.expression.iterate(c2);
        }
    }
}

