/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class DynamicErrorInfo
extends ExtensionFunctionDefinition {
    private static final StructuredQName qName = new StructuredQName("", "http://saxon.sf.net/", "dynamic-error-info");

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.ANY_SEQUENCE;
    }

    public boolean dependsOnFocus() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new DynamicErrorInfoCall();
    }

    private static class DynamicErrorInfoCall
    extends ExtensionFunctionCall {
        private DynamicErrorInfoCall() {
        }

        public Expression rewrite(StaticContext context, Expression[] arguments) throws XPathException {
            if (!context.getConfiguration().isLicensed()) {
                throw new XPathException("saxon:dynamic-error-info() requires a Saxon-EE license");
            }
            return super.rewrite(context, arguments);
        }

        public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
            String var = arguments[0].next().getStringValue();
            XPathException error = context.getCurrentException();
            if (error == null) {
                return EmptyIterator.getInstance();
            }
            if (var.equals("code")) {
                StructuredQName errorCodeQName = error.getErrorCodeQName();
                if (errorCodeQName == null) {
                    return EmptyIterator.getInstance();
                }
                return SingletonIterator.makeIterator(new QNameValue(errorCodeQName, BuiltInAtomicType.QNAME));
            }
            if (var.equals("description")) {
                return SingletonIterator.makeIterator(new StringValue(error.getMessage()));
            }
            if (var.equals("value")) {
                Value value = error.getErrorObject();
                if (value == null) {
                    return EmptyIterator.getInstance();
                }
                return value.iterate();
            }
            if (var.equals("module")) {
                String module = error.getLocator().getSystemId();
                if (module == null) {
                    return EmptyIterator.getInstance();
                }
                return SingletonIterator.makeIterator(new StringValue(module));
            }
            if (var.equals("line-number")) {
                int line = error.getLocator().getLineNumber();
                if (line == -1) {
                    return EmptyIterator.getInstance();
                }
                return SingletonIterator.makeIterator(new Int64Value(line));
            }
            if (var.equals("column-number")) {
                int column = error.getLocator().getColumnNumber();
                if (column == -1) {
                    return EmptyIterator.getInstance();
                }
                return SingletonIterator.makeIterator(new Int64Value(column));
            }
            return EmptyIterator.getInstance();
        }
    }
}

