/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;

public class CompileQuery
extends ExtensionFunctionDefinition {
    private static final StructuredQName qName = new StructuredQName("", "http://saxon.sf.net/", "compile-query");
    public static final SequenceType compiledQueryType = SequenceType.makeSequenceType(new ExternalObjectType(XQueryExpression.class), 24576);

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.OPTIONAL_STRING};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return compiledQueryType;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new CompileQueryCall();
    }

    private static class CompileQueryCall
    extends ExtensionFunctionCall {
        private CompileQueryCall() {
        }

        public void supplyStaticContext(StaticContext context, int locationId, Expression[] arguments) throws XPathException {
            if (!context.getConfiguration().isLicensedFeature(64)) {
                throw new XPathException("saxon:compile-query() is not licensed in this Configuration");
            }
        }

        public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
            String query = arguments[0].next().getStringValue();
            StaticQueryContext sqc = context.getConfiguration().newStaticQueryContext();
            XQueryExpression exp = sqc.compileQuery(query);
            return SingletonIterator.makeIterator(new ObjectValue(exp));
        }
    }
}

