/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr.ee;

import com.saxonica.expr.QueryLibraryImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.query.QueryLibrary;
import net.sf.saxon.query.QueryParser;
import net.sf.saxon.query.QueryReader;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.trans.XPathException;

public class StaticQueryContextEE
extends StaticQueryContext {
    private Map<String, QueryLibrary> compiledLibraries = new HashMap<String, QueryLibrary>();

    public StaticQueryContextEE(Configuration config) {
        super(config, false);
    }

    public void compileLibrary(String query) throws XPathException {
        Configuration config = this.getConfiguration();
        Executable executable = this.getExecutable();
        FunctionLibraryList libList = new FunctionLibraryList();
        libList.addFunctionLibrary(new ExecutableFunctionLibrary(config));
        executable.setFunctionLibrary(libList);
        QueryParser qp = (QueryParser)config.newExpressionParser("XQ", this.isUpdating(), this.getLanguageVersion());
        qp.setCompileWithTracing(this.isCompileWithTracing() || config.isCompileWithTracing());
        QueryLibraryImpl topModule = new QueryLibraryImpl(this);
        topModule.setExecutable(executable);
        topModule.setIsMainModule(false);
        qp.parseLibraryModule(query, topModule);
        topModule.bindUnboundFunctionCalls();
        topModule.bindUnboundVariables();
        this.compiledLibraries.put(topModule.getModuleNamespace(), topModule);
        executable.fixupQueryModules(topModule, false);
        executable.addQueryLibraryModule(topModule);
    }

    public void compileLibrary(Reader source) throws XPathException, IOException {
        int n;
        char[] buffer = new char[4096];
        StringBuffer sb = new StringBuffer(4096);
        while ((n = source.read(buffer)) > 0) {
            sb.append(buffer, 0, n);
        }
        this.compileLibrary(sb.toString());
    }

    public void compileLibrary(InputStream source, String encoding) throws XPathException, IOException {
        String query = QueryReader.readInputStream(source, encoding, this.getConfiguration().getNameChecker());
        this.compileLibrary(query);
    }

    public QueryLibrary getCompiledLibrary(String namespace) {
        return this.compiledLibraries.get(namespace);
    }
}

