/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr.ee;

import com.saxonica.expr.IndexedFilterExpression;
import com.saxonica.expr.IndexedValue;
import com.saxonica.expr.PathFinder;
import com.saxonica.expr.SwitchExpression;
import com.saxonica.expr.ee.GeneralComparisonEE;
import com.saxonica.expr.ee.MultithreadedForEach;
import com.saxonica.stream.ExpressionInverter;
import com.saxonica.stream.StreamingApplyTemplates;
import com.saxonica.stream.StreamingCopy;
import com.saxonica.stream.StreamingPatternMaker;
import com.saxonica.stream.TemplateInversion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.LazyExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.QuantifiedExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ApplyImports;
import net.sf.saxon.expr.instruct.ApplyTemplates;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.CallTemplate;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.CopyOf;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.ForEach;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.NextMatch;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.Template;
import net.sf.saxon.expr.instruct.TraceInstruction;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.expr.sort.ConditionalSorter;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.CurrentGroup;
import net.sf.saxon.functions.Doc;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.KeyFn;
import net.sf.saxon.functions.RegexGroup;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.LocationPathPattern;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.query.GlobalVariableDefinition;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.KeyDefinitionSet;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.RuleTarget;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimizerEE
extends Optimizer {
    public OptimizerEE(Configuration config) {
        super(config);
    }

    @Override
    public BinaryExpression simplifyGeneralComparison(GeneralComparison gc, boolean backwardsCompatible) {
        if (gc instanceof GeneralComparisonEE) {
            return gc;
        }
        if (backwardsCompatible) {
            return super.simplifyGeneralComparison(gc, true);
        }
        if (gc.getOperator() == 6) {
            Expression[] operands = gc.getOperands();
            Expression p0 = operands[0];
            Expression p1 = operands[1];
            boolean many0 = Cardinality.expectsMany(p0);
            boolean many1 = Cardinality.expectsMany(p1);
            if (many0 || many1) {
                return new GeneralComparisonEE(p0, gc.getOperator(), p1);
            }
        }
        return gc;
    }

    @Override
    public Expression optimizeCopy(Expression select) throws XPathException {
        Expression e = super.optimizeCopy(select);
        if (e != null) {
            return e;
        }
        if (!this.config.isMultiThreading()) {
            return null;
        }
        Expression result = this.optimizeStreamingCopy(select);
        if (result != null) {
            ExpressionTool.copyLocationInfo(select, result);
            this.trace("Using streaming copy");
        }
        return result;
    }

    public Expression optimizeStreamingCopy(Expression select) throws XPathException {
        if (!(select instanceof PathExpression)) {
            if (select instanceof DocumentSorter) {
                this.trace("Cannot use streaming copy: expression is not provably in document order");
            } else {
                this.trace("Cannot use streaming copy: not a path expression");
            }
            return null;
        }
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        PathExpression pexp = (PathExpression)select;
        Expression start = pexp.getFirstStep();
        if (!(start instanceof Doc) && !(start instanceof DocumentFn)) {
            this.trace("Cannot use streaming copy: path must start with call on doc() or document()");
            return null;
        }
        Expression documentExp = start;
        Expression rest = pexp.getRemainingSteps();
        Expression filter = Literal.makeLiteral(BooleanValue.TRUE);
        if (rest instanceof PathExpression) {
            rest = OptimizerEE.promoteUnion((PathExpression)rest);
        }
        if (rest instanceof VennExpression) {
            HashSet components = new HashSet();
            ((VennExpression)rest).gatherComponents(1, components);
            for (Expression exp : components) {
                ItemType type = exp.getItemType(th);
                if (th.isSubType(type, NodeKindTest.ELEMENT) || th.isSubType(type, NodeKindTest.ATTRIBUTE)) continue;
                this.trace("Cannot use streaming copy: each component of union must return elements or attributes");
                return null;
            }
        } else {
            ItemType type = select.getItemType(th);
            if (!th.isSubType(type, NodeKindTest.ELEMENT) && !th.isSubType(type, NodeKindTest.ATTRIBUTE)) {
                this.trace("Cannot use streaming copy: must be either all-elements or all-attributes");
                return null;
            }
        }
        while (true) {
            FilterExpression fexp = null;
            if (rest instanceof FilterExpression) {
                fexp = (FilterExpression)rest;
            } else if (rest instanceof PathExpression) {
                fexp = this.convertToFilterExpression((PathExpression)rest, this.config.getTypeHierarchy());
            }
            if (fexp == null) break;
            Expression nextFilter = fexp.getFilter();
            if (!nextFilter.isSubtreeExpression()) {
                this.trace("Cannot use streaming copy: filter looks outside subtree");
                return null;
            }
            filter = new BooleanExpression(filter, 10, nextFilter);
            rest = fexp.getControllingExpression();
        }
        ArrayList<String> reasonForFailure = new ArrayList<String>();
        Pattern selectionPattern = this.makeStreamingPattern(rest, reasonForFailure);
        if (selectionPattern == null) {
            String msg = "(unspecified reason)";
            if (!reasonForFailure.isEmpty()) {
                msg = reasonForFailure.get(0).toString();
            }
            this.trace("Cannot use streaming copy: " + msg);
            return null;
        }
        return new StreamingCopy(documentExp, selectionPattern, filter);
    }

    @Override
    public void makeCopyOperationsExplicit(Expression parent, Expression child) throws XPathException {
        block4: {
            block3: {
                boolean replace;
                boolean bl = replace = (child.getSpecialProperties() & 0x100000) != 0;
                if (replace) {
                    CopyOf copy = new CopyOf(child, true, 3, null, false);
                    parent.replaceSubExpression(child, copy);
                    return;
                }
                if (!(child instanceof Choose)) break block3;
                Expression[] actions = ((Choose)child).getActions();
                for (int i = 0; i < actions.length; ++i) {
                    this.makeCopyOperationsExplicit(child, actions[i]);
                }
                break block4;
            }
            if (!(child instanceof Block)) break block4;
            Expression[] actions = ((Block)child).getChildren();
            for (int i = 0; i < actions.length; ++i) {
                this.makeCopyOperationsExplicit(child, actions[i]);
            }
        }
    }

    @Override
    public Expression optimizeForExpressionForStreaming(ForExpression expr) throws XPathException {
        if (ExpressionInverter.consumesStream(expr.getSequence()) && !ExpressionTool.dependsOnFocus(expr.getAction())) {
            expr.replaceVariable(this, new ContextItemExpression());
            Expression action = expr.getAction();
            return new ForEach(expr.getSequence(), action);
        }
        return expr;
    }

    @Override
    public Expression optimizeQuantifiedExpressionForStreaming(QuantifiedExpression expr) throws XPathException {
        if (ExpressionInverter.consumesStream(expr.getSequence()) && !ExpressionTool.dependsOnFocus(expr.getAction())) {
            if (expr.getOperator() == 31) {
                expr.replaceVariable(this, new ContextItemExpression());
                Expression action = expr.getAction();
                Expression[] arguments = new Expression[]{action};
                BooleanFn ebv = (BooleanFn)SystemFunction.makeSystemFunction("boolean", arguments);
                FilterExpression filter = new FilterExpression(expr.getSequence(), ebv);
                Expression[] existsArgs = new Expression[]{filter};
                return SystemFunction.makeSystemFunction("exists", existsArgs);
            }
            expr.replaceVariable(this, new ContextItemExpression());
            Expression action = expr.getAction();
            Expression[] arguments = new Expression[]{action};
            BooleanFn ebv = (BooleanFn)SystemFunction.makeSystemFunction("not", arguments);
            FilterExpression filter = new FilterExpression(expr.getSequence(), ebv);
            Expression[] existsArgs = new Expression[]{filter};
            return SystemFunction.makeSystemFunction("empty", existsArgs);
        }
        return expr;
    }

    private static Expression promoteUnion(PathExpression path) {
        Expression start = path.getFirstStep();
        Expression rest = path.getRemainingSteps();
        if (rest instanceof PathExpression) {
            rest = OptimizerEE.promoteUnion((PathExpression)rest);
        }
        ArrayList operands = new ArrayList(3);
        OptimizerEE.gatherUnionOperands(rest, operands);
        if (operands.size() < 2) {
            return path;
        }
        Expression p = new PathExpression(start, (Expression)operands.get(0));
        for (int i = 1; i < operands.size(); ++i) {
            p = new VennExpression(p, 1, new PathExpression(start.copy(), (Expression)operands.get(i)));
        }
        return p;
    }

    private static void gatherUnionOperands(Expression exp, List list) {
        if (exp instanceof VennExpression && ((VennExpression)exp).getOperator() == 1) {
            Expression[] operands = ((VennExpression)exp).getOperands();
            OptimizerEE.gatherUnionOperands(operands[0], list);
            OptimizerEE.gatherUnionOperands(operands[1], list);
        } else {
            list.add(exp);
        }
    }

    public Pattern makeStreamingPattern(Expression exp, List<String> reasonForFailure) {
        try {
            return StreamingPatternMaker.fromExpression(exp, this.config);
        }
        catch (XPathException e) {
            reasonForFailure.add(e.getMessage());
            return null;
        }
    }

    @Override
    public Expression convertPathExpressionToKey(PathExpression pathExp, ExpressionVisitor visitor) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        PathExpression p = pathExp.tryToMakeAbsolute(th);
        if (p != null) {
            Expression match = p.getRemainingSteps();
            FilterExpression f = null;
            if (match instanceof FilterExpression) {
                f = (FilterExpression)match;
                if (f.getFilter() instanceof BooleanExpression) {
                    f = this.expandComplexFilter(f.getControllingExpression(), f.getFilter());
                }
            } else if (match instanceof PathExpression) {
                f = this.convertToFilterExpression((PathExpression)match, th);
            }
            if (f != null) {
                return this.convertFilterExpressionToKey(f, visitor, p.getFirstStep());
            }
        }
        return null;
    }

    @Override
    public Expression tryIndexedFilter(FilterExpression f, ExpressionVisitor visitor, boolean indexFirstOperand) {
        try {
            Expression k = this.tryToConvertFilterExpressionToKey(f, visitor);
            if (k != null) {
                return k;
            }
            if (f.getControllingExpression() instanceof VariableReference) {
                Binding binding = ((VariableReference)f.getControllingExpression()).getBinding();
                if (binding instanceof LetExpression && visitor.isLoopingSubexpression((LetExpression)binding)) {
                    ((LetExpression)binding).setIndexedVariable();
                    return new IndexedFilterExpression((VariableReference)f.getControllingExpression(), (ComparisonExpression)((Object)f.getFilter()), indexFirstOperand);
                }
                if (binding instanceof UserFunctionParameter && visitor.isLoopingSubexpression(null)) {
                    ((UserFunctionParameter)binding).setIndexedVariable(true);
                    return new IndexedFilterExpression((VariableReference)f.getControllingExpression(), (ComparisonExpression)((Object)f.getFilter()), indexFirstOperand);
                }
                if (binding instanceof GlobalVariable && !(binding instanceof GlobalParam)) {
                    ((GlobalVariable)binding).setIndexedVariable();
                    return new IndexedFilterExpression((VariableReference)f.getControllingExpression(), (ComparisonExpression)((Object)f.getFilter()), indexFirstOperand);
                }
            }
        }
        catch (XPathException e) {
            return f;
        }
        return f;
    }

    private Expression tryToConvertFilterExpressionToKey(FilterExpression f, ExpressionVisitor visitor) throws XPathException {
        Expression base = f.getControllingExpression();
        while (!(base instanceof PathExpression)) {
            if (base instanceof VariableReference) {
                Binding b = ((VariableReference)base).getBinding();
                if (b instanceof LetExpression) {
                    base = ((LetExpression)b).getSequence();
                    continue;
                }
                return null;
            }
            if (base instanceof DocumentSorter) {
                base = ((DocumentSorter)base).getBaseExpression();
                continue;
            }
            if (base instanceof LazyExpression) {
                base = ((LazyExpression)base).getBaseExpression();
                continue;
            }
            if (base instanceof FilterExpression) {
                return this.tryToConvertFilterExpressionToKey((FilterExpression)base, visitor);
            }
            return null;
        }
        PathExpression path = (PathExpression)base;
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        PathExpression p = path.tryToMakeAbsolute(th);
        if (p == null) {
            return null;
        }
        Expression doc = p.getFirstStep();
        return this.convertFilterExpressionToKey(f, visitor, doc);
    }

    private Expression convertFilterExpressionToKey(FilterExpression f, ExpressionVisitor visitor, Expression doc) throws XPathException {
        Expression call;
        Executable exec;
        boolean convertUntypedToOther;
        if (f.getFilter() instanceof BooleanExpression) {
            f = this.expandComplexFilter(f.getControllingExpression(), f.getFilter());
        }
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        int indexableFlag = this.isIndexableFilter(f.getFilter());
        if (indexableFlag == 0) {
            if (f.isPositional(th)) {
                return null;
            }
            return this.tryConvertingInnerPredicate(f, visitor, doc);
        }
        boolean indexFirstOperand = indexableFlag > 0;
        Expression path = f.getControllingExpression();
        if ((path.getDependencies() & 0xFFFFFBED) != 0) {
            return this.tryConvertingInnerPredicate(f, visitor, doc);
        }
        ComparisonExpression fc = (ComparisonExpression)((Object)f.getFilter());
        Expression[] operands = fc.getOperands();
        Expression use = operands[indexFirstOperand ? 0 : 1];
        Expression value = operands[indexFirstOperand ? 1 : 0];
        if ((use.getDependencies() & 0xFFFFFBFD) != 0) {
            return null;
        }
        int props = path.getSpecialProperties();
        if ((props & 0x400000) == 0 || (props & 0x800000) == 0) {
            return null;
        }
        if ((props & 0x20000) == 0) {
            DocumentSorter sorter = new DocumentSorter(path);
            ExpressionTool.copyLocationInfo(path, sorter);
            path = sorter;
        }
        PathFinder pathFinder = new PathFinder(path);
        ItemType useType = use.getItemType(th);
        if (!useType.isAtomicType()) {
            use = new Atomizer(use).simplify(visitor);
            ExpressionTool.copyLocationInfo(f, use);
            useType = use.getItemType(th);
            if (((AtomicType)useType).isExternalType()) {
                return null;
            }
        }
        if (convertUntypedToOther = fc.convertsUntypedToOther()) {
            AtomicType valueType = value.getItemType(th).getAtomizedItemType();
            if (!useType.equals(BuiltInAtomicType.ANY_ATOMIC) || !valueType.equals(BuiltInAtomicType.ANY_ATOMIC)) {
                AtomicType targetType;
                if ((useType.equals(BuiltInAtomicType.ANY_ATOMIC) || useType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) && !valueType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && !th.isSubType(valueType, BuiltInAtomicType.STRING)) {
                    targetType = valueType;
                    if (th.isSubType(targetType, BuiltInAtomicType.NUMERIC)) {
                        targetType = BuiltInAtomicType.DOUBLE;
                    }
                    use = new AtomicSequenceConverter(use, targetType);
                } else if ((valueType.equals(BuiltInAtomicType.ANY_ATOMIC) || valueType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) && !useType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && !th.isSubType(useType, BuiltInAtomicType.STRING)) {
                    targetType = valueType;
                    if (th.isSubType(targetType, BuiltInAtomicType.NUMERIC)) {
                        targetType = BuiltInAtomicType.DOUBLE;
                    }
                    value = new AtomicSequenceConverter(value, targetType);
                }
            }
        }
        if ((exec = visitor.getExecutable()) == null) {
            this.getConfiguration().getStandardErrorOutput().println("Internal problem prevents optimization using an index: please report");
            return null;
        }
        SlotManager slotManager = visitor.getConfiguration().makeSlotManager();
        int slots = ExpressionTool.allocateSlots(pathFinder.getSelectionExpression(), 0, slotManager);
        ExpressionTool.allocateSlots(use, slots, slotManager);
        String defaultCollationName = visitor.getStaticContext().getDefaultCollationName();
        KeyDefinition key = new KeyDefinition(pathFinder, use, defaultCollationName, visitor.getExecutable().getNamedCollation(defaultCollationName));
        key.setIndexedItemType((BuiltInAtomicType)useType.getPrimitiveItemType());
        key.setConvertUntypedToOther(convertUntypedToOther);
        key.setStackFrameMap(slotManager);
        StructuredQName keyName = new StructuredQName("saxon", "http://saxon.sf.net/", "kk" + (100 + exec.getKeyManager().getNumberOfKeyDefinitions()));
        if (f.getFilter() instanceof ValueComparison) {
            key.setStrictComparison(true);
        }
        try {
            exec.getKeyManager().addKeyDefinition(keyName, key, visitor.getConfiguration());
        }
        catch (XPathException err) {
            throw new AssertionError((Object)err);
        }
        KeyDefinitionSet keySet = exec.getKeyManager().getKeyDefinitionSet(keyName);
        if (doc.getCardinality() != 16384) {
            ForExpression forExp = new ForExpression();
            forExp.setRequiredType(SequenceType.makeSequenceType(doc.getItemType(th), doc.getCardinality()));
            forExp.setVariableQName(new StructuredQName("dd", "http://saxon.sf.net/", "dd" + forExp.hashCode()));
            Expression docs = doc;
            if ((docs.getSpecialProperties() & 0x20000) == 0) {
                docs = new DocumentSorter(docs);
            }
            forExp.setSequence(docs);
            LocalVariableReference docVar = new LocalVariableReference(forExp);
            call = KeyFn.internalKeyCall(keySet, keyName.getDisplayName(), value, docVar);
            forExp.setAction(call);
            call = forExp;
        } else {
            call = KeyFn.internalKeyCall(keySet, keyName.getDisplayName(), value, doc);
        }
        ExpressionTool.copyLocationInfo(f, call);
        this.trace("Replaced filter expression with call to key function: ", call);
        return call;
    }

    private Expression tryConvertingInnerPredicate(FilterExpression f, ExpressionVisitor visitor, Expression doc) throws XPathException {
        Expression base = f.getControllingExpression();
        if (base instanceof FilterExpression) {
            Expression pred = f.getFilter();
            Expression k = this.convertFilterExpressionToKey((FilterExpression)base, visitor, doc);
            if (k != null) {
                FilterExpression kf = new FilterExpression(k, pred);
                ExpressionTool.copyLocationInfo(f, kf);
                return kf;
            }
            return null;
        }
        return null;
    }

    @Override
    public FilterExpression convertToFilterExpression(PathExpression pathExp, TypeHierarchy th) throws XPathException {
        Expression head = pathExp.getFirstStep();
        Expression tail = pathExp.getRemainingSteps();
        ArrayList<Expression> path = new ArrayList<Expression>(3);
        path.add(head);
        while (tail instanceof PathExpression) {
            head = ((PathExpression)tail).getFirstStep();
            path.add(head);
            tail = ((PathExpression)tail).getRemainingSteps();
        }
        if (tail instanceof FilterExpression && !((FilterExpression)tail).isPositional(th)) {
            FilterExpression e;
            Expression predicate = ((FilterExpression)tail).getFilter();
            Expression last = ((FilterExpression)tail).getControllingExpression();
            boolean repeat = last instanceof FilterExpression;
            for (int i = path.size() - 1; i >= 0; --i) {
                last = new PathExpression((Expression)path.get(i), last);
                ExpressionTool.copyLocationInfo(pathExp, last);
            }
            if (last instanceof PathExpression && repeat && (e = this.convertToFilterExpression((PathExpression)last, th)) != null) {
                last = e;
            }
            if (predicate instanceof BooleanExpression) {
                return this.expandComplexFilter(last, predicate);
            }
            FilterExpression fe = new FilterExpression(last, predicate);
            ExpressionTool.copyLocationInfo(pathExp, fe);
            this.trace("Moved predicate to outer level of path expression: ", fe);
            return fe;
        }
        return null;
    }

    private FilterExpression expandComplexFilter(Expression base, Expression predicate) {
        ArrayList list = new ArrayList(4);
        BooleanExpression.listAndComponents(predicate, list);
        for (int i = 0; i < list.size(); ++i) {
            FilterExpression fe = new FilterExpression(base, (Expression)list.get(i));
            ExpressionTool.copyLocationInfo(base, fe);
            base = fe;
        }
        this.trace("Split composite predicate into multiple predicates: ", base);
        return (FilterExpression)base;
    }

    @Override
    public int isIndexableFilter(Expression filter) {
        if (filter instanceof ComparisonExpression && ((ComparisonExpression)((Object)filter)).getSingletonOperator() == 50) {
            return OptimizerEE.isIndexableComparison((ComparisonExpression)((Object)filter));
        }
        return 0;
    }

    private static int isIndexableComparison(ComparisonExpression filter) {
        boolean d1v;
        Expression op0 = filter.getOperands()[0];
        Expression op1 = filter.getOperands()[1];
        boolean d0f = ExpressionTool.dependsOnFocus(op0);
        boolean d0v = (op0.getDependencies() & 0x80) != 0;
        boolean d1f = ExpressionTool.dependsOnFocus(op1);
        boolean bl = d1v = (op1.getDependencies() & 0x80) != 0;
        if (d0f && !d1f && !d0v) {
            return 1;
        }
        if (d1f && !d0f && !d1v) {
            return -1;
        }
        return 0;
    }

    @Override
    public ValueRepresentation makeIndexedValue(SequenceIterator iter) throws XPathException {
        return new IndexedValue(iter);
    }

    @Override
    public Expression makeConditionalDocumentSorter(DocumentSorter sorter, PathExpression path) {
        Expression head;
        Expression h2 = head = path.getFirstStep();
        if (head instanceof ItemChecker && ((ItemChecker)head).getRequiredType() instanceof NodeTest) {
            h2 = ((ItemChecker)head).getBaseExpression();
        }
        Expression steps = path.getRemainingSteps();
        int stepProps = steps.getSpecialProperties();
        if (h2 instanceof VariableReference && (stepProps & 0x20000) != 0) {
            Expression ref = head.copy();
            TailExpression tailExp = new TailExpression(ref, 2);
            FunctionCall exists = SystemFunction.makeSystemFunction("exists", new Expression[]{tailExp});
            return new ConditionalSorter(exists, sorter);
        }
        return sorter;
    }

    @Override
    public Expression tryInlineFunctionCall(UserFunctionCall functionCall, ExpressionVisitor visitor, ItemType contextItemType) {
        boolean isInlineable;
        UserFunction function = functionCall.getFunction();
        Boolean b = function.isInlineable();
        if (b == null) {
            ArrayList calledFunctions = new ArrayList(10);
            ExpressionTool.gatherCalledFunctions(function.getBody(), calledFunctions);
            isInlineable = calledFunctions.isEmpty() && !OptimizerEE.changesXsltContext(function.getBody()) && ExpressionTool.expressionSize(function.getBody()) <= 15 && !function.isMemoFunction();
            function.setInlineable(isInlineable);
        } else {
            isInlineable = b;
        }
        if (isInlineable) {
            Expression newBody;
            try {
                newBody = function.getBody().copy();
            }
            catch (UnsupportedOperationException err) {
                if (!"StreamingCopy.copy()".equals(err.getMessage())) {
                    this.getConfiguration().getStandardErrorOutput().println("Failed to inline function " + function.getFunctionName().getDisplayName() + ": " + err.getMessage());
                    err.printStackTrace();
                    throw err;
                }
                return functionCall;
            }
            UserFunctionParameter[] params = function.getParameterDefinitions();
            for (int p = params.length - 1; p >= 0; --p) {
                UserFunctionParameter param = params[p];
                LetExpression let = new LetExpression();
                let.setRequiredType(param.getRequiredType());
                let.setVariableQName(param.getVariableQName());
                let.setSequence(functionCall.getArguments()[p]);
                let.setAction(newBody);
                ExpressionTool.rebindVariableReferences(newBody, param, let);
                newBody = let;
            }
            newBody.setContainer(functionCall.getContainer());
            try {
                StructuredQName fName = function.getFunctionName();
                this.trace("Moved function " + (fName == null ? "(anonymous)" : fName.getDisplayName()) + " inline: ", newBody);
                return newBody.simplify(visitor).typeCheck(visitor, contextItemType).optimize(visitor, contextItemType);
            }
            catch (XPathException e) {
                return functionCall;
            }
        }
        return functionCall;
    }

    private static boolean changesXsltContext(Expression exp) {
        if (exp instanceof ResultDocument || exp instanceof CallTemplate || exp instanceof ApplyTemplates || exp instanceof NextMatch || exp instanceof ApplyImports || exp instanceof RegexGroup || exp instanceof CurrentGroup) {
            return true;
        }
        Iterator<Expression> iter = exp.iterateSubExpressions();
        while (iter.hasNext()) {
            Expression sub = iter.next();
            if (!OptimizerEE.changesXsltContext(sub)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Expression promoteExpressionsToGlobal(Expression body, ExpressionVisitor visitor) throws XPathException {
        StaticContext env = visitor.getStaticContext();
        if (env instanceof QueryModule && ((QueryModule)env).getUserQueryContext().isGeneratingJavaCode()) {
            return null;
        }
        PromotionOffer offer = new PromotionOffer(this);
        offer.action = 15;
        offer.visitor = visitor;
        Expression replacement = body.promote(offer, null);
        if (offer.accepted) {
            return replacement;
        }
        return null;
    }

    @Override
    public Expression trySwitch(Choose choose, StaticContext env) {
        if (env instanceof QueryModule && ((QueryModule)env).getUserQueryContext().isGeneratingJavaCode()) {
            return choose;
        }
        Expression[] conditions = choose.getConditions();
        Expression[] actions = choose.getActions();
        if (conditions.length < 4) {
            return choose;
        }
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        Expression commonlhs = null;
        BuiltInAtomicType commontype = null;
        XPathContext context = env.makeEarlyEvaluationContext();
        HashMap<Object, Expression> values = new HashMap<Object, Expression>(conditions.length);
        StringCollator collation = env.getCollation(env.getDefaultCollationName());
        Expression defaultAction = new Literal(EmptySequence.getInstance());
        for (int c = 0; c < conditions.length; ++c) {
            boolean isOtherwise;
            Expression condition = conditions[c];
            boolean bl = isOtherwise = c == conditions.length - 1 && Literal.isConstantBoolean(condition, true);
            if (isOtherwise) {
                defaultAction = actions[c];
                continue;
            }
            if (!(condition instanceof ComparisonExpression)) {
                return choose;
            }
            if (condition instanceof GeneralComparison) {
                return choose;
            }
            if (((ComparisonExpression)((Object)condition)).getSingletonOperator() != 50) {
                return choose;
            }
            Expression[] operands = ((ComparisonExpression)((Object)condition)).getOperands();
            Expression lhs = operands[0];
            Expression rhs = operands[1];
            if (!Literal.isAtomic(rhs)) {
                return choose;
            }
            if (c == 0) {
                commonlhs = lhs;
                commontype = (BuiltInAtomicType)rhs.getItemType(th).getPrimitiveItemType();
                if (!commontype.isOrdered()) {
                    return choose;
                }
            } else {
                if (!commonlhs.equals(lhs)) {
                    return choose;
                }
                if (!commontype.equals(rhs.getItemType(th).getPrimitiveItemType())) {
                    return choose;
                }
            }
            try {
                Object key = ((AtomicValue)((Literal)rhs).getValue()).getXPathComparable(false, collation, context);
                if (key == null) {
                    return choose;
                }
                if (values.get(key) != null) continue;
                values.put(key, actions[c]);
                continue;
            }
            catch (NoDynamicContextException err) {
                return choose;
            }
        }
        return new SwitchExpression(commonlhs, values, defaultAction, collation);
    }

    @Override
    public Expression extractGlobalVariables(Expression body, ExpressionVisitor visitor, PromotionOffer offer) throws XPathException {
        offer.accepted = true;
        if (body instanceof LazyExpression) {
            body = ((LazyExpression)body).getBaseExpression();
        }
        Executable exec = visitor.getExecutable();
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        List<StructuredQName> globals = exec.getGlobalVariableMap().getVariableMap();
        for (int i = 0; i < globals.size(); ++i) {
            GlobalVariable v = exec.getGlobalVariable(globals.get(i));
            if (v == null || v instanceof GlobalParam || v.isAssignable() || v.getSelectExpression() == null || !v.getSelectExpression().equals(body)) continue;
            VariableReference ref = new VariableReference(v);
            SequenceType type = SequenceType.makeSequenceType(body.getItemType(th), body.getCardinality());
            ref.setStaticType(type, null, body.getSpecialProperties() | 0x400000);
            return ref;
        }
        GlobalVariableDefinition gvd = new GlobalVariableDefinition();
        gvd.setIsParameter(false);
        gvd.setSystemId(body.getSystemId());
        gvd.setLineNumber(body.getLineNumber());
        gvd.setValueExpression(body);
        gvd.setRequiredType(SequenceType.makeSequenceType(body.getItemType(exec.getConfiguration().getTypeHierarchy()), body.getCardinality()));
        StructuredQName varName = new StructuredQName("gg", "http://saxon.sf.net/generated-global-variable", "gg" + gvd.hashCode());
        gvd.setVariableQName(varName);
        int slot = exec.getGlobalVariableMap().allocateSlotNumber(varName);
        VariableReference ref = new VariableReference();
        gvd.registerReference(ref);
        GlobalVariable gv = gvd.compile(exec, slot);
        visitor.setExecutable(exec);
        gvd.typeCheck(visitor);
        gv.init(body, varName);
        this.trace("Extracted global variable: ", body);
        return ref;
    }

    @Override
    public Expression makeStreamingApplyTemplates(ApplyTemplates inst) throws XPathException {
        Expression select = inst.getSelectExpression();
        if (ExpressionInverter.consumesStream(select)) {
            return null;
        }
        if (select instanceof Doc || select instanceof DocumentFn) {
            Expression documentExp = select;
            return new StreamingApplyTemplates(inst, documentExp, new NodeTestPattern(NodeKindTest.DOCUMENT));
        }
        if (select instanceof PathExpression) {
            ArrayList<String> reasonForFailure;
            PathExpression pexp = (PathExpression)select;
            Expression start = pexp.getFirstStep();
            if (!(start instanceof Doc) && !(start instanceof DocumentFn)) {
                this.trace("Cannot use streaming apply-templates: path must start with call on doc() or document()");
                return null;
            }
            Expression documentExp = start;
            Expression rest = pexp.getRemainingSteps();
            Pattern selectionPattern = this.makeStreamingPattern(rest, reasonForFailure = new ArrayList<String>());
            if (selectionPattern == null) {
                String msg = "(unspecified reason)";
                if (!reasonForFailure.isEmpty()) {
                    msg = reasonForFailure.get(0).toString();
                }
                this.trace("Cannot use streaming apply-templates: " + msg);
                return null;
            }
            return new StreamingApplyTemplates(inst, documentExp, selectionPattern);
        }
        if (select instanceof DocumentSorter) {
            this.trace("Cannot use streaming apply templates: expression is not provably in document order");
        } else {
            this.trace("Cannot use streaming apply templates: not a path expression");
        }
        return null;
    }

    @Override
    public RuleTarget makeInversion(Pattern pattern, Template template, NodeTest nodeTest) throws XPathException {
        if (pattern instanceof LocationPathPattern && ((LocationPathPattern)pattern).selectsOutwards()) {
            XPathException err = new XPathException("The pattern cannot be used for a streamable template because it contains a predicate that cannot be evaluated without repositioning the input stream", template);
            err.setErrorCode("SXST0064");
            throw err;
        }
        if (template.getBody() instanceof TraceInstruction) {
            XPathException err = new XPathException("Saxon restriction: code that uses streaming cannot be compiled with tracing enabled", template);
            err.setErrorCode("SXST0065");
            throw err;
        }
        TemplateInversion inv = new TemplateInversion(template, template.getExecutable().getConfiguration());
        inv.setStackFrame(template.getStackFrameMap());
        inv.invert(nodeTest);
        return inv;
    }

    @Override
    public Expression generateMultithreadedInstruction(Expression instruction) {
        if (instruction instanceof ForEach && this.config.isMultiThreading()) {
            ForEach base = (ForEach)instruction;
            return new MultithreadedForEach(base.getSelectExpression(), base.getActionExpression(), false, base.getNumberOfThreads());
        }
        return instruction;
    }
}

