/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr.ee;

import com.saxonica.expr.IndexedLookupExpression;
import java.util.ArrayList;
import java.util.HashSet;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.ComparisonKey;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;

public class GeneralComparisonEE
extends GeneralComparison {
    public GeneralComparisonEE(Expression p0, int op, Expression p1) {
        super(p0, op, p1);
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (this.singletonOperator == 50) {
            if (this.isIndexedVariable(this.operand0)) {
                return this.makeIndexTest((VariableReference)this.operand0, this.operand1, visitor, contextItemType);
            }
            if (this.isIndexedVariable(this.operand1)) {
                return this.makeIndexTest((VariableReference)this.operand1, this.operand0, visitor, contextItemType);
            }
        }
        return super.optimize(visitor, contextItemType);
    }

    private boolean isIndexedVariable(Expression exp) {
        Binding b;
        return exp instanceof VariableReference && (b = ((VariableReference)exp).getBinding()) instanceof LetExpression && ((LetExpression)b).isIndexedVariable() && Cardinality.allowsMany(exp.getCardinality());
    }

    private Expression makeIndexTest(VariableReference indexedVar, Expression other, ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        IndexedLookupExpression ife = new IndexedLookupExpression(indexedVar, other, this.getAtomicComparer());
        Expression exp = visitor.simplify(ife);
        return exp.typeCheck(visitor, contextItemType);
    }

    public Expression copy() {
        GeneralComparisonEE gc = new GeneralComparisonEE(this.operand0.copy(), this.operator, this.operand1.copy());
        gc.comparer = this.comparer;
        gc.singletonOperator = this.singletonOperator;
        gc.needsRuntimeCheck = this.needsRuntimeCheck;
        return gc;
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        if (this.singletonOperator == 50) {
            int count;
            SequenceIterator iter0 = this.operand0.iterate(context);
            SequenceIterator iter1 = this.operand1.iterate(context);
            if ((iter1.getProperties() & 2) != 0) {
                count = ((LastPositionFinder)((Object)iter1)).getLastPosition();
                if (count == 0) {
                    return false;
                }
                if (count == 1) {
                    AtomicValue v0;
                    AtomicValue v1 = (AtomicValue)iter1.next();
                    BuiltInAtomicType t1 = v1.getPrimitiveType();
                    do {
                        if ((v0 = (AtomicValue)iter0.next()) == null) {
                            return false;
                        }
                        if (!this.needsRuntimeCheck || Type.isGenerallyComparable(v0.getPrimitiveType(), t1, false)) continue;
                        XPathException e2 = new XPathException("Cannot compare " + Type.displayTypeName(v0) + " to " + Type.displayTypeName(v1));
                        e2.setErrorCode("XPTY0004");
                        e2.setLocator(this);
                        e2.setIsTypeError(true);
                        throw e2;
                    } while (!GeneralComparisonEE.compare(v0, this.singletonOperator, v1, this.comparer, false, context));
                    return true;
                }
            }
            if ((iter0.getProperties() & 2) != 0) {
                count = ((LastPositionFinder)((Object)iter0)).getLastPosition();
                if (count == 0) {
                    return false;
                }
                if (count == 1) {
                    AtomicValue v1;
                    AtomicValue v0 = (AtomicValue)iter0.next();
                    BuiltInAtomicType t0 = v0.getPrimitiveType();
                    do {
                        if ((v1 = (AtomicValue)iter1.next()) == null) {
                            return false;
                        }
                        if (!this.needsRuntimeCheck || Type.isGenerallyComparable(t0, v1.getPrimitiveType(), false)) continue;
                        XPathException e2 = new XPathException("Cannot compare " + Type.displayTypeName(v0) + " to " + Type.displayTypeName(v1));
                        e2.setErrorCode("XPTY0004");
                        e2.setLocator(this);
                        e2.setIsTypeError(true);
                        throw e2;
                    } while (!GeneralComparisonEE.compare(v0, this.singletonOperator, v1, this.comparer, false, context));
                    return true;
                }
            }
            return this.hashJoin(iter0, iter1, context, this.comparer);
        }
        return super.effectiveBooleanValue(context);
    }

    private boolean hashJoin(SequenceIterator iter1, SequenceIterator iter2, XPathContext context, AtomicComparer comparer) throws XPathException {
        BuiltInAtomicType ft2;
        AtomicValue first1 = (AtomicValue)iter1.next();
        if (first1 == null) {
            iter2.close();
            return false;
        }
        AtomicValue first2 = (AtomicValue)iter2.next();
        if (first2 == null) {
            iter1.close();
            return false;
        }
        ConversionRules rules = context.getConfiguration().getConversionRules();
        BuiltInAtomicType ft1 = first1.getPrimitiveType();
        if (ft1.isPrimitiveNumeric()) {
            ft1 = BuiltInAtomicType.NUMERIC;
        }
        if ((ft2 = first2.getPrimitiveType()).isPrimitiveNumeric()) {
            ft2 = BuiltInAtomicType.NUMERIC;
        }
        BuiltInAtomicType hashTableType = ft1 == ft2 ? ft1 : (ft1.equals(BuiltInAtomicType.UNTYPED_ATOMIC) ? ft2 : ft1);
        HashSet<ComparisonKey> set1 = new HashSet<ComparisonKey>(20);
        HashSet<ComparisonKey> set2 = null;
        ArrayList<AtomicValue> strays1 = null;
        ArrayList<AtomicValue> strays2 = null;
        boolean exhausted1 = false;
        boolean exhausted2 = false;
        do {
            if (!exhausted1) {
                BuiltInAtomicType t1 = ft1;
                AtomicValue v1 = first1;
                if (t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && !hashTableType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                    t1 = hashTableType;
                    ConversionResult result = v1.convert(hashTableType, true, rules);
                    if (result instanceof ValidationFailure) {
                        String msg = "Failure converting untypedAtomic value to " + hashTableType.getDisplayName() + " during comparison operation. " + ((ValidationFailure)result).getMessage();
                        XPathException err = new XPathException(msg, "FORG0001", context);
                        err.setLocator(this);
                        throw err;
                    }
                    v1 = (AtomicValue)result;
                }
                if (t1 == hashTableType) {
                    ComparisonKey k1 = comparer.getComparisonKey(v1);
                    if (set2 != null && set2.contains(k1)) {
                        iter1.close();
                        iter2.close();
                        return true;
                    }
                    if (!exhausted2) {
                        set1.add(k1);
                    }
                } else if (!hashTableType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && !Type.isComparable(t1, hashTableType, false)) {
                    String msg = "Cannot compare " + t1 + " to " + hashTableType;
                    XPathException err = new XPathException(msg, "XPTY0004", context);
                    err.setLocator(this);
                    throw err;
                }
                if (ft1 != hashTableType && strays2 != null) {
                    for (int i = 0; i < strays2.size(); ++i) {
                        try {
                            if (!GeneralComparisonEE.compare(first1, 50, (AtomicValue)strays2.get(i), comparer, false, context)) continue;
                            return true;
                        }
                        catch (XPathException e) {
                            XPathException err;
                            BuiltInAtomicType it1 = first1.getPrimitiveType();
                            BuiltInAtomicType it2 = ((AtomicValue)strays2.get(i)).getPrimitiveType();
                            if (it1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                                err = new XPathException("Cannot convert untypedAtomic value to type of second operand (" + it2 + ")");
                                err.setErrorCode("FORG0001");
                            } else if (it2.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                                err = new XPathException("Cannot convert untypedAtomic value to type of first operand (" + it1 + ")");
                                err.setErrorCode("FORG0001");
                            } else {
                                err = new XPathException("Cannot compare " + it1 + " to " + it2);
                                err.setErrorCode("XPTY0004");
                            }
                            err.setXPathContext(context);
                            err.setLocator(this);
                            throw err;
                        }
                    }
                }
                if ((ft1 != hashTableType || ft1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) && !exhausted2) {
                    if (strays1 == null) {
                        strays1 = new ArrayList<AtomicValue>(10);
                    }
                    strays1.add(first1);
                }
                if ((first1 = (AtomicValue)iter1.next()) == null) {
                    exhausted1 = true;
                } else {
                    ft1 = first1.getPrimitiveType();
                    if (ft1.isPrimitiveNumeric()) {
                        ft1 = BuiltInAtomicType.NUMERIC;
                    }
                }
            }
            if (exhausted2) continue;
            BuiltInAtomicType t2 = ft2;
            AtomicValue v2 = first2;
            if (t2.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && !hashTableType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                t2 = hashTableType;
                ConversionResult result = v2.convert(hashTableType, true, rules);
                if (result instanceof ValidationFailure) {
                    String msg = "Failure converting untypedAtomic value to " + hashTableType.getDisplayName() + " during comparison operation. " + ((ValidationFailure)result).getMessage();
                    XPathException de = new XPathException(msg, "FORG0001", context);
                    de.setLocator(this);
                    throw de;
                }
                v2 = (AtomicValue)result;
            }
            if (t2 == hashTableType) {
                ComparisonKey k2 = comparer.getComparisonKey(v2);
                if (set1.contains(k2)) {
                    iter1.close();
                    iter2.close();
                    return true;
                }
                if (!exhausted1) {
                    if (set2 == null) {
                        set2 = new HashSet<ComparisonKey>(20);
                    }
                    set2.add(k2);
                }
            }
            if (ft2 != hashTableType && strays1 != null) {
                for (int i = 0; i < strays1.size(); ++i) {
                    try {
                        if (!GeneralComparisonEE.compare(first2, 50, (AtomicValue)strays1.get(i), comparer, false, context)) continue;
                        return true;
                    }
                    catch (XPathException e) {
                        XPathException err;
                        BuiltInAtomicType it2 = first2.getPrimitiveType();
                        BuiltInAtomicType it1 = ((AtomicValue)strays1.get(i)).getPrimitiveType();
                        if (it1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                            err = new XPathException("Cannot convert untypedAtomic value to type of second operand (" + it2 + ")");
                            err.setErrorCode("FORG0001");
                        } else if (it2.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                            err = new XPathException("Cannot convert untypedAtomic value to type of first operand (" + it1 + ")");
                            err.setErrorCode("FORG0001");
                        } else {
                            err = new XPathException("Cannot compare " + it1 + " to " + it2);
                            err.setErrorCode("XPTY0004");
                        }
                        err.setXPathContext(context);
                        err.setLocator(this);
                        throw err;
                    }
                }
            }
            if ((ft2 != hashTableType || ft2.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) && !exhausted1) {
                if (strays2 == null) {
                    strays2 = new ArrayList<AtomicValue>(10);
                }
                strays2.add(first2);
            }
            if ((first2 = (AtomicValue)iter2.next()) == null) {
                exhausted2 = true;
                continue;
            }
            ft2 = first2.getPrimitiveType();
            if (!ft2.isPrimitiveNumeric()) continue;
            ft2 = BuiltInAtomicType.NUMERIC;
        } while (!exhausted1 || !exhausted2);
        return false;
    }

    protected GeneralComparison getInverseComparison() {
        return new GeneralComparisonEE(this.operand1, Token.inverse(this.operator), this.operand0);
    }

    protected void explainExtraAttributes(ExpressionPresenter out) {
        out.emitAttribute("cardinality", "many-to-many (SA)");
    }
}

