/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr;

import com.saxonica.functions.hof.AbstractFunctionItem;
import com.saxonica.functions.hof.DynamicFunctionCallDefinition;
import com.saxonica.functions.hof.FunctionItemExpression;
import com.saxonica.functions.hof.FunctionType;
import com.saxonica.functions.hof.UserFunctionItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.SuppliedParameterReference;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.Tokenizer;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.expr.sort.IntSet;
import net.sf.saxon.functions.IntegratedFunctionCall;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPath30Parser
extends ExpressionParser {
    private Stack<InlineFunctionDetails> inlineFunctionStack = new Stack();
    private String languageVersion = "3.0";

    public XPath30Parser() {
        this.allowXPath30Syntax = true;
    }

    public int getPermittedFunctions() {
        return 17;
    }

    @Override
    protected Expression parseLiteralFunctionItem() throws XPathException {
        this.checkLanguageVersion();
        return XPath30Parser.parseLiteralFunctionItem(this);
    }

    public static Expression parseLiteralFunctionItem(ExpressionParser p) throws XPathException {
        ItemType it;
        String uri;
        String[] parts;
        Tokenizer t = p.getTokenizer();
        String fname = t.currentTokenValue;
        int offset = t.currentTokenStartOffset;
        StaticContext env = p.getStaticContext();
        p.nextToken();
        p.expect(209);
        NumericValue number = NumericValue.parseNumber(t.currentTokenValue);
        if (!(number instanceof IntegerValue)) {
            p.grumble("Number following '#' must be an integer");
        }
        int arity = (int)((IntegerValue)number).longValue();
        p.nextToken();
        try {
            parts = p.getNameChecker().getQNameParts(fname);
        }
        catch (QNameException e) {
            p.grumble("Function name is not a valid QName: " + fname);
            return null;
        }
        if (parts[0].length() == 0) {
            uri = env.getDefaultFunctionNamespace();
        } else {
            try {
                uri = env.getURIForPrefix(parts[0]);
            }
            catch (XPathException err) {
                p.grumble(err.getMessage(), "XPST0081", offset);
                return null;
            }
        }
        StructuredQName functionName = new StructuredQName(parts[0], uri, parts[1]);
        if (uri.equals("http://www.w3.org/2001/XMLSchema") && (it = Type.getBuiltInItemType(uri, parts[1])) instanceof BuiltInAtomicType && !env.isAllowedBuiltInType((BuiltInAtomicType)it)) {
            p.grumble("The type " + fname + " is not recognized by a Basic XSLT Processor. ", "XPST0080", offset);
            return null;
        }
        AbstractFunctionItem fcf = null;
        try {
            fcf = AbstractFunctionItem.bind(functionName, arity, env, p.getDefaultContainer());
        }
        catch (XPathException e) {
            p.grumble(e.getMessage(), "XPST0017", offset);
        }
        FunctionItemExpression fie = new FunctionItemExpression(fcf);
        p.setLocation(fie, offset);
        return fie;
    }

    @Override
    public ItemType parseFunctionItemType() throws XPathException {
        this.checkLanguageVersion();
        return XPath30Parser.parseFunctionItemType(this);
    }

    public static ItemType parseFunctionItemType(ExpressionParser p) throws XPathException {
        Tokenizer t = p.getTokenizer();
        p.nextToken();
        ArrayList<SequenceType> argTypes = new ArrayList<SequenceType>(3);
        if (t.currentToken == 207 || t.currentToken == 17) {
            p.nextToken();
            p.expect(204);
            p.nextToken();
            return AnyFunctionType.getInstance();
        }
        while (t.currentToken != 204) {
            SequenceType arg = p.parseSequenceType();
            argTypes.add(arg);
            if (t.currentToken == 204) break;
            if (t.currentToken == 7) {
                p.nextToken();
                continue;
            }
            p.grumble("Expected ',' or ')' after function argument type, found '" + Token.tokens[t.currentToken] + '\'');
        }
        p.nextToken();
        if (t.currentToken == 71) {
            p.nextToken();
            SequenceType resultType = p.parseSequenceType();
            SequenceType[] argArray = new SequenceType[argTypes.size()];
            argArray = argTypes.toArray(argArray);
            return new FunctionType(argArray, resultType);
        }
        if (!argTypes.isEmpty()) {
            p.grumble("Result type must be given if an argument type is given: expected 'as (type)'");
            return null;
        }
        return AnyFunctionType.getInstance();
    }

    @Override
    protected Expression parseFunctionArgument() throws XPathException {
        if (this.t.currentToken == 213) {
            this.nextToken();
            return null;
        }
        return super.parseFunctionArgument();
    }

    @Override
    protected ItemType parseParenthesizedItemType() throws XPathException {
        this.checkLanguageVersion();
        this.nextToken();
        ItemType primaryType = this.parseItemType();
        this.expect(204);
        this.nextToken();
        return primaryType;
    }

    @Override
    protected Expression parseDynamicFunctionCall(Expression functionItem) throws XPathException {
        this.checkLanguageVersion();
        return XPath30Parser.parseDynamicFunctionCall(functionItem, this);
    }

    public static Expression parseDynamicFunctionCall(Expression functionItem, ExpressionParser p) throws XPathException {
        Tokenizer t = p.getTokenizer();
        int offset = t.currentTokenStartOffset;
        ArrayList<Expression> args = new ArrayList<Expression>(10);
        args.add(functionItem);
        p.nextToken();
        if (t.currentToken != 204) {
            Expression arg = p.parseExprSingle();
            args.add(arg);
            while (t.currentToken == 7) {
                p.nextToken();
                arg = p.parseExprSingle();
                args.add(arg);
            }
            p.expect(204);
        }
        p.nextToken();
        Expression[] arguments = new Expression[args.size()];
        args.toArray(arguments);
        DynamicFunctionCallDefinition fd = new DynamicFunctionCallDefinition();
        DynamicFunctionCallDefinition.DynamicFunctionCall f = (DynamicFunctionCallDefinition.DynamicFunctionCall)fd.makeCallExpression();
        f.setDefinition(fd, functionItem.getContainer());
        IntegratedFunctionCall fc = new IntegratedFunctionCall(f);
        StructuredQName functionName = new StructuredQName("saxon", "http://saxon.sf.net/", "call");
        fc.setFunctionName(functionName);
        fc.setArguments(arguments);
        p.setLocation(fc, offset);
        for (int a = 0; a < arguments.length; ++a) {
            fc.adoptChildExpression(arguments[a]);
        }
        return p.makeTracer(offset, fc, 2009, functionName);
    }

    @Override
    protected Expression parseInlineFunction() throws XPathException {
        this.checkLanguageVersion();
        return XPath30Parser.parseInlineFunction(this, this.inlineFunctionStack);
    }

    public static Expression parseInlineFunction(ExpressionParser p, Stack<InlineFunctionDetails> inlineFunctionStack) throws XPathException {
        FunctionItemExpression result;
        Tokenizer t = p.getTokenizer();
        int offset = t.currentTokenStartOffset;
        InlineFunctionDetails details = new InlineFunctionDetails();
        details.outerVariables = p.getRangeVariables();
        details.outerVariablesUsed = new ArrayList<Binding>(4);
        details.implicitParams = new ArrayList<UserFunctionParameter>(4);
        inlineFunctionStack.push(details);
        p.setRangeVariables(new Stack<Binding>());
        p.nextToken();
        HashSet<StructuredQName> paramNames = new HashSet<StructuredQName>(8);
        ArrayList<UserFunctionParameter> params = new ArrayList<UserFunctionParameter>(8);
        SequenceType resultType = SequenceType.ANY_SEQUENCE;
        int paramSlot = 0;
        while (t.currentToken != 204) {
            p.expect(21);
            p.nextToken();
            p.expect(201);
            String argName = t.currentTokenValue;
            StructuredQName argQName = p.makeStructuredQName(argName, false);
            if (paramNames.contains(argQName)) {
                p.grumble("Duplicate parameter name " + Err.wrap(t.currentTokenValue, 5), "XQST0039");
            }
            paramNames.add(argQName);
            SequenceType paramType = SequenceType.ANY_SEQUENCE;
            p.nextToken();
            if (t.currentToken == 71) {
                p.nextToken();
                paramType = p.parseSequenceType();
            }
            UserFunctionParameter arg = new UserFunctionParameter();
            arg.setRequiredType(paramType);
            arg.setVariableQName(argQName);
            arg.setSlotNumber(paramSlot++);
            params.add(arg);
            p.declareRangeVariable(arg);
            if (t.currentToken == 204) break;
            if (t.currentToken == 7) {
                p.nextToken();
                continue;
            }
            p.grumble("Expected ',' or ')' after function argument, found '" + Token.tokens[t.currentToken] + '\'');
        }
        t.setState(1);
        p.nextToken();
        if (t.currentToken == 71) {
            t.setState(2);
            p.nextToken();
            resultType = p.parseSequenceType();
        }
        p.expect(59);
        t.setState(0);
        p.nextToken();
        Expression body = p.parseExpression();
        p.expect(215);
        t.lookAhead();
        p.nextToken();
        int arity = paramNames.size();
        for (int i = 0; i < arity; ++i) {
            p.undeclareRangeVariable();
        }
        List<UserFunctionParameter> implicitParams = details.implicitParams;
        if (!implicitParams.isEmpty()) {
            int extraParams = implicitParams.size();
            UserFunction uf = new UserFunction();
            uf.setBody(body);
            int expandedArity = params.size() + extraParams;
            UserFunctionParameter[] paramArray = new UserFunctionParameter[expandedArity];
            for (int i = 0; i < params.size(); ++i) {
                paramArray[i] = (UserFunctionParameter)params.get(i);
            }
            int k = params.size();
            Iterator<UserFunctionParameter> it = implicitParams.iterator();
            while (it.hasNext()) {
                paramArray[k++] = it.next();
            }
            uf.setParameterDefinitions(paramArray);
            uf.setResultType(resultType);
            SlotManager stackFrame = p.getStaticContext().getConfiguration().makeSlotManager();
            for (int i = 0; i < expandedArity; ++i) {
                int slot = stackFrame.allocateSlotNumber(paramArray[i].getVariableQName());
                paramArray[i].setSlotNumber(slot);
            }
            ExpressionTool.allocateSlots(body, expandedArity, stackFrame);
            uf.setStackFrameMap(stackFrame);
            UserFunctionCall ufc = new UserFunctionCall();
            ufc.setFunction(uf);
            ufc.setStaticType(resultType);
            Expression[] actualParams = new SuppliedParameterReference[expandedArity];
            for (int i = 0; i < expandedArity; ++i) {
                actualParams[i] = new SuppliedParameterReference(i);
            }
            ufc.setArguments(actualParams);
            UserFunctionItem functionItem = new UserFunctionItem(ufc);
            FunctionItemExpression fie = new FunctionItemExpression(functionItem);
            p.setLocation(fie, offset);
            Expression base = fie;
            Literal firstBoundParam = new Literal(Int64Value.makeIntegerValue(arity + 1));
            for (int ip = 0; ip < implicitParams.size(); ++ip) {
                VariableReference var;
                UserFunctionParameter ufp = implicitParams.get(ip);
                Binding binding = details.outerVariablesUsed.get(ip);
                if (binding instanceof TemporaryXSLTVariableBinding) {
                    var = new LocalVariableReference();
                    ((TemporaryXSLTVariableBinding)binding).declaration.registerReference(var);
                } else {
                    var = new VariableReference(binding);
                }
                var.setStaticType(binding.getRequiredType(), null, 0);
                ufp.setRequiredType(binding.getRequiredType());
                base = SystemFunction.makeSystemFunction("partial-apply", new Expression[]{base, var, firstBoundParam});
            }
            result = base;
        } else {
            UserFunction uf = new UserFunction();
            uf.setBody(body);
            UserFunctionParameter[] paramArray = params.toArray(new UserFunctionParameter[params.size()]);
            uf.setParameterDefinitions(paramArray);
            uf.setResultType(resultType);
            SlotManager stackFrame = p.getStaticContext().getConfiguration().makeSlotManager();
            for (int i = 0; i < paramArray.length; ++i) {
                stackFrame.allocateSlotNumber(paramArray[i].getVariableQName());
            }
            ExpressionTool.allocateSlots(body, params.size(), stackFrame);
            uf.setStackFrameMap(stackFrame);
            UserFunctionCall ufc = new UserFunctionCall();
            ufc.setFunction(uf);
            ufc.setStaticType(resultType);
            Expression[] actualParams = new SuppliedParameterReference[arity];
            for (int i = 0; i < arity; ++i) {
                actualParams[i] = new SuppliedParameterReference(i);
            }
            ufc.setArguments(actualParams);
            UserFunctionItem functionItem = new UserFunctionItem(ufc);
            FunctionItemExpression fie = new FunctionItemExpression(functionItem);
            p.setLocation(fie, offset);
            result = fie;
        }
        p.setRangeVariables(details.outerVariables);
        inlineFunctionStack.pop();
        return result;
    }

    @Override
    protected Expression makeCurriedFunction(StructuredQName name, Expression[] args, IntSet placeMarkers) throws XPathException {
        return XPath30Parser.makeCurriedFunction(this.env, this.defaultContainer, name, args, placeMarkers);
    }

    public static Expression makeCurriedFunction(StaticContext env, Container container, StructuredQName name, Expression[] args, IntSet placeMarkers) throws XPathException {
        AbstractFunctionItem target = AbstractFunctionItem.bind(name, args.length, env, container);
        Expression targetExp = new Literal(Value.asValue(target));
        int j = 1;
        for (int i = 0; i < args.length; ++i) {
            if (placeMarkers.contains(i)) {
                ++j;
                continue;
            }
            Int64Value pos = new Int64Value(j);
            Expression[] paArgs = new Expression[]{targetExp, args[i], new Literal(pos)};
            targetExp = SystemFunction.makeSystemFunction("partial-apply", paArgs);
        }
        return targetExp;
    }

    @Override
    protected Binding findRangeVariable(StructuredQName qName) {
        Binding b = super.findRangeVariable(qName);
        if (b != null) {
            return b;
        }
        return XPath30Parser.findOuterRangeVariable(qName, this.inlineFunctionStack, this.env);
    }

    public static Binding findOuterRangeVariable(StructuredQName qName, Stack<InlineFunctionDetails> inlineFunctionStack, StaticContext env) {
        for (int s = inlineFunctionStack.size() - 1; s >= 0; --s) {
            InlineFunctionDetails details = (InlineFunctionDetails)inlineFunctionStack.get(s);
            Stack<Binding> outerVariables = details.outerVariables;
            for (int v = outerVariables.size() - 1; v >= 0; --v) {
                Binding b2 = (Binding)outerVariables.elementAt(v);
                if (!b2.getVariableQName().equals(qName)) continue;
                for (int bs = s; bs <= inlineFunctionStack.size() - 1; ++bs) {
                    details = (InlineFunctionDetails)inlineFunctionStack.get(bs);
                    boolean found = false;
                    for (int p = 0; p < details.outerVariablesUsed.size() - 1; ++p) {
                        if (details.outerVariablesUsed.get(p) != b2) continue;
                        b2 = details.implicitParams.get(p);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    details.outerVariablesUsed.add(b2);
                    UserFunctionParameter ufp = new UserFunctionParameter();
                    ufp.setVariableQName(qName);
                    ufp.setRequiredType(b2.getRequiredType());
                    details.implicitParams.add(ufp);
                    b2 = ufp;
                }
                return b2;
            }
        }
        if (env instanceof ExpressionContext) {
            XSLVariableDeclaration decl = ((ExpressionContext)env).getStyleElement().bindLocalVariable(qName);
            Binding innermostBinding = null;
            if (decl != null) {
                for (int bs = 0; bs <= inlineFunctionStack.size() - 1; ++bs) {
                    InlineFunctionDetails details = (InlineFunctionDetails)inlineFunctionStack.get(bs);
                    boolean found = false;
                    for (int p = 0; p < details.outerVariablesUsed.size() - 1; ++p) {
                        if (!details.outerVariablesUsed.get(p).getVariableQName().equals(qName)) continue;
                        innermostBinding = details.implicitParams.get(p);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    details.outerVariablesUsed.add(new TemporaryXSLTVariableBinding(decl));
                    UserFunctionParameter ufp = new UserFunctionParameter();
                    ufp.setVariableQName(qName);
                    ufp.setRequiredType(decl.getRequiredType());
                    details.implicitParams.add(ufp);
                    innermostBinding = ufp;
                }
                if (innermostBinding != null) {
                    return innermostBinding;
                }
            }
        }
        return null;
    }

    private void checkLanguageVersion() throws XPathException {
        if (!"3.0".equals(this.languageVersion)) {
            this.grumble("To use XPath 3.0 syntax, you must configure the XPath parser to handle it");
        }
    }

    @Override
    protected boolean isNamespaceTestAllowed() {
        try {
            this.checkLanguageVersion();
        }
        catch (XPathException e) {
            return false;
        }
        return true;
    }

    public static class TemporaryXSLTVariableBinding
    implements Binding {
        XSLVariableDeclaration declaration;

        public TemporaryXSLTVariableBinding(XSLVariableDeclaration decl) {
            this.declaration = decl;
        }

        public SequenceType getRequiredType() {
            return this.declaration.getRequiredType();
        }

        public ValueRepresentation evaluateVariable(XPathContext context) throws XPathException {
            throw new UnsupportedOperationException();
        }

        public boolean isGlobal() {
            return false;
        }

        public boolean isAssignable() {
            return false;
        }

        public int getLocalSlotNumber() {
            return 0;
        }

        public StructuredQName getVariableQName() {
            return this.declaration.getObjectName();
        }
    }

    public static class InlineFunctionDetails {
        Stack<Binding> outerVariables;
        List<Binding> outerVariablesUsed;
        List<UserFunctionParameter> implicitParams;
    }
}

