/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr;

import com.saxonica.expr.BreakInstr;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.LocalParamBlock;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.EmptySequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IterateInstr
extends Instruction {
    private Expression select;
    private LocalParamBlock initiallyExp;
    private Expression action;
    private Expression finallyExp;

    public IterateInstr(Expression select, LocalParamBlock initiallyExp, Expression action, Expression finallyExp) {
        this.select = select;
        this.action = action;
        this.initiallyExp = initiallyExp;
        this.finallyExp = finallyExp == null ? new Literal(EmptySequence.getInstance()) : finallyExp;
        this.adoptChildExpression(select);
        this.adoptChildExpression(initiallyExp);
        this.adoptChildExpression(action);
        this.adoptChildExpression(finallyExp);
    }

    @Override
    public int getInstructionNameCode() {
        return 164;
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    public Expression getInitialExpression() {
        return this.initiallyExp;
    }

    public Expression getActionExpression() {
        return this.action;
    }

    public Expression getOnCompletionExpression() {
        return this.finallyExp;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.select = visitor.simplify(this.select);
        visitor.simplify(this.initiallyExp);
        this.action = visitor.simplify(this.action);
        this.finallyExp = visitor.simplify(this.finallyExp);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        this.select = visitor.typeCheck(this.select, contextItemType);
        this.adoptChildExpression(this.select);
        visitor.typeCheck(this.initiallyExp, contextItemType);
        this.adoptChildExpression(this.initiallyExp);
        this.action = visitor.typeCheck(this.action, this.select.getItemType(th));
        this.adoptChildExpression(this.action);
        this.finallyExp = visitor.typeCheck(this.finallyExp, null);
        this.adoptChildExpression(this.finallyExp);
        if (Literal.isEmptySequence(this.select)) {
            return this.select;
        }
        if (Literal.isEmptySequence(this.action)) {
            return this.action;
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        this.select = visitor.optimize(this.select, contextItemType);
        this.adoptChildExpression(this.select);
        visitor.optimize(this.initiallyExp, contextItemType);
        this.adoptChildExpression(this.initiallyExp);
        this.action = this.action.optimize(visitor, this.select.getItemType(th));
        this.adoptChildExpression(this.action);
        this.finallyExp = this.finallyExp.optimize(visitor, null);
        this.adoptChildExpression(this.finallyExp);
        if (Literal.isEmptySequence(this.select)) {
            return this.select;
        }
        if (Literal.isEmptySequence(this.action)) {
            return this.action;
        }
        return this;
    }

    @Override
    public final ItemType getItemType(TypeHierarchy th) {
        if (Literal.isEmptySequence(this.finallyExp)) {
            return this.action.getItemType(th);
        }
        return Type.getCommonSuperType(this.action.getItemType(th), this.finallyExp.getItemType(th), th);
    }

    @Override
    public final boolean createsNewNodes() {
        return (this.action.getSpecialProperties() & this.finallyExp.getSpecialProperties() & 0x400000) == 0;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet target = this.select.addToPathMap(pathMap, pathMapNodeSet);
        return this.action.addToPathMap(pathMap, target);
    }

    @Override
    public int computeDependencies() {
        int dependencies = 0;
        dependencies |= this.select.getDependencies();
        dependencies |= this.initiallyExp.getDependencies();
        dependencies |= this.action.getDependencies() & 0xFFFFFFE1;
        return dependencies |= this.finallyExp.getDependencies() & 0xFFFFFFE1;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.select = this.doPromotion(this.select, offer);
        if (offer.action == 11 || offer.action == 10) {
            Binding[] savedBindingList = offer.bindingList;
            offer.bindingList = this.extendBindingList(offer.bindingList);
            this.doPromotion(this.initiallyExp, offer);
            this.action = this.doPromotion(this.action, offer);
            this.finallyExp = this.doPromotion(this.finallyExp, offer);
            offer.bindingList = savedBindingList;
        }
    }

    public Binding[] extendBindingList(Binding[] in) {
        LocalParam[] params = this.initiallyExp.getChildren();
        Binding[] newBindingList = new Binding[in.length + params.length];
        System.arraycopy(in, 0, newBindingList, 0, in.length);
        System.arraycopy(params, 0, newBindingList, in.length, params.length);
        return newBindingList;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        ArrayList<Expression> sub = new ArrayList<Expression>(8);
        sub.add(this.select);
        sub.add(this.initiallyExp);
        sub.add(this.action);
        sub.add(this.finallyExp);
        return sub.iterator();
    }

    @Override
    public Iterator<Expression> iterateSameFocusSubExpressions() {
        return new PairIterator(this.select, this.initiallyExp);
    }

    @Override
    public boolean hasLoopingSubexpression(Expression child) {
        return child == this.action;
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        if (this.initiallyExp == original) {
            this.initiallyExp = (LocalParamBlock)replacement;
            found = true;
        }
        if (this.action == original) {
            this.action = replacement;
            found = true;
        }
        if (this.finallyExp == original) {
            this.finallyExp = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public int getImplementationMethod() {
        return 4;
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        this.action.checkPermittedContents(parentType, env, false);
        this.finallyExp.checkPermittedContents(parentType, env, false);
    }

    @Override
    public Expression copy() {
        return new IterateInstr(this.select.copy(), (LocalParamBlock)this.initiallyExp.copy(), this.action.copy(), this.finallyExp.copy());
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Item item;
        SequenceIterator iter = this.select.iterate(context);
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(this);
        c2.setCurrentIterator(iter);
        c2.setCurrentTemplateRule(null);
        boolean tracing = context.getController().isTracing();
        TraceListener listener = tracing ? context.getController().getTraceListener() : null;
        this.initiallyExp.process(context);
        while ((item = iter.next()) != null) {
            UserFunction fn;
            if (tracing) {
                listener.startCurrentItem(item);
            }
            this.action.process(c2);
            if (tracing) {
                listener.endCurrentItem(item);
            }
            if ((fn = c2.getTailCallFunction()) == null || !fn.getFunctionName().equals(BreakInstr.SAXON_BREAK)) continue;
            iter.close();
            return null;
        }
        this.finallyExp.process(context);
        return null;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("iterate");
        this.select.explain(out);
        out.startSubsidiaryElement("params");
        this.initiallyExp.explain(out);
        out.endSubsidiaryElement();
        out.startSubsidiaryElement("action");
        this.action.explain(out);
        out.endSubsidiaryElement();
        if (!Literal.isEmptySequence(this.finallyExp)) {
            out.startSubsidiaryElement("on-completion");
            this.finallyExp.explain(out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }
}

