/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr;

import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Fork
extends Expression {
    private Block content;

    public Fork(Block content) {
        this.content = content;
    }

    public Expression[] getChildren() {
        return this.content.getChildren();
    }

    @Override
    public int computeCardinality() {
        return this.content.getCardinality();
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return this.content.getItemType(th);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression exp = visitor.typeCheck(this.content, contextItemType);
        if (exp != this.content) {
            return exp;
        }
        return this;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new MonoIterator(this.content);
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        Expression e2 = this.doPromotion(this.content, offer);
        if (!(e2 instanceof Block)) {
            return e2;
        }
        this.content = (Block)e2;
        return this;
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.content == original) {
            this.content = (Block)replacement;
            found = true;
        }
        return found;
    }

    @Override
    public Expression copy() {
        return new Fork((Block)this.content.copy());
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        this.content.process(context);
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("fork");
        this.content.explain(out);
        out.endElement();
    }
}

