/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr;

import com.saxonica.expr.EquivalenceComparer;
import java.io.Serializable;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;

public class EquivalenceComparison
extends BinaryExpression
implements ComparisonExpression {
    private AtomicComparer comparer;

    public EquivalenceComparison(Expression p1, int operator, Expression p2) {
        super(p1, operator, p2);
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        String defaultCollationName;
        Expression e2 = super.typeCheck(visitor, contextItemType);
        if (e2 != this) {
            return e2;
        }
        StaticContext env = visitor.getStaticContext();
        StringCollator collation = env.getCollation(defaultCollationName = env.getDefaultCollationName());
        if (collation == null) {
            collation = CodepointCollator.getInstance();
        }
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        Expression oldOp0 = this.operand0;
        Expression oldOp1 = this.operand1;
        this.operand0 = visitor.typeCheck(this.operand0, contextItemType);
        this.operand1 = visitor.typeCheck(this.operand1, contextItemType);
        Optimizer opt = visitor.getConfiguration().getOptimizer();
        this.operand0 = ExpressionTool.unsorted(opt, this.operand0, false);
        this.operand1 = ExpressionTool.unsorted(opt, this.operand1, false);
        SequenceType atomicType = SequenceType.OPTIONAL_ATOMIC;
        RoleLocator role0 = new RoleLocator(1, (Serializable)((Object)"eq"), 0);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, atomicType, false, role0, visitor);
        RoleLocator role1 = new RoleLocator(1, (Serializable)((Object)"eq"), 1);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, atomicType, false, role1, visitor);
        if (this.operand0 != oldOp0) {
            this.adoptChildExpression(this.operand0);
        }
        if (this.operand1 != oldOp1) {
            this.adoptChildExpression(this.operand1);
        }
        ItemType t0 = this.operand0.getItemType(th);
        ItemType t1 = this.operand1.getItemType(th);
        if (t0 instanceof EmptySequenceTest) {
            t0 = BuiltInAtomicType.ANY_ATOMIC;
        }
        if (t1 instanceof EmptySequenceTest) {
            t1 = BuiltInAtomicType.ANY_ATOMIC;
        }
        if (((AtomicType)t0).isExternalType() || ((AtomicType)t1).isExternalType()) {
            XPathException err = new XPathException("Cannot perform comparisons involving external objects");
            err.setIsTypeError(true);
            err.setErrorCode("XPTY0004");
            err.setLocator(this);
            throw err;
        }
        BuiltInAtomicType pt0 = (BuiltInAtomicType)t0.getPrimitiveItemType();
        BuiltInAtomicType pt1 = (BuiltInAtomicType)t1.getPrimitiveItemType();
        if (!(t0.equals(BuiltInAtomicType.ANY_ATOMIC) || t0.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || t1.equals(BuiltInAtomicType.ANY_ATOMIC) || t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || Type.isComparable(pt0, pt1, false))) {
            NamePool namePool = env.getNamePool();
            env.issueWarning("Cannot compare " + t0.toString(namePool) + " to " + t1.toString(namePool), this);
        }
        this.comparer = new EquivalenceComparer(collation, 632, visitor.getConfiguration().getConversionContext());
        return this;
    }

    public AtomicComparer getAtomicComparer() {
        return this.comparer;
    }

    public int getSingletonOperator() {
        return this.operator;
    }

    public boolean convertsUntypedToOther() {
        return false;
    }

    public int computeCardinality() {
        return 16384;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    public Expression copy() {
        EquivalenceComparison sc = new EquivalenceComparison(this.operand0.copy(), this.operator, this.operand1.copy());
        sc.comparer = this.comparer;
        return sc;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        AtomicValue v0 = (AtomicValue)this.operand0.evaluateItem(context);
        AtomicValue v1 = (AtomicValue)this.operand1.evaluateItem(context);
        if (v0 == null || v1 == null) {
            return v0 == v1;
        }
        return Type.isComparable(v0.getPrimitiveType(), v1.getPrimitiveType(), false) && this.comparer.comparesEqual(v0, v1);
    }

    protected void explainExtraAttributes(ExpressionPresenter out) {
        out.emitAttribute("cardinality", "singleton");
    }
}

