/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.deploy;

import net.sf.saxon.expr.EvaluableItem;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Value;

public class ItemClosure
extends Value {
    private EvaluableItem evaluator;
    private XPathContext savedContext;
    private int primitiveType;
    private Item value;

    protected ItemClosure() {
    }

    public ItemClosure(EvaluableItem evaluator, XPathContext context, int primitiveType) {
        this.evaluator = evaluator;
        this.savedContext = context;
        this.primitiveType = primitiveType;
    }

    private void eval() throws XPathException {
        if (this.evaluator != null) {
            this.value = this.evaluator.evaluateItem(this.savedContext);
            this.evaluator = null;
        }
    }

    public ItemType getItemType(TypeHierarchy th) {
        switch (this.primitiveType) {
            case 88: {
                return AnyItemType.getInstance();
            }
            case 0: {
                return AnyNodeTest.getInstance();
            }
            case 9: {
                return NodeKindTest.DOCUMENT;
            }
            case 1: {
                return NodeKindTest.ELEMENT;
            }
            case 2: {
                return NodeKindTest.ATTRIBUTE;
            }
            case 3: {
                return NodeKindTest.TEXT;
            }
            case 8: {
                return NodeKindTest.COMMENT;
            }
            case 7: {
                return NodeKindTest.PROCESSING_INSTRUCTION;
            }
            case 13: {
                return NodeKindTest.NAMESPACE;
            }
            case 632: {
                return BuiltInAtomicType.ANY_ATOMIC;
            }
        }
        return (AtomicType)BuiltInType.getSchemaType(this.primitiveType);
    }

    public int getCardinality() {
        return 24576;
    }

    public Item asItem() throws XPathException {
        this.eval();
        return this.value;
    }

    public Item itemAt(int n) throws XPathException {
        if (n == 0) {
            this.eval();
            return this.value;
        }
        return null;
    }

    public SequenceIterator iterate() throws XPathException {
        this.eval();
        return SingletonIterator.makeIterator(this.value);
    }

    public Value reduce() throws XPathException {
        this.eval();
        return Value.asValue(this.value);
    }

    public int getLength() throws XPathException {
        this.eval();
        return this.value == null ? 0 : 1;
    }

    public Comparable getSchemaComparable() {
        try {
            return this.reduce().getSchemaComparable();
        }
        catch (XPathException e) {
            throw new AssertionError((Object)"Internal error: Can't compare compiled item closure");
        }
    }
}

