/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.deploy;

import com.saxonica.deploy.ContextPredicateFunction;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public final class ContextFilteringIterator
implements SequenceIterator {
    private SequenceIterator base;
    private ContextPredicateFunction test;
    private XPathContext context;
    private Item current = null;
    private int position = 0;

    public ContextFilteringIterator(ContextPredicateFunction test, XPathContext context) {
        this.base = context.getCurrentIterator();
        this.test = test;
        this.context = context;
    }

    public Item next() throws XPathException {
        Item item;
        do {
            if ((item = this.base.next()) != null) continue;
            this.current = null;
            this.position = -1;
            return null;
        } while (!this.test.matches(this.context));
        this.current = item;
        ++this.position;
        return item;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public void close() {
    }

    public SequenceIterator getAnother() throws XPathException {
        SequenceIterator newBase = this.base.getAnother();
        XPathContextMinor c2 = this.context.newMinorContext();
        c2.setCurrentIterator(newBase);
        c2.setOrigin(this.context.getOrigin());
        return new ContextFilteringIterator(this.test, c2);
    }

    public int getProperties() {
        return 0;
    }
}

