/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.deploy;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.deploy.SharedApplicationDataHandler;
import com.saxonica.deploy.SimpleAtomicComparer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.lib.SaxonOutputKeys;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public abstract class CompiledQueryServlet
extends HttpServlet {
    protected Configuration config;
    protected Executable exec;
    protected NamePool namePool;
    protected TypeHierarchy th;
    protected SharedApplicationDataHandler sharedData;

    public void init() throws ServletException {
        ServletContext servletContext = this.getServletContext();
        Object sharedData = servletContext.getAttribute("com.saxonica.servlet.applicationdata");
        Configuration config = null;
        if (sharedData instanceof SharedApplicationDataHandler) {
            this.sharedData = (SharedApplicationDataHandler)sharedData;
            config = ((SharedApplicationDataHandler)sharedData).getConfiguration(servletContext);
        }
        if (config == null) {
            config = new EnterpriseConfiguration();
        }
        this.setConfiguration(config);
        try {
            this.initializeGlobals();
        }
        catch (XPathException err) {
            throw new ServletException((Throwable)err);
        }
    }

    public abstract void initializeGlobals() throws XPathException;

    public final void setConfiguration(Configuration config) {
        this.config = config;
        this.namePool = config.getNamePool();
        this.exec = new Executable(config);
        this.exec.setKeyManager(new KeyManager(config));
        this.th = config.getTypeHierarchy();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String name;
        Controller controller = this.newController();
        Properties props = new Properties();
        props.setProperty("method", "html");
        if (this.sharedData != null) {
            this.sharedData.handleServletRequest(req, controller);
            props = controller.getOutputProperties();
        } else {
            Enumeration e = req.getParameterNames();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                String value = req.getParameter(name);
                System.out.println("Set parameter " + name + " to " + value);
                controller.setParameter(name, (Object)new UntypedAtomicValue(value));
            }
        }
        try {
            controller.defineGlobalParameters();
        }
        catch (XPathException err) {
            throw new ServletException((Throwable)err);
        }
        controller.allocateGlobalVariables(this.getNumberOfGlobalVariables());
        Iterator vars = controller.iterateParameters();
        while (vars.hasNext()) {
            name = (String)vars.next();
            this.setExternalVariable(name, (ValueRepresentation)controller.getParameter(name), controller);
        }
        StreamResult result = new StreamResult((OutputStream)res.getOutputStream());
        try {
            this.runQuery(controller, result, props);
        }
        catch (XPathException err) {
            throw new ServletException((Throwable)err);
        }
    }

    protected void runQuery(Controller controller, Result result, Properties outputProperties) throws XPathException {
        OutputStream os;
        Properties baseProperties = controller.getOutputProperties();
        if (outputProperties != null) {
            Enumeration<?> iter = outputProperties.propertyNames();
            while (iter.hasMoreElements()) {
                String key = (String)iter.nextElement();
                String value = outputProperties.getProperty(key);
                try {
                    SaxonOutputKeys.checkOutputProperty(key, value, this.config);
                    baseProperties.setProperty(key, value);
                }
                catch (XPathException dynamicError) {
                    try {
                        outputProperties.remove(key);
                        controller.getErrorListener().warning(dynamicError);
                    }
                    catch (TransformerException err2) {
                        throw XPathException.makeXPathException(err2);
                    }
                }
            }
        }
        if (baseProperties.getProperty("method") == null) {
            baseProperties.setProperty("method", "xml");
        }
        XPathContextMajor context = controller.newXPathContext();
        TraceListener tracer = this.config.makeTraceListener();
        if (tracer != null) {
            controller.preEvaluateGlobals(context);
            tracer.open();
        }
        boolean mustClose = result instanceof StreamResult && ((StreamResult)result).getOutputStream() == null;
        SerializerFactory sf = this.getConfiguration().getSerializerFactory();
        PipelineConfiguration pipe = controller.makePipelineConfiguration();
        pipe.setHostLanguage(51);
        Receiver receiver = sf.getReceiver(result, pipe, baseProperties);
        context.changeOutputDestination(receiver, true, 3, null);
        context.getReceiver().open();
        try {
            this.process(context);
        }
        catch (XPathException err) {
            controller.reportFatalError(err);
            throw err;
        }
        if (tracer != null) {
            tracer.close();
        }
        context.getReceiver().close();
        if (mustClose && (os = ((StreamResult)result).getOutputStream()) != null) {
            try {
                os.close();
            }
            catch (IOException err) {
                throw new XPathException(err);
            }
        }
    }

    private Controller newController() {
        Controller controller = new Controller(this.config);
        controller.setExecutable(this.exec);
        this.exec.initializeBindery(controller.getBindery());
        return controller;
    }

    public final Configuration getConfiguration() {
        return this.config;
    }

    public Executable getExecutable() {
        return this.exec;
    }

    protected abstract int getNumberOfGlobalVariables();

    protected abstract void setExternalVariable(String var1, ValueRepresentation var2, Controller var3);

    public abstract void process(XPathContext var1) throws XPathException;

    protected void typeError(String message, String code, XPathContext context) throws XPathException {
        XPathException de = new XPathException(message);
        de.setErrorCode(code);
        de.setXPathContext(context);
        throw de;
    }

    protected void dynamicError(String message, String code, XPathContext context) throws XPathException {
        XPathException de = new XPathException(message);
        de.setErrorCode(code);
        de.setXPathContext(context);
        throw de;
    }

    protected NodeInfo getContextNode(Item item) throws XPathException {
        if (item instanceof NodeInfo) {
            return (NodeInfo)item;
        }
        if (item == null) {
            XPathException err = new XPathException("The context item for an axis step is undefined");
            err.setErrorCode("XPDY0002");
            err.setIsTypeError(true);
            throw err;
        }
        XPathException err = new XPathException("The context item for an axis step is not a node");
        err.setErrorCode("XPTY0020");
        err.setIsTypeError(true);
        throw err;
    }

    protected boolean generalCompare(SequenceIterator iter1, SequenceIterator iter2, SimpleAtomicComparer comparer, XPathContext context) throws XPathException {
        try {
            AtomicValue s1;
            Value seq2 = (Value)SequenceExtent.makeSequenceExtent(iter2);
            int count2 = seq2.getLength();
            if (count2 == 0) {
                return false;
            }
            if (count2 == 1) {
                AtomicValue s12;
                AtomicValue s2 = (AtomicValue)seq2.itemAt(0);
                while ((s12 = (AtomicValue)iter1.next()) != null) {
                    if (!comparer.compare(s12, s2)) continue;
                    return true;
                }
                return false;
            }
            while ((s1 = (AtomicValue)iter1.next()) != null) {
                AtomicValue s2;
                SequenceIterator e2 = seq2.iterate();
                while ((s2 = (AtomicValue)e2.next()) != null) {
                    if (!comparer.compare(s1, s2)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (ValidationException e) {
            XPathException err = new XPathException(e);
            err.setXPathContext(context);
            err.setErrorCodeQName(e.getErrorCodeQName());
            throw err;
        }
        catch (XPathException e) {
            if (e.getXPathContext() == null) {
                e.setXPathContext(context);
            }
            throw e;
        }
    }
}

