/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.trans.LicenseException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DayTimeDurationValue;

public class Verifier {
    private static final int MS_A_DAY = 86400000;
    protected Properties features;
    private static final String PUBLIC_KEY = "308201B73082012C06072A8648CE3804013082011F02818100FD7F53811D75122952DF4A9C2EECE4E7F611B7523CEF4400C31E3F80B6512669455D402251FB593D8D58FABFC5F5BA30F6CB9B556CD7813B801D346FF26660B76B9950A5A49F9FE8047B1022C24FBBA9D7FEB7C61BF83B57E7C6A8A6150F04FB83F6D3C51EC3023554135A169132F675F3AE2B61D72AEFF22203199DD14801C70215009760508F15230BCCB292B982A2EB840BF0581CF502818100F7E1A085D69B3DDECBBCAB5C36B857B97994AFBBFA3AEA82F9574C0B3D0782675159578EBAD4594FE67107108180B449167123E84C281613B7CF09328CC8A6E13C167A8B547C8D28E0A3AE1E2BB3A675916EA37F0BFA213562F1FB627A01243BCCA4F1BEA8519089A883DFE15AE59F06928B665E807B552564014C3BFECF492A038184000281806CA067E469754A2F98D08965D35AB41252974F69FCD260152CFB58F94D8B956D6A1A91CC213A11107301DD37C85B383DDA409EC067D2A8C4BE6651020A69AFD533630172D6F96F928667D7705D46E56D364E8E967002A7D864BACB02225F52B271BA1F6522D98FF8299C6273B24BC41202C8857897E46B40FD7624A9CB0CC9E8";
    private static byte[] key = Verifier.convertHexToBinary("308201B73082012C06072A8648CE3804013082011F02818100FD7F53811D75122952DF4A9C2EECE4E7F611B7523CEF4400C31E3F80B6512669455D402251FB593D8D58FABFC5F5BA30F6CB9B556CD7813B801D346FF26660B76B9950A5A49F9FE8047B1022C24FBBA9D7FEB7C61BF83B57E7C6A8A6150F04FB83F6D3C51EC3023554135A169132F675F3AE2B61D72AEFF22203199DD14801C70215009760508F15230BCCB292B982A2EB840BF0581CF502818100F7E1A085D69B3DDECBBCAB5C36B857B97994AFBBFA3AEA82F9574C0B3D0782675159578EBAD4594FE67107108180B449167123E84C281613B7CF09328CC8A6E13C167A8B547C8D28E0A3AE1E2BB3A675916EA37F0BFA213562F1FB627A01243BCCA4F1BEA8519089A883DFE15AE59F06928B665E807B552564014C3BFECF492A038184000281806CA067E469754A2F98D08965D35AB41252974F69FCD260152CFB58F94D8B956D6A1A91CC213A11107301DD37C85B383DDA409EC067D2A8C4BE6651020A69AFD533630172D6F96F928667D7705D46E56D364E8E967002A7D864BACB02225F52B271BA1F6522D98FF8299C6273B24BC41202C8857897E46B40FD7624A9CB0CC9E8");

    protected int daysLeft() {
        String expiration = this.features.getProperty("Expiration");
        if (expiration == null) {
            return -1;
        }
        if (expiration.trim().length() == 0 || expiration.indexOf("never") != -1) {
            return 0;
        }
        try {
            String evaluating = this.features.getProperty("Evaluation");
            DateValue expiryDate = new DateValue(expiration);
            long expiryTimeMillis = expiryDate.getCalendar().getTime().getTime();
            long time = expiryTimeMillis - System.currentTimeMillis();
            if ("yes".equals(evaluating) && time / 300000L % 151L == 0L) {
                throw new LicenseException("Evaluation license temporarily suspended: please try again later", 1);
            }
            return 1 + (int)(time / 86400000L);
        }
        catch (XPathException err) {
            throw new LicenseException("Invalid expiry date found in license", 2);
        }
    }

    public String getFeature(String name, Configuration config) {
        if (this.features == null) {
            this.loadLicense(config);
        }
        return this.features.getProperty(name);
    }

    public void displayLicenseMessage(Configuration config) {
        int left;
        if (this.features == null) {
            this.loadLicense(config);
        }
        if ((left = this.daysLeft()) == 1) {
            config.getStandardErrorOutput().println("****** Saxon evaluation license expires tomorrow! ******");
        } else if (left > 0) {
            config.getStandardErrorOutput().println("Saxon evaluation license expires in " + this.daysLeft() + " days");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLicense(Configuration config) {
        InputStream is = null;
        try {
            String home;
            ArrayList<String> attempts = new ArrayList<String>(4);
            try {
                URL sourceLoc;
                CodeSource codeSource = this.getClass().getProtectionDomain().getCodeSource();
                if (codeSource != null && (sourceLoc = codeSource.getLocation()) != null) {
                    attempts.add(sourceLoc.toString() + "/saxon-license-lic");
                    URL licenseLoc = new URL(sourceLoc, "saxon-license.lic");
                    is = licenseLoc.openStream();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (is == null && (home = Configuration.getPlatform().getInstallationDirectory(Configuration.softwareEdition, config)) != null) {
                String path = home.endsWith("/") || home.endsWith("\\") ? home + "bin/saxon-license.lic" : home + "/bin/saxon-license.lic";
                attempts.add(path);
                try {
                    is = new FileInputStream(path);
                }
                catch (FileNotFoundException e) {
                    path = home.endsWith("/") || home.endsWith("\\") ? home + "saxon-license.lic" : home + "/saxon-license.lic";
                    attempts.add(path);
                    try {
                        is = new FileInputStream(path);
                    }
                    catch (FileNotFoundException e2) {
                        // empty catch block
                    }
                }
            }
            if (is == null) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = ClassLoader.getSystemClassLoader();
                }
                is = cl.getResourceAsStream("saxon-license.lic");
            }
            if (is == null) {
                attempts.add("classpath");
                String message = "License file saxon-license.lic not found. Tried in ";
                for (int i = 0; i < attempts.size(); ++i) {
                    message = message + (String)attempts.get(i);
                    message = message + ", ";
                }
                throw new LicenseException(message, 3);
            }
            this.readLicenseFile(is);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void loadLicense(File filename) {
        try {
            FileInputStream is = new FileInputStream(filename);
            this.readLicenseFile(is);
            is.close();
        }
        catch (IOException e) {
            throw new LicenseException("Failed to read license file " + filename, 3);
        }
    }

    private void readLicenseFile(InputStream is) {
        BufferedReader reader;
        try {
            reader = new BufferedReader(new InputStreamReader(is, "windows-1252"));
        }
        catch (UnsupportedEncodingException e) {
            throw new LicenseException("License file uses windows-1252, which is an unsupported encoding", 2);
        }
        this.configure(reader);
    }

    public void supplyLicenseKey(BufferedReader reader, Configuration config) {
        this.configure(reader);
        String value = this.features.getProperty("Company");
        if (value == null || !value.startsWith("OEM")) {
            throw new IllegalArgumentException("License key supplied is not a valid OEM license key");
        }
    }

    private void configure(BufferedReader reader) {
        try {
            DayTimeDurationValue sinceMinorRelease;
            DayTimeDurationValue sinceMajorRelease;
            String line;
            StringBuffer buffer = new StringBuffer(80);
            this.features = new Properties();
            String signature = "";
            while ((line = reader.readLine()) != null) {
                String value;
                String name;
                if (line.trim().indexOf(35) == 0 || line.trim().indexOf(33) == 0) continue;
                int index = line.indexOf(61);
                if (index > 0) {
                    name = line.substring(0, index).trim();
                    value = line.substring(++index).trim();
                } else {
                    name = line.trim();
                    value = "";
                }
                if ("".equals(name)) continue;
                this.features.setProperty(name, value);
                if ("Signature".equals(name)) {
                    signature = value;
                    continue;
                }
                buffer.append(name).append('=').append(value).append('\n');
            }
            boolean valid = Verifier.verify(buffer.toString(), Verifier.convertHexToBinary(signature), key);
            if (!valid) {
                throw new LicenseException("Invalid license file found", 2);
            }
            if (this.daysLeft() < 0) {
                throw new LicenseException("License (serial number " + this.getSerialNumber() + ") has expired", 1);
            }
            DateValue licenseIssued = new DateValue(this.features.getProperty("Issued").substring(0, 10) + 'Z');
            DateValue majorVersionIssued = new DateValue(Version.getMajorReleaseDate() + 'Z');
            String upgradeDays = this.features.getProperty("UpgradeDays");
            int udays = 366;
            if (upgradeDays != null) {
                udays = Integer.parseInt(upgradeDays.trim());
            }
            if ((sinceMajorRelease = majorVersionIssued.subtract(licenseIssued, null)).getLengthInSeconds() > (double)(86400 * udays)) {
                throw new LicenseException("The installed license (serial number " + this.getSerialNumber() + ") does not cover upgrade to this Saxon version", 1);
            }
            DateValue minorVersionIssued = new DateValue(Version.getReleaseDate() + 'Z');
            String maintenanceDays = this.features.getProperty("MaintenanceDays");
            int mdays = udays;
            if (maintenanceDays != null) {
                mdays = Integer.parseInt(maintenanceDays.trim());
            }
            if ((sinceMinorRelease = minorVersionIssued.subtract(licenseIssued, null)).getLengthInSeconds() > (double)(86400 * mdays)) {
                throw new LicenseException("The installed license (serial number " + this.getSerialNumber() + ") does not cover this Saxon maintenance release", 1);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new LicenseException("License file uses windows-1252, which is an unsupported encoding", 2);
        }
        catch (IOException e) {
            throw new LicenseException(e.getMessage(), 3);
        }
        catch (GeneralSecurityException e) {
            throw new LicenseException(e.getMessage(), 2);
        }
        catch (XPathException e) {
            throw new LicenseException("Invalid date in license file", 2);
        }
    }

    private String getSerialNumber() {
        return this.features.getProperty("Serial");
    }

    private static byte[] convertHexToBinary(String hex) {
        int len = hex.length() / 2;
        byte[] out = new byte[len];
        for (int i = 0; i < len; ++i) {
            char c1 = hex.charAt(i * 2);
            char c2 = hex.charAt(i * 2 + 1);
            if (c1 >= '0' && c1 <= '9') {
                out[i] = (byte)((c1 - 48) * 16);
            } else if (c1 >= 'A' && c1 <= 'F') {
                out[i] = (byte)((c1 - 65 + 10) * 16);
            } else {
                throw new IllegalArgumentException();
            }
            if (c2 >= '0' && c2 <= '9') {
                int n = i;
                out[n] = (byte)(out[n] + (c2 - 48));
                continue;
            }
            if (c2 >= 'A' && c2 <= 'F') {
                int n = i;
                out[n] = (byte)(out[n] + (c2 - 65 + 10));
                continue;
            }
            throw new IllegalArgumentException();
        }
        return out;
    }

    private static boolean verify(String data, byte[] signature, byte[] encodedPublicKey) throws GeneralSecurityException, UnsupportedEncodingException {
        Signature sig = Signature.getInstance("DSA");
        PublicKey key = KeyFactory.getInstance("DSA").generatePublic(new X509EncodedKeySpec(encodedPublicKey));
        sig.initVerify(key);
        sig.update(data.getBytes("windows-1252"));
        return sig.verify(signature);
    }

    public static void main(String[] args) throws Exception {
        File licenseFile = new File(args[0]);
        new Verifier().readLicenseFile(new FileInputStream(licenseFile));
        System.err.println("License OK");
    }
}

