/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.config;

import com.saxonica.config.DynamicLoaderPE;
import com.saxonica.config.EvaluationNuisance;
import com.saxonica.config.JavaExtensionLibrary;
import com.saxonica.config.Verifier;
import com.saxonica.expr.MemoFunction;
import com.saxonica.expr.Query30Parser;
import com.saxonica.expr.StaticQueryContextPE;
import com.saxonica.expr.XPath30Parser;
import com.saxonica.functions.extfn.ExtraFunctionLibrary;
import com.saxonica.functions.hof.FilterFn;
import com.saxonica.functions.hof.FoldLeftFn;
import com.saxonica.functions.hof.FoldRightFn;
import com.saxonica.functions.hof.FunctionType;
import com.saxonica.functions.hof.MapFn;
import com.saxonica.functions.hof.MapPairsFn;
import com.saxonica.functions.map.MapGet;
import com.saxonica.functions.map.MapKeys;
import com.saxonica.functions.map.MapNew;
import com.saxonica.functions.map.MapPut;
import com.saxonica.functions.xpath3.AnalyzeStringFn;
import com.saxonica.functions.xpath3.AvailableEnvironmentVariables;
import com.saxonica.functions.xpath3.FormatInteger;
import com.saxonica.functions.xpath3.GetEnvironmentVariable;
import com.saxonica.functions.xpath3.HeadFn;
import com.saxonica.functions.xpath3.ParseXml;
import com.saxonica.functions.xpath3.Pi;
import com.saxonica.functions.xpath3.Serialize;
import com.saxonica.functions.xpath3.TailFn;
import com.saxonica.functions.xpath3.TrigonometricFn;
import com.saxonica.functions.xslt3.CopyOfFn;
import com.saxonica.functions.xslt3.SnapshotFn;
import com.saxonica.ptree.PTreeSource;
import com.saxonica.pull.UnconstructedDocument;
import com.saxonica.pull.UnconstructedElement;
import com.saxonica.serialize.SerializerFactoryPE;
import com.saxonica.xsltextn.ExtensionElementFactory;
import com.saxonica.xsltextn.SaxonElementFactory;
import com.saxonica.xsltextn.StyleNodeFactoryPE;
import java.io.BufferedReader;
import java.io.File;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.DocumentInstr;
import net.sf.saxon.expr.instruct.ElementCreator;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.StandardFunction;
import net.sf.saxon.functions.UriCollection;
import net.sf.saxon.functions.VendorFunctionLibrary;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.query.QueryParser;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.SequenceType;

public class ProfessionalConfiguration
extends Configuration {
    private transient Verifier verifier;
    private boolean unlicensed = false;
    private boolean licensed = false;
    private transient HashMap<String, FunctionLibrary> extensionBinders;
    private transient HashMap<String, ExtensionElementFactory> xsltExtensionElementNamespaceMap;

    public ProfessionalConfiguration() {
        this.setDynamicLoader(new DynamicLoaderPE());
        this.verifier = new Verifier();
        this.declareBuiltInExtensionElementNamespaces();
        this.declareBuiltInExtensionFunctions();
        this.setSerializerFactory(new SerializerFactoryPE(this));
    }

    public static Configuration makeProfessionalConfiguration(ClassLoader classLoader, String className) throws RuntimeException {
        if (className == null) {
            className = "com.saxonica.config.ProfessionalConfiguration";
        }
        try {
            Class<?> theClass;
            ClassLoader loader = classLoader;
            if (loader == null) {
                try {
                    loader = Thread.currentThread().getContextClassLoader();
                }
                catch (Exception err) {
                    System.err.println("Failed to getContextClassLoader() - continuing");
                }
            }
            if (loader != null) {
                try {
                    theClass = loader.loadClass(className);
                }
                catch (Exception ex) {
                    theClass = Class.forName(className);
                }
            } else {
                theClass = Class.forName(className);
            }
            return (Configuration)theClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void importLicenseDetails(ProfessionalConfiguration other) {
        this.verifier = other.verifier;
        this.licensed = other.licensed;
        this.unlicensed = other.unlicensed;
        this.setLicensedFeatures();
    }

    public String getEditionCode() {
        return "PE";
    }

    public void setConfigurationProperty(String name, Object value) {
        if (name.equals("http://saxon.sf.net/feature/allow-old-java-uri-format")) {
            boolean b = this.requireBoolean(name, value);
            ((JavaExtensionLibrary)this.getExtensionBinder("java")).setStrictJavaUriFormat(!b);
        } else if (name.equals("http://saxonica.com/oem-data")) {
            this.supplyLicenseKey(new BufferedReader(new StringReader((String)value)));
        } else if (name.equals("http://saxon.sf.net/feature/licenseFileLocation")) {
            this.verifier.loadLicense(new File((String)value));
        } else {
            super.setConfigurationProperty(name, value);
        }
    }

    public Object getConfigurationProperty(String name) {
        if (name.equals("http://saxon.sf.net/feature/allow-old-java-uri-format")) {
            return ((JavaExtensionLibrary)this.getExtensionBinder("java")).isStrictJavaUriFormat();
        }
        return super.getConfigurationProperty(name);
    }

    public void supplyLicenseKey(BufferedReader reader) {
        this.verifier.supplyLicenseKey(reader, this);
        this.licensed = true;
        this.setLicensedFeatures();
    }

    protected String getFeature(String name) {
        String f = this.verifier.getFeature(name, this);
        if (!this.licensed) {
            this.licensed = true;
            this.setLicensedFeatures();
        }
        return f;
    }

    public boolean isLicensed() {
        return this.isLicensedFeature(64);
    }

    public final boolean isLicensedFeature(int feature) {
        if (this.unlicensed) {
            return false;
        }
        if (!this.licensed) {
            try {
                this.verifier.loadLicense(this);
                if (System.currentTimeMillis() % 100L == 42L && "yes".equals(this.verifier.getFeature("Evaluation", this))) {
                    SerializerFactoryPE sf = new SerializerFactoryPE(this){

                        public Receiver getReceiver(Result result, PipelineConfiguration pipe, Properties props) throws XPathException {
                            Receiver r = super.getReceiver(result, pipe, props);
                            if (!(r instanceof EvaluationNuisance)) {
                                EvaluationNuisance nuisance = new EvaluationNuisance();
                                nuisance.setUnderlyingReceiver(r);
                                nuisance.setPipelineConfiguration(pipe);
                                return nuisance;
                            }
                            return r;
                        }
                    };
                    this.setSerializerFactory(sf);
                }
                this.setLicensedFeatures();
            }
            catch (Exception e) {
                if (this.isTiming()) {
                    this.getStandardErrorOutput().println(e.getMessage() + ". Running with licensable features disabled");
                }
                this.unlicensed = true;
                return false;
            }
        }
        this.licensed = true;
        this.setLicensedFeatures();
        return this.testFeature(feature);
    }

    protected void setLicensedFeatures() {
    }

    protected boolean testFeature(int feature) {
        switch (feature) {
            case 1: {
                return false;
            }
            case 4: {
                return false;
            }
            case 2: {
                return false;
            }
            case 32: {
                return true;
            }
            case 16: {
                return true;
            }
            case 8: {
                return true;
            }
            case 64: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown feature " + feature);
    }

    public boolean isUnlicensed() {
        return this.unlicensed;
    }

    public final boolean isSchemaAware(int language) {
        switch (language) {
            case 52: {
                return this.isLicensedFeature(1);
            }
            case 50: {
                return this.isLicensedFeature(2);
            }
            case 51: {
                return this.isLicensedFeature(4);
            }
        }
        return false;
    }

    public void displayLicenseMessage() {
        this.verifier.displayLicenseMessage(this);
        this.licensed = true;
        this.setLicensedFeatures();
    }

    public StyleNodeFactory makeStyleNodeFactory() {
        if (!this.isLicensedFeature(64)) {
            return super.makeStyleNodeFactory();
        }
        return new StyleNodeFactoryPE(this);
    }

    public StaticQueryContext newStaticQueryContext() {
        return new StaticQueryContextPE(this);
    }

    public ExpressionParser newExpressionParser(String language, boolean updating, DecimalValue languageVersion) {
        if ("XQ".equals(language)) {
            if (updating) {
                throw new IllegalArgumentException("XQuery Update requires Saxon-EE");
            }
            if (DecimalValue.THREE.equals(languageVersion) || DecimalValue.ONE_POINT_ONE.equals(languageVersion)) {
                return new Query30Parser();
            }
            if (DecimalValue.ONE.equals(languageVersion)) {
                return new QueryParser();
            }
            throw new IllegalArgumentException("Unknown XQuery version " + languageVersion);
        }
        if ("XP".equals(language)) {
            if (DecimalValue.THREE.equals(languageVersion) || DecimalValue.TWO_POINT_ONE.equals(languageVersion)) {
                return new XPath30Parser();
            }
            if (DecimalValue.TWO.equals(languageVersion)) {
                return new ExpressionParser();
            }
            throw new IllegalArgumentException("Unknown XPath version " + languageVersion);
        }
        throw new IllegalArgumentException("Unknown expression language " + language);
    }

    public void setExtensionBinder(String scheme, FunctionLibrary binder) {
        if (this.extensionBinders == null) {
            this.extensionBinders = new HashMap(4);
        }
        this.extensionBinders.put(scheme, binder);
    }

    public FunctionLibrary getExtensionBinder(String scheme) {
        if (this.extensionBinders == null) {
            return null;
        }
        return this.extensionBinders.get(scheme);
    }

    public void addExtensionBinders(FunctionLibraryList list) {
        if (this.isAllowExternalFunctions() && this.extensionBinders != null) {
            Iterator<FunctionLibrary> it = this.extensionBinders.values().iterator();
            while (it.hasNext()) {
                list.addFunctionLibrary(it.next());
            }
        }
    }

    public VendorFunctionLibrary getVendorFunctionLibrary() {
        if (!this.isLicensedFeature(64)) {
            return super.getVendorFunctionLibrary();
        }
        if (this.vendorFunctionLibrary == null) {
            this.vendorFunctionLibrary = new ExtraFunctionLibrary(this);
        }
        return this.vendorFunctionLibrary;
    }

    public UserFunction newUserFunction(boolean memoFunction) {
        if (memoFunction) {
            return new MemoFunction();
        }
        return new UserFunction();
    }

    public void declareBuiltInExtensionFunctions() {
        try {
            this.registerExtensionFunction(new MapNew());
            this.registerExtensionFunction(new MapGet());
            this.registerExtensionFunction(new MapPut());
            this.registerExtensionFunction(new MapKeys());
            this.registerExtensionFunction(new TrigonometricFn.SinFn());
            this.registerExtensionFunction(new TrigonometricFn.CosFn());
            this.registerExtensionFunction(new TrigonometricFn.TanFn());
            this.registerExtensionFunction(new TrigonometricFn.AsinFn());
            this.registerExtensionFunction(new TrigonometricFn.AcosFn());
            this.registerExtensionFunction(new TrigonometricFn.AtanFn());
            this.registerExtensionFunction(new TrigonometricFn.SqrtFn());
            this.registerExtensionFunction(new Pi());
        }
        catch (XPathException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void declareBuiltInExtensionElementNamespaces() {
        try {
            this.setExtensionElementNamespace("http://saxon.sf.net/", SaxonElementFactory.class.getName());
        }
        catch (XPathException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void setExtensionElementNamespace(String namespace, String className) throws XPathException {
        if (this.xsltExtensionElementNamespaceMap == null) {
            this.xsltExtensionElementNamespaceMap = new HashMap(4);
        }
        try {
            ExtensionElementFactory factory = (ExtensionElementFactory)this.getInstance(className, null);
            this.xsltExtensionElementNamespaceMap.put(namespace, factory);
        }
        catch (ClassCastException e) {
            throw new XPathException("Class " + className + " is not an ExtensionElementFactory");
        }
    }

    public ExtensionElementFactory getExtensionElementFactory(String namespace) {
        if (this.xsltExtensionElementNamespaceMap == null) {
            return null;
        }
        return this.xsltExtensionElementNamespaceMap.get(namespace);
    }

    public Source resolveSource(Source source, Configuration config) throws XPathException {
        Source s = super.resolveSource(source, config);
        if (s != null) {
            return s;
        }
        if (this.isLicensedFeature(64)) {
            if (source instanceof PTreeSource) {
                return ((PTreeSource)source).load(this);
            }
            if (source instanceof PullProvider) {
                return source;
            }
        }
        return null;
    }

    public UnconstructedElement makeUnconstructedElement(ElementCreator instr, XPathContext context) throws XPathException {
        UnconstructedElement e = new UnconstructedElement(instr, context);
        e.setNameCode(instr.getNameCode(context, null));
        return e;
    }

    public UnconstructedDocument makeUnconstructedDocument(DocumentInstr instr, XPathContext context) throws XPathException {
        return new UnconstructedDocument(instr, context);
    }

    static {
        StandardFunction.Entry e = StandardFunction.register("analyze-string", AnalyzeStringFn.class, 0, 2, 3, NodeKindTest.ELEMENT, 16384, 16);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.arg(e, 2, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("available-environment-variables", AvailableEnvironmentVariables.class, 0, 0, 0, BuiltInAtomicType.STRING, 57344, 20);
        e = StandardFunction.register("copy-of", CopyOfFn.class, 0, 0, 1, AnyNodeTest.getInstance(), 24576, 64);
        StandardFunction.arg(e, 0, AnyNodeTest.getInstance(), 24576, StandardFunction.EMPTY);
        e = StandardFunction.register("filter", FilterFn.class, 0, 2, 2, AnyItemType.getInstance(), 57344, 16);
        FunctionType ft = new FunctionType(new SequenceType[]{SequenceType.SINGLE_ITEM}, SequenceType.SINGLE_BOOLEAN);
        StandardFunction.arg(e, 0, ft, 16384, null);
        StandardFunction.arg(e, 1, AnyItemType.getInstance(), 57344, StandardFunction.EMPTY);
        e = StandardFunction.register("fold-left", FoldLeftFn.class, 0, 3, 3, AnyItemType.getInstance(), 57344, 16);
        ft = new FunctionType(new SequenceType[]{SequenceType.ANY_SEQUENCE, SequenceType.SINGLE_ITEM}, SequenceType.ANY_SEQUENCE);
        StandardFunction.arg(e, 0, ft, 16384, null);
        StandardFunction.arg(e, 1, AnyItemType.getInstance(), 57344, null);
        StandardFunction.arg(e, 2, AnyItemType.getInstance(), 57344, null);
        e = StandardFunction.register("fold-right", FoldRightFn.class, 0, 3, 3, AnyItemType.getInstance(), 57344, 16);
        ft = new FunctionType(new SequenceType[]{SequenceType.SINGLE_ITEM, SequenceType.ANY_SEQUENCE}, SequenceType.ANY_SEQUENCE);
        StandardFunction.arg(e, 0, ft, 16384, null);
        StandardFunction.arg(e, 1, AnyItemType.getInstance(), 57344, null);
        StandardFunction.arg(e, 2, AnyItemType.getInstance(), 57344, null);
        e = StandardFunction.register("format-integer", FormatInteger.class, 0, 2, 3, AnyItemType.getInstance(), 16384, 16);
        StandardFunction.arg(e, 0, BuiltInAtomicType.INTEGER, 24576, null);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.arg(e, 2, BuiltInAtomicType.LANGUAGE, 24576, null);
        e = StandardFunction.register("get-environment-variable", GetEnvironmentVariable.class, 0, 1, 1, BuiltInAtomicType.STRING, 24576, 20);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 16384, null);
        e = StandardFunction.register("head", HeadFn.class, 0, 1, 1, AnyItemType.getInstance(), 24576, 16);
        StandardFunction.arg(e, 0, AnyItemType.getInstance(), 57344, null);
        e = StandardFunction.register("map", MapFn.class, 0, 2, 2, AnyItemType.getInstance(), 57344, 16);
        ft = new FunctionType(new SequenceType[]{SequenceType.SINGLE_ITEM}, SequenceType.ANY_SEQUENCE);
        StandardFunction.arg(e, 0, ft, 16384, null);
        StandardFunction.arg(e, 1, AnyItemType.getInstance(), 57344, StandardFunction.EMPTY);
        e = StandardFunction.register("map-pairs", MapPairsFn.class, 0, 3, 3, AnyItemType.getInstance(), 57344, 16);
        ft = new FunctionType(new SequenceType[]{SequenceType.SINGLE_ITEM, SequenceType.SINGLE_ITEM}, SequenceType.ANY_SEQUENCE);
        StandardFunction.arg(e, 0, ft, 16384, null);
        StandardFunction.arg(e, 1, AnyItemType.getInstance(), 57344, StandardFunction.EMPTY);
        StandardFunction.arg(e, 2, AnyItemType.getInstance(), 57344, StandardFunction.EMPTY);
        e = StandardFunction.register("parse-xml", ParseXml.class, 0, 1, 2, NodeKindTest.DOCUMENT, 16384, 16);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.arg(e, 1, BuiltInAtomicType.STRING, 24576, null);
        e = StandardFunction.register("serialize", Serialize.class, 0, 1, 2, BuiltInAtomicType.STRING, 16384, 16);
        StandardFunction.arg(e, 0, AnyNodeTest.getInstance(), 16384, null);
        StandardFunction.arg(e, 1, AnyNodeTest.getInstance(), 57344, null);
        e = StandardFunction.register("snapshot", SnapshotFn.class, 0, 0, 1, AnyNodeTest.getInstance(), 24576, 64);
        StandardFunction.arg(e, 0, AnyNodeTest.getInstance(), 24576, StandardFunction.EMPTY);
        e = StandardFunction.register("tail", TailFn.class, 0, 1, 1, AnyItemType.getInstance(), 57344, 16);
        StandardFunction.arg(e, 0, AnyItemType.getInstance(), 57344, null);
        e = StandardFunction.register("uri-collection", UriCollection.class, 0, 0, 1, BuiltInAtomicType.STRING, 57344, 64);
        StandardFunction.arg(e, 0, BuiltInAtomicType.STRING, 24576, StandardFunction.EMPTY);
    }
}

