/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.number.Numberer_en;
import net.sf.saxon.lib.Numberer;
import net.sf.saxon.option.local.Numberer_da;
import net.sf.saxon.option.local.Numberer_de;
import net.sf.saxon.option.local.Numberer_fr;
import net.sf.saxon.option.local.Numberer_frBE;
import net.sf.saxon.option.local.Numberer_it;
import net.sf.saxon.option.local.Numberer_nl;
import net.sf.saxon.option.local.Numberer_nlBE;
import net.sf.saxon.option.local.Numberer_sv;
import net.sf.saxon.trans.LocalizerFactory;

public class DotNetLocalizerFactory
extends LocalizerFactory
implements Serializable {
    private Configuration config;
    private HashMap<String, Class<? extends Numberer>> numbererClasses = new HashMap(10);
    private HashMap<String, Numberer> numbererInstances = new HashMap(10);

    public DotNetLocalizerFactory(Configuration config) {
        this.config = config;
        this.numbererClasses.put("en", Numberer_en.class);
        this.numbererClasses.put("da", Numberer_da.class);
        this.numbererClasses.put("de", Numberer_de.class);
        this.numbererClasses.put("fr", Numberer_fr.class);
        this.numbererClasses.put("frbe", Numberer_frBE.class);
        this.numbererClasses.put("it", Numberer_it.class);
        this.numbererClasses.put("nl", Numberer_nl.class);
        this.numbererClasses.put("nlBE", Numberer_nlBE.class);
        this.numbererClasses.put("sv", Numberer_sv.class);
    }

    public void setLanguageProperties(String lang, Properties properties) {
    }

    public Numberer getNumberer(String language, String country) {
        String classKey;
        String instanceKey;
        Numberer numberer;
        String defaultLanguage = this.config.getDefaultLanguage();
        if (language == null) {
            language = defaultLanguage;
        }
        String defaultCountry = this.config.getDefaultCountry();
        if (country == null) {
            country = defaultCountry;
        }
        if ((numberer = this.numbererInstances.get(instanceKey = (classKey = language.toLowerCase()) + "|" + country.toLowerCase())) != null) {
            return numberer;
        }
        Class<? extends Numberer> numbererClass = this.numbererClasses.get(classKey);
        if (numbererClass == null) {
            if (country.equals(defaultCountry) && language.equals(defaultLanguage)) {
                return null;
            }
            return this.getNumberer(defaultLanguage, defaultCountry);
        }
        try {
            numberer = numbererClass.newInstance();
            numberer.setCountry(country);
            this.numbererInstances.put(instanceKey, numberer);
            return numberer;
        }
        catch (InstantiationException e) {
            return new Numberer_en();
        }
        catch (IllegalAccessException e) {
            return new Numberer_en();
        }
    }

    public DotNetLocalizerFactory copy() {
        DotNetLocalizerFactory f = new DotNetLocalizerFactory(this.config);
        f.numbererClasses = this.numbererClasses;
        return f;
    }
}

