/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.validate.StatisticsReporter;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.Sink;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.CommandLineOptions;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.ValidationException;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class Validate {
    protected EnterpriseConfiguration config;
    protected Controller controller;
    protected boolean useURLs = false;
    protected boolean showTime = false;
    protected int repeat = 1;
    protected int validationMode = 1;
    protected int xsdLanguageVersion = 10;
    protected String topLevelElementName = null;
    protected StatisticsReporter statsReporter = null;

    public static void main(String[] args) throws Exception {
        new Validate().doValidate(args);
    }

    protected void setConfiguration() {
        this.config = new EnterpriseConfiguration();
    }

    public void setPermittedOptions(CommandLineOptions options) {
        options.addRecognizedOption("config", 258, "Use specified configuration file");
        options.addRecognizedOption("dtd", 4, "Validate using DTD");
        options.setPermittedValues("dtd", new String[]{"on", "off", "recover"}, "on");
        options.addRecognizedOption("ext", 1, "Allow calls to Java extension functions");
        options.addRecognizedOption("init", 3, "User-supplied net.sf.saxon.lib.Initializer class to initialize the Saxon Configuration");
        options.addRecognizedOption("limits", 10, "Limits for correct processing of minOccurs and maxOccurs");
        options.addRecognizedOption("opt", 261, "Use optimization level 0..10");
        options.addRecognizedOption("r", 259, "Use named URIResolver class");
        options.addRecognizedOption("s", 263, "List of source files to be validated");
        options.addRecognizedOption("scmin", 258, "Schema input file in SCM format");
        options.addRecognizedOption("scmout", 258, "Schema output file in SCM format");
        options.addRecognizedOption("stats", 258, "Statistics output file");
        options.addRecognizedOption("t", 1, "Display version and timing information, and names of schema documents loaded");
        options.addRecognizedOption("top", 6, "QName of required outermost element node");
        options.addRecognizedOption("u", 1, "Interpret filename arguments as URIs");
        options.setPermittedValues("u", new String[]{"on", "off"}, "on");
        options.addRecognizedOption("val", 260, "Apply strict or lax validation");
        options.setPermittedValues("val", new String[]{"strict", "lax"}, "strict");
        options.addRecognizedOption("x", 259, "Use named XMLReader class for parsing source documents");
        options.addRecognizedOption("xi", 1, "Expand XInclude directives in source documents");
        options.addRecognizedOption("xmlversion", 260, "Indicate whether XML 1.1 is supported");
        options.setPermittedValues("xmlversion", new String[]{"1.0", "1.1"}, null);
        options.addRecognizedOption("xsd", 263, "List of schema documents to be preloaded");
        options.addRecognizedOption("xsdversion", 260, "Indicate whether XSD 1.1 is supported");
        options.setPermittedValues("xsdversion", new String[]{"1.0", "1.1"}, null);
        options.addRecognizedOption("xsiloc", 1, "Load schemas named in xsi:schemaLocation (default on)");
        options.addRecognizedOption("y", 259, "Use named XMLReader class for parsing schema documents");
        options.addRecognizedOption("?", 512, "Display command line help text");
    }

    protected void doValidate(String[] args) {
        ArrayList<String> sourceFileNames = new ArrayList<String>();
        ArrayList<String> schemaFileNames = new ArrayList<String>();
        CommandLineOptions options = new CommandLineOptions();
        this.setPermittedOptions(options);
        try {
            options.setActualOptions(args);
        }
        catch (XPathException err) {
            Validate.quit(err.getMessage(), 2);
        }
        String configFile = options.getOptionValue("config");
        if (configFile != null) {
            try {
                Configuration fconfig = Configuration.readConfiguration(new StreamSource(configFile));
                if (!(fconfig instanceof EnterpriseConfiguration)) {
                    Validate.quit("Configuration produced from the configuration file is an instance of " + fconfig.getClass() + " (not EnterpriseConfiguration): check the value of configuration/@edition", 2);
                }
                this.config = (EnterpriseConfiguration)fconfig;
            }
            catch (XPathException e) {
                Validate.quit(e.getMessage(), 2);
            }
        }
        if (this.config == null) {
            this.setConfiguration();
        }
        this.config.setHostLanguage(52);
        try {
            options.applyToConfiguration(this.config);
            String value = options.getOptionValue("?");
            if (value != null) {
                this.badUsage("");
            }
            if ((value = options.getOptionValue("limits")) != null) {
                int comma = value.indexOf(44);
                if (comma < 1) {
                    this.badUsage("format: -limits:min,max");
                }
                int min = Integer.parseInt(value.substring(0, comma));
                int max = Integer.parseInt(value.substring(comma + 1));
                this.config.setOccurrenceLimits(min, max);
            }
            String scmInput = options.getOptionValue("scmin");
            String scmOutput = options.getOptionValue("scmout");
            value = options.getOptionValue("s");
            if (value != null) {
                StringTokenizer tokenizer = new StringTokenizer(value, ";");
                while (tokenizer.hasMoreTokens()) {
                    sourceFileNames.add(tokenizer.nextToken());
                }
            }
            if ((value = options.getOptionValue("t")) != null) {
                this.config.setTiming(true);
                this.showTime = true;
            }
            this.topLevelElementName = options.getOptionValue("top");
            this.useURLs = "on".equals(options.getOptionValue("u"));
            value = options.getOptionValue("val");
            if (value != null) {
                if ("strict".equals(value)) {
                    this.validationMode = 1;
                } else if ("lax".equals(value)) {
                    this.validationMode = 2;
                }
            }
            if ((value = options.getOptionValue("xsd")) != null) {
                StringTokenizer tokenizer = new StringTokenizer(value, ";");
                while (tokenizer.hasMoreTokens()) {
                    schemaFileNames.add(tokenizer.nextToken());
                }
            }
            this.xsdLanguageVersion = "1.1".equals(this.config.getConfigurationProperty("http://saxon.sf.net/feature/xsd-version")) ? 11 : 10;
            value = options.getOptionValue("stats");
            if (value != null) {
                StreamResult result = new StreamResult(new File(value));
                PipelineConfiguration pipe = this.config.makePipelineConfiguration();
                Properties props = new Properties();
                props.setProperty("method", "xml");
                props.setProperty("indent", "yes");
                Receiver statsReceiver = this.config.getSerializerFactory().getReceiver(result, pipe, props);
                this.statsReporter = new StatisticsReporter(statsReceiver);
            }
            for (String s : options.getPositionalOptions()) {
                sourceFileNames.add(s);
            }
            this.applyLocalOptions(options, this.config);
            if (!schemaFileNames.isEmpty() && scmInput != null) {
                this.badUsage("Cannot mix xsd and scm input");
            }
            if (schemaFileNames.isEmpty() && scmInput == null && sourceFileNames.isEmpty()) {
                this.badUsage("No action requested");
            }
            if (options.definesParameterValues()) {
                this.controller = new Controller(this.config);
                options.setParams(this.config, this.controller, null, new Properties());
            }
            if (this.showTime) {
                System.err.println(this.config.getProductTitle());
                System.err.println(Configuration.getPlatform().getPlatformVersion());
            }
            this.config.displayLicenseMessage();
            this.config.setSchemaValidationMode(this.validationMode);
            this.config.setValidationWarnings(true);
            long startTime = new Date().getTime();
            for (String schemaFileName : schemaFileNames) {
                Source schemaSource;
                if (this.useURLs || schemaFileName.startsWith("http:") || schemaFileName.startsWith("file:")) {
                    schemaSource = this.config.getURIResolver().resolve(schemaFileName, null);
                    if (schemaSource == null) {
                        schemaSource = this.config.getSystemURIResolver().resolve(schemaFileName, null);
                    }
                } else if (schemaFileName.equals("-")) {
                    schemaSource = Configuration.getPlatform().isJava() ? new SAXSource(this.config.getStyleParser(), new InputSource(System.in)) : new StreamSource(System.in);
                } else {
                    File schemaFile = new File(schemaFileName);
                    if (!schemaFile.exists()) {
                        Validate.quit("Schema file " + schemaFile + " does not exist", 2);
                    }
                    if (Configuration.getPlatform().isJava()) {
                        InputSource eis = new InputSource(schemaFile.toURI().toString());
                        schemaSource = new SAXSource(this.config.getStyleParser(), eis);
                    } else {
                        schemaSource = new StreamSource(schemaFile.toURI().toString());
                    }
                }
                if (schemaSource == null) {
                    Validate.quit("URIResolver for schema file must return a Source", 2);
                }
                this.config.addSchemaSource(schemaSource, null);
            }
            if (scmInput != null) {
                StreamSource scm = new StreamSource(new File(scmInput));
                this.config.importComponents(scm);
                this.config.setSchemaValidationMode(this.validationMode);
                this.config.setValidationWarnings(true);
            }
            if (this.controller != null) {
                this.controller.defineGlobalParameters();
                this.controller.getBindery().allocateGlobals(this.config.makeSlotManager());
            }
            if (this.showTime) {
                long endTime = new Date().getTime();
                System.err.println("Schema checking successful. Time: " + (endTime - startTime) + " milliseconds");
            }
            int validCount = 0;
            int invalidCount = 0;
            for (String sourceFileName : sourceFileNames) {
                try {
                    XMLReader parser;
                    Source source = Validate.loadDocument(sourceFileName, this.useURLs, this.config);
                    this.processFile(source);
                    if (this.showTime) {
                        System.err.println("Validation successful");
                    }
                    ++validCount;
                    if (!(source instanceof SAXSource) || (parser = ((SAXSource)source).getXMLReader()) == null) continue;
                    this.config.reuseSourceParser(parser);
                }
                catch (ValidationException e) {
                    System.err.println("Validation unsuccessful");
                    ++invalidCount;
                }
            }
            if (this.showTime && validCount + invalidCount > 1) {
                System.err.println(validCount + " valid document" + (validCount == 1 ? "" : "s") + "; " + invalidCount + " invalid document" + (invalidCount == 1 ? "" : "s"));
            }
            if (scmOutput != null) {
                File scmOutputFile = new File(scmOutput);
                Properties props = new Properties();
                props.setProperty("method", "xml");
                props.setProperty("indent", "yes");
                Receiver out = this.config.getSerializerFactory().getReceiver(new StreamResult(scmOutputFile), this.config.makePipelineConfiguration(), props);
                new SchemaModelSerializer(this.config, out).serialize();
                if (this.showTime) {
                    System.err.println("Schema component model written to " + scmOutputFile.getAbsolutePath());
                }
            }
        }
        catch (SchemaException err) {
            Validate.quit("Schema processing failed: " + err.getMessage(), 2);
        }
        catch (ValidationException err) {
            this.config.reportFatalError(err);
            Validate.quit("Validation of source document failed", 2);
        }
        catch (XPathException err) {
            this.config.reportFatalError(err);
            Validate.quit("Processing failed", 2);
        }
        catch (TransformerFactoryConfigurationError err) {
            Validate.quit("Validation failed: " + err.getMessage(), 2);
        }
        catch (Exception err2) {
            err2.printStackTrace();
            Validate.quit("Fatal error during validation: " + err2.getMessage(), 2);
        }
    }

    protected void applyLocalOptions(CommandLineOptions options, Configuration config) {
    }

    protected static void quit(String message, int code) {
        System.err.println(message);
        System.exit(code);
    }

    public static Source loadDocument(String sourceFileName, boolean useURLs, Configuration config) throws TransformerException {
        Source sourceInput;
        if (useURLs || sourceFileName.startsWith("http:") || sourceFileName.startsWith("file:")) {
            sourceInput = config.getURIResolver().resolve(sourceFileName, null);
            if (sourceInput == null) {
                sourceInput = config.getSystemURIResolver().resolve(sourceFileName, null);
            }
        } else if (sourceFileName.equals("-")) {
            sourceInput = Configuration.getPlatform().isJava() ? new SAXSource(config.getSourceParser(), new InputSource(System.in)) : new StreamSource(System.in);
        } else {
            File sourceFile = new File(sourceFileName);
            if (!sourceFile.exists()) {
                Validate.quit("Source file " + sourceFile + " does not exist", 2);
            }
            if (Configuration.getPlatform().isJava()) {
                InputSource eis = new InputSource(sourceFile.toURI().toString());
                sourceInput = new SAXSource(config.getSourceParser(), eis);
            } else {
                sourceInput = new StreamSource(sourceFile.toURI().toString());
            }
        }
        return sourceInput;
    }

    public void processFile(Source source) throws TransformerException {
        if (this.showTime) {
            System.err.println("Processing " + source.getSystemId());
        }
        long startTime = new Date().getTime();
        ParseOptions options = new ParseOptions();
        options.setSchemaValidationMode(this.validationMode);
        if (this.topLevelElementName != null) {
            options.setTopLevelElement(StructuredQName.fromClarkName(this.topLevelElementName));
        }
        if (this.statsReporter != null) {
            options.setValidationStatisticsRecipient(this.statsReporter);
        }
        options.setContinueAfterValidationErrors(true);
        options.setCheckEntityReferences(true);
        for (int r = 0; r < this.repeat; ++r) {
            PipelineConfiguration pipe = this.config.makePipelineConfiguration();
            pipe.setParseOptions(options);
            pipe.setController(this.controller);
            Sink sink = new Sink();
            sink.setPipelineConfiguration(pipe);
            Sender.send(source, sink, options);
        }
        if (this.showTime) {
            long endTime = new Date().getTime();
            System.err.println("Validation time: " + (endTime - startTime) + " milliseconds");
        }
    }

    protected void badUsage(String message) {
        if (!"".equals(message)) {
            System.err.println(message);
        }
        if (!this.showTime) {
            System.err.println(this.config.getProductTitle());
        }
        System.err.println("Usage: see http://www.saxonica.com/documentation/schema-processing/commandline.xml");
        System.err.println("Format: " + this.getClass().getName() + " options");
        CommandLineOptions options = new CommandLineOptions();
        this.setPermittedOptions(options);
        System.err.println("Options available:" + options.displayPermittedOptions());
        System.err.println("Use -XYZ:? for details of option XYZ");
        if ("".equals(message)) {
            System.exit(0);
        } else {
            System.exit(2);
        }
    }
}

