/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica;

import com.saxonica.config.EnterpriseConfiguration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.instruct.TerminationException;
import net.sf.saxon.trans.CommandLineOptions;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.InputSource;

public class CompileStylesheet {
    private boolean showTime = false;
    private boolean debug = false;

    public static void main(String[] args) throws Exception {
        new CompileStylesheet().doMain(args);
    }

    public void setPermittedOptions(CommandLineOptions options) {
        options.addRecognizedOption("config", 258, "Use specified configuration file");
        options.addRecognizedOption("debug", 1, "Trace the serialization activity");
        options.setPermittedValues("debug", new String[]{"on", "off"}, "on");
        options.addRecognizedOption("ext", 1, "Allow calls to Java extension functions and xsl:result-document");
        options.addRecognizedOption("init", 3, "User-supplied net.sf.saxon.lib.Initializer class to initialize the Saxon Configuration");
        options.addRecognizedOption("opt", 261, "Use optimization level 0..10");
        options.addRecognizedOption("r", 259, "Use named URIResolver class");
        options.addRecognizedOption("sa", 1, "Run in schema-aware mode");
        options.addRecognizedOption("t", 1, "Display version and timing information, and names of output files");
        options.addRecognizedOption("u", 1, "Interpret filename arguments as URIs");
        options.setPermittedValues("u", new String[]{"on", "off"}, "on");
        options.addRecognizedOption("versionmsg", 1, "Output warning when stylesheet specifies version='1.0");
        options.addRecognizedOption("xmlversion", 260, "Indicate whether XML 1.1 is supported");
        options.setPermittedValues("xmlversion", new String[]{"1.0", "1.1"}, null);
        options.addRecognizedOption("xsd", 263, "List of schema documents to be preloaded");
        options.addRecognizedOption("xsdversion", 260, "Indicate whether XSD 1.1 is supported");
        options.setPermittedValues("xsdversion", new String[]{"1.0", "1.1"}, null);
        options.addRecognizedOption("xsl", 258, "Stylesheet file");
        options.addRecognizedOption("y", 259, "Use named XMLReader class for parsing stylesheet and schema documents");
        options.addRecognizedOption("?", 512, "Display command line help text");
    }

    protected void doMain(String[] args) {
        String configFile;
        Configuration config = null;
        String styleFileName = null;
        boolean useURLs = false;
        String outputFileName = null;
        CommandLineOptions options = new CommandLineOptions();
        this.setPermittedOptions(options);
        try {
            options.setActualOptions(args);
        }
        catch (XPathException err) {
            CompileStylesheet.quit(err.getMessage(), 2);
        }
        if (!new EnterpriseConfiguration().isLicensedFeature(2)) {
            CompileStylesheet.quit("Compiling stylesheets requires a Saxon-EE license", 2);
        }
        if ((configFile = options.getOptionValue("config")) != null) {
            try {
                config = Configuration.readConfiguration(new StreamSource(configFile));
            }
            catch (XPathException e) {
                CompileStylesheet.quit(e.getMessage(), 2);
            }
        }
        if (config == null) {
            config = new EnterpriseConfiguration();
            config.setVersionWarning(true);
        }
        try {
            options.applyToConfiguration(config);
            String value = options.getOptionValue("?");
            if (value != null) {
                this.badUsage("");
            }
            if ((value = options.getOptionValue("sa")) != null) {
                config.getDefaultXsltCompilerInfo().setSchemaAware(true);
            }
            this.debug = "on".equals(options.getOptionValue("debug"));
            useURLs = "on".equals(options.getOptionValue("u"));
            value = options.getOptionValue("t");
            if (value != null) {
                System.err.println(config.getProductTitle());
                System.err.println(Configuration.getPlatform().getPlatformVersion());
                config.setTiming(true);
                this.showTime = true;
            }
            if ((value = options.getOptionValue("csout")) != null) {
                outputFileName = value;
            }
            if ((value = options.getOptionValue("xsl")) != null) {
                styleFileName = value;
            }
            this.applyLocalOptions(options, config);
            List<String> positional = options.getPositionalOptions();
            int currentPositionalOption = 0;
            if (styleFileName == null) {
                if (positional.size() == currentPositionalOption) {
                    this.badUsage("No input stylesheet file name");
                }
                styleFileName = positional.get(currentPositionalOption++);
            }
            if (outputFileName == null) {
                if (positional.size() == currentPositionalOption) {
                    this.badUsage("No file name for compiled stylesheet output");
                }
                outputFileName = positional.get(currentPositionalOption++);
            }
            if (currentPositionalOption < positional.size()) {
                this.badUsage("Unrecognized option: " + positional.get(currentPositionalOption));
            }
            this.compileStylesheet(config, styleFileName, outputFileName, useURLs);
        }
        catch (TerminationException err) {
            CompileStylesheet.quit(err.getMessage(), 1);
        }
        catch (XPathException err) {
            CompileStylesheet.quit("Stylesheet compilation failed: " + err.getMessage(), 2);
        }
        catch (TransformerConfigurationException err) {
            CompileStylesheet.quit("Stylesheet compilation failed: " + err.getMessage(), 2);
        }
        catch (TransformerFactoryConfigurationError err) {
            CompileStylesheet.quit("Stylesheet compilation failed: " + err.getMessage(), 2);
        }
        catch (Exception err2) {
            err2.printStackTrace();
        }
    }

    protected void compileStylesheet(Configuration config, String styleFileName, String outputFileName, boolean useURLs) throws TransformerException {
        Source styleSource;
        long startTime = new Date().getTime();
        if (useURLs || styleFileName.startsWith("http:") || styleFileName.startsWith("file:")) {
            styleSource = config.getURIResolver().resolve(styleFileName, null);
            if (styleSource == null) {
                styleSource = config.getSystemURIResolver().resolve(styleFileName, null);
            }
        } else {
            File sheetFile = new File(styleFileName);
            if (!sheetFile.exists()) {
                CompileStylesheet.quit("Stylesheet file " + sheetFile + " does not exist", 2);
            }
            InputSource eis = new InputSource(sheetFile.toURI().toString());
            styleSource = new SAXSource(config.getStyleParser(), eis);
        }
        if (styleSource == null) {
            CompileStylesheet.quit("URIResolver for stylesheet file must return a Source", 2);
        }
        PreparedStylesheet sheet = PreparedStylesheet.compile(styleSource, config, config.getDefaultXsltCompilerInfo());
        if (this.showTime) {
            long endTime = new Date().getTime();
            System.err.println("Stylesheet compilation time: " + (endTime - startTime) + " milliseconds");
        }
        try {
            System.err.println("Serializing compiled stylesheet");
            OutputStream fos = new FileOutputStream(outputFileName);
            if (this.debug) {
                fos = new TracingObjectOutputStream(fos);
            }
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(sheet);
            oos.close();
            System.err.println("Finished serializing stylesheet");
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    protected void applyLocalOptions(CommandLineOptions options, Configuration config) {
    }

    protected static void quit(String message, int code) {
        System.err.println(message);
        System.exit(code);
    }

    protected void badUsage(String message) {
        if (!"".equals(message)) {
            System.err.println(message);
        }
        System.err.println("Usage: see http://www.saxonica.com/documentation/using-xsl/compiling.html");
        System.err.println("Format: " + this.getClass().getName() + " options");
        CommandLineOptions options = new CommandLineOptions();
        this.setPermittedOptions(options);
        System.err.println("Options available:" + options.displayPermittedOptions());
        System.err.println("Use -XYZ:? for details of option XYZ");
        if ("".equals(message)) {
            System.exit(0);
        } else {
            System.exit(2);
        }
    }

    public static class TracingObjectOutputStream
    extends FilterOutputStream {
        OutputStream oos;

        public TracingObjectOutputStream(OutputStream oos) {
            super(oos);
            this.oos = oos;
        }

        public void write(byte[] b) throws IOException {
            char[] chars = new char[b.length];
            for (int i = 0; i < b.length; ++i) {
                chars[i] = (char)b[i];
            }
            String s = new String(chars);
            if (s.indexOf("saxon") >= 0) {
                System.err.println("write byte[]: " + s);
            }
            super.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            char[] chars = new char[len];
            for (int i = 0; i < len; ++i) {
                chars[i] = (char)b[i + off];
            }
            String s = new String(chars);
            if (s.indexOf("saxon") >= 0) {
                System.err.println("write byte[]: " + s);
            }
            super.write(b, off, len);
        }
    }
}

